/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import jdk.javadoc.internal.doclets.formats.html.AbstractIndexWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.IndexBuilder;

public class SingleIndexWriter
extends AbstractIndexWriter {
    private Set<Character> elements;

    public SingleIndexWriter(ConfigurationImpl configuration, DocPath filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename, indexbuilder);
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPaths.INDEX_ALL;
        try {
            SingleIndexWriter indexgen = new SingleIndexWriter(configuration, filename, indexbuilder);
            indexgen.generateIndexFile();
            indexgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateIndexFile() throws IOException {
        String title = this.configuration.getText("doclet.Window_Single_Index");
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : body;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            body.addContent(htmlTree);
        }
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.elements = new TreeSet<Character>(this.indexbuilder.getIndexMap().keySet());
        this.elements.addAll(this.configuration.tagSearchIndexKeys);
        this.addLinksForIndexes(divTree);
        for (Character unicode : this.elements) {
            if (this.configuration.tagSearchIndexMap.get(unicode) == null) {
                this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
                continue;
            }
            if (this.indexbuilder.getMemberList(unicode) == null) {
                this.addSearchContents(unicode, this.configuration.tagSearchIndexMap.get(unicode), divTree);
                continue;
            }
            this.addContents(unicode, this.indexbuilder.getMemberList(unicode), this.configuration.tagSearchIndexMap.get(unicode), divTree);
        }
        this.addLinksForIndexes(divTree);
        body.addContent(this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(divTree) : divTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            htmlTree = HtmlTree.FOOTER();
        }
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.createSearchIndexFiles();
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        for (Character ch : this.elements) {
            String unicode = ((Object)ch).toString();
            contentTree.addContent(this.getHyperLink(this.getNameForIndex(unicode), (Content)new StringContent(unicode)));
            contentTree.addContent(this.getSpace());
        }
    }
}

