/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.AnnotationTypeFieldWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.AnnotationTypeRequiredMemberWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.AnnotationTypeWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.ClassWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.ConstantsSummaryWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.ConstructorWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.EnumConstantWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.FieldWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.MethodWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.NestedClassWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.PackageWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.PropertyWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.SerializedFormWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeFieldWriter;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeOptionalMemberWriter;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeRequiredMemberWriter;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import jdk.javadoc.internal.doclets.toolkit.ClassWriter;
import jdk.javadoc.internal.doclets.toolkit.ConstantsSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import jdk.javadoc.internal.doclets.toolkit.WriterFactory;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class WriterFactoryImpl
implements WriterFactory {
    private final ConfigurationImpl configuration;

    public WriterFactoryImpl(ConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstantsSummaryWriter getConstantsSummaryWriter() throws Exception {
        return new ConstantsSummaryWriterImpl(this.configuration);
    }

    @Override
    public PackageSummaryWriter getPackageSummaryWriter(PackageElement packageElement, PackageElement prevPkg, PackageElement nextPkg) throws Exception {
        return new PackageWriterImpl(this.configuration, packageElement, prevPkg, nextPkg);
    }

    @Override
    public ClassWriter getClassWriter(TypeElement typeElement, TypeElement prevClass, TypeElement nextClass, ClassTree classTree) throws IOException {
        return new ClassWriterImpl(this.configuration, typeElement, prevClass, nextClass, classTree);
    }

    @Override
    public AnnotationTypeWriter getAnnotationTypeWriter(TypeElement annotationType, TypeMirror prevType, TypeMirror nextType) throws Exception {
        return new AnnotationTypeWriterImpl(this.configuration, annotationType, prevType, nextType);
    }

    @Override
    public AnnotationTypeFieldWriter getAnnotationTypeFieldWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeFieldWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public AnnotationTypeOptionalMemberWriter getAnnotationTypeOptionalMemberWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public AnnotationTypeRequiredMemberWriter getAnnotationTypeRequiredMemberWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeRequiredMemberWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public EnumConstantWriterImpl getEnumConstantWriter(ClassWriter classWriter) throws Exception {
        return new EnumConstantWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public FieldWriterImpl getFieldWriter(ClassWriter classWriter) throws Exception {
        return new FieldWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public PropertyWriterImpl getPropertyWriter(ClassWriter classWriter) throws Exception {
        return new PropertyWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public MethodWriterImpl getMethodWriter(ClassWriter classWriter) throws Exception {
        return new MethodWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public ConstructorWriterImpl getConstructorWriter(ClassWriter classWriter) throws Exception {
        return new ConstructorWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public MemberSummaryWriter getMemberSummaryWriter(ClassWriter classWriter, VisibleMemberMap.Kind memberType) throws Exception {
        switch (memberType) {
            case CONSTRUCTORS: {
                return this.getConstructorWriter(classWriter);
            }
            case ENUM_CONSTANTS: {
                return this.getEnumConstantWriter(classWriter);
            }
            case FIELDS: {
                return this.getFieldWriter(classWriter);
            }
            case PROPERTIES: {
                return this.getPropertyWriter(classWriter);
            }
            case INNER_CLASSES: {
                return new NestedClassWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
            }
            case METHODS: {
                return this.getMethodWriter(classWriter);
            }
        }
        return null;
    }

    @Override
    public MemberSummaryWriter getMemberSummaryWriter(AnnotationTypeWriter annotationTypeWriter, VisibleMemberMap.Kind memberType) throws Exception {
        switch (memberType) {
            case ANNOTATION_TYPE_FIELDS: {
                return (AnnotationTypeFieldWriterImpl)this.getAnnotationTypeFieldWriter(annotationTypeWriter);
            }
            case ANNOTATION_TYPE_MEMBER_OPTIONAL: {
                return (AnnotationTypeOptionalMemberWriterImpl)this.getAnnotationTypeOptionalMemberWriter(annotationTypeWriter);
            }
            case ANNOTATION_TYPE_MEMBER_REQUIRED: {
                return (AnnotationTypeRequiredMemberWriterImpl)this.getAnnotationTypeRequiredMemberWriter(annotationTypeWriter);
            }
        }
        return null;
    }

    @Override
    public SerializedFormWriter getSerializedFormWriter() throws Exception {
        return new SerializedFormWriterImpl(this.configuration);
    }
}

