/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.taglets;

import com.sun.source.doctree.DocTree;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.taglets.BaseExecutableMemberTaglet;
import jdk.javadoc.internal.doclets.toolkit.taglets.InheritableTaglet;
import jdk.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocFinder;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public class ThrowsTaglet
extends BaseExecutableMemberTaglet
implements InheritableTaglet {
    public ThrowsTaglet() {
        this.name = DocTree.Kind.THROWS.tagName;
    }

    @Override
    public void inherit(DocFinder.Input input, DocFinder.Output output) {
        Element exception;
        Utils utils = input.utils;
        CommentHelper ch = utils.getCommentHelper(input.element);
        if (input.tagId == null) {
            exception = ch.getException(utils.configuration, input.docTreeInfo.docTree);
            input.tagId = exception == null ? ch.getExceptionName(input.docTreeInfo.docTree).getSignature() : utils.getFullyQualifiedName(exception);
        } else {
            TypeElement element = input.utils.findClass(input.element, input.tagId);
            exception = element == null ? null : element;
        }
        for (DocTree docTree : input.utils.getThrowsTrees(input.element)) {
            Element texception = ch.getException(utils.configuration, docTree);
            if (texception != null && (input.tagId.equals(utils.getSimpleName(texception)) || input.tagId.equals(utils.getFullyQualifiedName(texception)))) {
                output.holder = input.element;
                output.holderTag = docTree;
                output.inlineTags = ch.getBody(input.utils.configuration, output.holderTag);
                output.tagList.add(docTree);
                continue;
            }
            if (exception == null || texception == null || !utils.isTypeElement(texception) || !utils.isTypeElement(exception) || !utils.isSubclassOf((TypeElement)texception, (TypeElement)exception)) continue;
            output.tagList.add(docTree);
        }
    }

    private Content linkToUndocumentedDeclaredExceptions(List<? extends TypeMirror> declaredExceptionTypes, Set<String> alreadyDocumented, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        Content result = writer.getOutputInstance();
        for (TypeMirror typeMirror : declaredExceptionTypes) {
            TypeElement klass = utils.asTypeElement(typeMirror);
            if (klass == null || alreadyDocumented.contains(utils.getSimpleName(klass)) || alreadyDocumented.contains(utils.getFullyQualifiedName(klass))) continue;
            if (alreadyDocumented.isEmpty()) {
                result.addContent(writer.getThrowsHeader());
            }
            result.addContent(writer.throwsTagOutput(typeMirror));
            alreadyDocumented.add(utils.getSimpleName(klass));
        }
        return result;
    }

    private Content inheritThrowsDocumentation(Element holder, List<? extends TypeMirror> declaredExceptionTypes, Set<String> alreadyDocumented, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        Content result = writer.getOutputInstance();
        if (utils.isExecutableElement(holder)) {
            LinkedHashMap<List<? extends DocTree>, ExecutableElement> declaredExceptionTags = new LinkedHashMap<List<? extends DocTree>, ExecutableElement>();
            for (TypeMirror typeMirror : declaredExceptionTypes) {
                DocFinder.Input input = new DocFinder.Input(utils, holder, this, utils.getTypeName(typeMirror, false));
                DocFinder.Output inheritedDoc = DocFinder.search(writer.configuration(), input);
                if (inheritedDoc.tagList.isEmpty()) {
                    String typeName = utils.getTypeName(typeMirror, true);
                    input = new DocFinder.Input(utils, holder, this, typeName);
                    inheritedDoc = DocFinder.search(writer.configuration(), input);
                }
                if (inheritedDoc.tagList.isEmpty()) continue;
                if (inheritedDoc.holder == null) {
                    inheritedDoc.holder = holder;
                }
                declaredExceptionTags.put(inheritedDoc.tagList, (ExecutableElement)inheritedDoc.holder);
            }
            result.addContent(this.throwsTagsOutput(declaredExceptionTags, writer, alreadyDocumented, false));
        }
        return result;
    }

    @Override
    public Content getTagletOutput(Element holder, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        ExecutableElement execHolder = (ExecutableElement)holder;
        LinkedHashMap<List<? extends DocTree>, ExecutableElement> tagsMap = new LinkedHashMap<List<? extends DocTree>, ExecutableElement>();
        tagsMap.put(utils.getThrowsTrees(execHolder), execHolder);
        Content result = writer.getOutputInstance();
        HashSet<String> alreadyDocumented = new HashSet<String>();
        if (!tagsMap.isEmpty()) {
            result.addContent(this.throwsTagsOutput(tagsMap, writer, alreadyDocumented, true));
        }
        result.addContent(this.inheritThrowsDocumentation(holder, execHolder.getThrownTypes(), alreadyDocumented, writer));
        result.addContent(this.linkToUndocumentedDeclaredExceptions(execHolder.getThrownTypes(), alreadyDocumented, writer));
        return result;
    }

    protected Content throwsTagsOutput(Map<List<? extends DocTree>, ExecutableElement> throwTags, TagletWriter writer, Set<String> alreadyDocumented, boolean allowDups) {
        Utils utils = writer.configuration().utils;
        Content result = writer.getOutputInstance();
        if (!throwTags.isEmpty()) {
            for (Map.Entry<List<? extends DocTree>, ExecutableElement> entry : throwTags.entrySet()) {
                CommentHelper ch = utils.getCommentHelper(entry.getValue());
                Element e = entry.getValue();
                for (DocTree docTree : entry.getKey()) {
                    Element te = ch.getException(utils.configuration, docTree);
                    String excName = ch.getExceptionName(docTree).toString();
                    if (!allowDups && (alreadyDocumented.contains(excName) || te != null && alreadyDocumented.contains(utils.getFullyQualifiedName(te)))) continue;
                    if (alreadyDocumented.isEmpty()) {
                        result.addContent(writer.getThrowsHeader());
                    }
                    result.addContent(writer.throwsTagOutput(e, docTree));
                    alreadyDocumented.add(te != null ? utils.getFullyQualifiedName(te) : excName);
                }
            }
        }
        return result;
    }
}

