/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import com.sun.jdi.ReferenceType;
import java.util.Arrays;
import java.util.HashMap;
import jdk.jshell.JShell;

class ClassTracker {
    private final JShell state;
    private final HashMap<String, ClassInfo> map;

    ClassTracker(JShell state) {
        this.state = state;
        this.map = new HashMap();
    }

    ClassInfo classInfo(String className, byte[] bytes) {
        ClassInfo ci = this.map.computeIfAbsent(className, k -> new ClassInfo((String)k));
        ci.setBytes(bytes);
        return ci;
    }

    ClassInfo get(String className) {
        return this.map.get(className);
    }

    class ClassInfo {
        private final String className;
        private byte[] bytes;
        private byte[] loadedBytes;
        private ReferenceType rt;

        private ClassInfo(String className) {
            this.className = className;
        }

        String getClassName() {
            return this.className;
        }

        byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        void setLoaded() {
            this.loadedBytes = this.bytes;
        }

        boolean isLoaded() {
            return Arrays.equals(this.loadedBytes, this.bytes);
        }

        ReferenceType getReferenceTypeOrNull() {
            if (this.rt == null) {
                this.rt = ClassTracker.this.state.executionControl().nameToRef(this.className);
            }
            return this.rt;
        }
    }
}

