/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MaskCommentsAndModifiers {
    private static final Set<String> IGNORED_MODIFERS = Stream.of("public", "protected", "private", "static", "final").collect(Collectors.toSet());
    private final StringBuilder sbCleared = new StringBuilder();
    private final StringBuilder sbMask = new StringBuilder();
    private final String str;
    private final int length;
    private final boolean maskModifiers;
    private int next = 0;
    private boolean wasMasked = false;
    private boolean inside = false;

    public MaskCommentsAndModifiers(String s, boolean maskModifiers) {
        this.str = s;
        this.length = s.length();
        this.maskModifiers = maskModifiers;
        while (this.next()) {
        }
    }

    public String cleared() {
        return this.sbCleared.toString();
    }

    public String mask() {
        return this.sbMask.toString();
    }

    public boolean wasMasked() {
        return this.wasMasked;
    }

    private int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    private void write(StringBuilder sb, int ch) {
        sb.append((char)ch);
    }

    private void write(int ch) {
        this.write(this.sbCleared, ch);
        this.write(this.sbMask, Character.isWhitespace(ch) ? ch : 32);
    }

    private void writeMask(int ch) {
        this.wasMasked = true;
        this.write(this.sbMask, ch);
        this.write(this.sbCleared, Character.isWhitespace(ch) ? ch : 32);
    }

    private void write(CharSequence s) {
        for (int cp : s.chars().toArray()) {
            this.write(cp);
        }
    }

    private void writeMask(CharSequence s) {
        for (int cp : s.chars().toArray()) {
            this.writeMask(cp);
        }
    }

    private boolean next() {
        return this.next(this.read());
    }

    private boolean next(int c) {
        if (c < 0) {
            return false;
        }
        if (c == 39 || c == 34) {
            this.inside = true;
            this.write(c);
            int match = c;
            c = this.read();
            while (c != match) {
                if (c < 0) {
                    return false;
                }
                if (c == 10 || c == 13) {
                    this.write(c);
                    return true;
                }
                if (c == 92) {
                    this.write(c);
                    c = this.read();
                }
                this.write(c);
                c = this.read();
            }
            this.write(c);
            return true;
        }
        if (c == 47) {
            c = this.read();
            if (c == 42) {
                this.writeMask(47);
                this.writeMask(c);
                int prevc = 0;
                while ((c = this.read()) != 47 || prevc != 42) {
                    if (c < 0) {
                        return false;
                    }
                    this.writeMask(c);
                    prevc = c;
                }
                this.writeMask(c);
                return true;
            }
            if (c == 47) {
                this.writeMask(47);
                this.writeMask(c);
                while ((c = this.read()) != 10 && c != 13) {
                    if (c < 0) {
                        return false;
                    }
                    this.writeMask(c);
                }
                this.writeMask(c);
                return true;
            }
            this.inside = true;
            this.write(47);
        }
        if (Character.isJavaIdentifierStart(c)) {
            if (this.maskModifiers && !this.inside) {
                StringBuilder sb = new StringBuilder();
                do {
                    this.write(sb, c);
                } while (Character.isJavaIdentifierPart(c = this.read()));
                String id = sb.toString();
                if (IGNORED_MODIFERS.contains(id)) {
                    this.writeMask(sb);
                } else {
                    this.write(sb);
                    if (id.equals("import")) {
                        this.inside = true;
                    }
                }
                return this.next(c);
            }
        } else if (!Character.isWhitespace(c)) {
            this.inside = true;
        }
        if (c < 0) {
            return false;
        }
        this.write(c);
        return true;
    }
}

