/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import java.util.Locale;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Name;
import jdk.internal.jshell.remote.RemoteCodes;

class Util {
    static final String REPL_CLASS_PREFIX = "$REPL";
    static final String REPL_DOESNOTMATTER_CLASS_NAME = "$REPL00DOESNOTMATTER";
    static final Locale PARSED_LOCALE = Locale.ROOT;

    Util() {
    }

    static boolean isDoIt(Name name) {
        return Util.isDoIt(name.toString());
    }

    static boolean isDoIt(String sname) {
        return sname.equals("do_it$");
    }

    static String expunge(String s) {
        StringBuilder sb = new StringBuilder();
        for (String comp : RemoteCodes.prefixPattern.split(s)) {
            sb.append(comp);
        }
        return sb.toString();
    }

    static String asLetters(int i) {
        if (i == 0) {
            return "";
        }
        char[] buf = new char[33];
        int charPos = 32;
        for (i = -i; i <= -26; i /= 26) {
            buf[charPos--] = (char)(65 - i % 26);
        }
        buf[charPos] = (char)(65 - i);
        return new String(buf, charPos, 33 - charPos);
    }

    static String trimEnd(String s) {
        int last;
        int i;
        for (i = last = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i != last) {
            return s.substring(0, i + 1);
        }
        return s;
    }

    static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static class Pair<T, U> {
        final T first;
        final U second;

        Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }
}

