package com.google.javascript.jscomp.colors;

import com.google.common.collect.ImmutableSet;
import javax.annotation.processing.Generated;
import org.jspecify.annotations.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_Color extends Color {

  private final ColorId id;

  private final ImmutableSet<Color> prototypes;

  private final ImmutableSet<Color> instanceColors;

  private final boolean invalidating;

  private final boolean propertiesKeepOriginalName;

  private final boolean constructor;

  private final ImmutableSet<String> ownProperties;

  private final @Nullable ColorId boxId;

  private final boolean closureAssert;

  private final ImmutableSet<Color> unionElements;

  $AutoValue_Color(
      ColorId id,
      ImmutableSet<Color> prototypes,
      ImmutableSet<Color> instanceColors,
      boolean invalidating,
      boolean propertiesKeepOriginalName,
      boolean constructor,
      ImmutableSet<String> ownProperties,
      @Nullable ColorId boxId,
      boolean closureAssert,
      ImmutableSet<Color> unionElements) {
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    if (prototypes == null) {
      throw new NullPointerException("Null prototypes");
    }
    this.prototypes = prototypes;
    if (instanceColors == null) {
      throw new NullPointerException("Null instanceColors");
    }
    this.instanceColors = instanceColors;
    this.invalidating = invalidating;
    this.propertiesKeepOriginalName = propertiesKeepOriginalName;
    this.constructor = constructor;
    if (ownProperties == null) {
      throw new NullPointerException("Null ownProperties");
    }
    this.ownProperties = ownProperties;
    this.boxId = boxId;
    this.closureAssert = closureAssert;
    if (unionElements == null) {
      throw new NullPointerException("Null unionElements");
    }
    this.unionElements = unionElements;
  }

  @Override
  public ColorId getId() {
    return id;
  }

  @Override
  public ImmutableSet<Color> getPrototypes() {
    return prototypes;
  }

  @Override
  public ImmutableSet<Color> getInstanceColors() {
    return instanceColors;
  }

  @Override
  public boolean isInvalidating() {
    return invalidating;
  }

  @Override
  public boolean getPropertiesKeepOriginalName() {
    return propertiesKeepOriginalName;
  }

  @Override
  public boolean isConstructor() {
    return constructor;
  }

  @Override
  public ImmutableSet<String> getOwnProperties() {
    return ownProperties;
  }

  @Override
  public @Nullable ColorId getBoxId() {
    return boxId;
  }

  @Override
  public boolean isClosureAssert() {
    return closureAssert;
  }

  @Override
  public ImmutableSet<Color> getUnionElements() {
    return unionElements;
  }

  @Override
  public String toString() {
    return "Color{"
        + "id=" + id + ", "
        + "prototypes=" + prototypes + ", "
        + "instanceColors=" + instanceColors + ", "
        + "invalidating=" + invalidating + ", "
        + "propertiesKeepOriginalName=" + propertiesKeepOriginalName + ", "
        + "constructor=" + constructor + ", "
        + "ownProperties=" + ownProperties + ", "
        + "boxId=" + boxId + ", "
        + "closureAssert=" + closureAssert + ", "
        + "unionElements=" + unionElements
        + "}";
  }

  @Override
  public boolean equals(@Nullable Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Color) {
      Color that = (Color) o;
      return this.id.equals(that.getId())
          && this.prototypes.equals(that.getPrototypes())
          && this.instanceColors.equals(that.getInstanceColors())
          && this.invalidating == that.isInvalidating()
          && this.propertiesKeepOriginalName == that.getPropertiesKeepOriginalName()
          && this.constructor == that.isConstructor()
          && this.ownProperties.equals(that.getOwnProperties())
          && (this.boxId == null ? that.getBoxId() == null : this.boxId.equals(that.getBoxId()))
          && this.closureAssert == that.isClosureAssert()
          && this.unionElements.equals(that.getUnionElements());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= prototypes.hashCode();
    h$ *= 1000003;
    h$ ^= instanceColors.hashCode();
    h$ *= 1000003;
    h$ ^= invalidating ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= propertiesKeepOriginalName ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= constructor ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= ownProperties.hashCode();
    h$ *= 1000003;
    h$ ^= (boxId == null) ? 0 : boxId.hashCode();
    h$ *= 1000003;
    h$ ^= closureAssert ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= unionElements.hashCode();
    return h$;
  }

  static class Builder extends Color.Builder {
    private @Nullable ColorId id;
    private @Nullable ImmutableSet<Color> prototypes;
    private @Nullable ImmutableSet<Color> instanceColors;
    private boolean invalidating;
    private boolean propertiesKeepOriginalName;
    private boolean constructor;
    private @Nullable ImmutableSet<String> ownProperties;
    private @Nullable ColorId boxId;
    private boolean closureAssert;
    private @Nullable ImmutableSet<Color> unionElements;
    private byte set$0;
    Builder() {
    }
    @Override
    public Color.Builder setId(ColorId id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Color.Builder setPrototypes(ImmutableSet<Color> prototypes) {
      if (prototypes == null) {
        throw new NullPointerException("Null prototypes");
      }
      this.prototypes = prototypes;
      return this;
    }
    @Override
    public Color.Builder setInstanceColors(ImmutableSet<Color> instanceColors) {
      if (instanceColors == null) {
        throw new NullPointerException("Null instanceColors");
      }
      this.instanceColors = instanceColors;
      return this;
    }
    @Override
    public Color.Builder setInvalidating(boolean invalidating) {
      this.invalidating = invalidating;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public Color.Builder setPropertiesKeepOriginalName(boolean propertiesKeepOriginalName) {
      this.propertiesKeepOriginalName = propertiesKeepOriginalName;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public Color.Builder setConstructor(boolean constructor) {
      this.constructor = constructor;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public Color.Builder setOwnProperties(ImmutableSet<String> ownProperties) {
      if (ownProperties == null) {
        throw new NullPointerException("Null ownProperties");
      }
      this.ownProperties = ownProperties;
      return this;
    }
    @Override
    Color.Builder setBoxId(@Nullable ColorId boxId) {
      this.boxId = boxId;
      return this;
    }
    @Override
    public Color.Builder setClosureAssert(boolean closureAssert) {
      this.closureAssert = closureAssert;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    Color.Builder setUnionElements(ImmutableSet<Color> unionElements) {
      if (unionElements == null) {
        throw new NullPointerException("Null unionElements");
      }
      this.unionElements = unionElements;
      return this;
    }
    @Override
    Color buildInternal() {
      if (set$0 != 0xf
          || this.id == null
          || this.prototypes == null
          || this.instanceColors == null
          || this.ownProperties == null
          || this.unionElements == null) {
        StringBuilder missing = new StringBuilder();
        if (this.id == null) {
          missing.append(" id");
        }
        if (this.prototypes == null) {
          missing.append(" prototypes");
        }
        if (this.instanceColors == null) {
          missing.append(" instanceColors");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" invalidating");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" propertiesKeepOriginalName");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" constructor");
        }
        if (this.ownProperties == null) {
          missing.append(" ownProperties");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" closureAssert");
        }
        if (this.unionElements == null) {
          missing.append(" unionElements");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Color(
          this.id,
          this.prototypes,
          this.instanceColors,
          this.invalidating,
          this.propertiesKeepOriginalName,
          this.constructor,
          this.ownProperties,
          this.boxId,
          this.closureAssert,
          this.unionElements);
    }
  }

}
