/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.TypeUtils;
import com.googlecode.jtype.Utils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

class DefaultWildcardType
implements WildcardType,
Serializable {
    private static final Type[] DEFAULT_UPPER_BOUNDS = new Type[]{Object.class};
    private static final Type[] DEFAULT_LOWER_BOUNDS = new Type[0];
    private static final long serialVersionUID = 1L;
    private final Type[] upperBounds;
    private final Type[] lowerBounds;

    public DefaultWildcardType(Type[] upperBounds, Type[] lowerBounds) {
        if (upperBounds == null || upperBounds.length == 0) {
            upperBounds = DEFAULT_UPPER_BOUNDS;
        }
        if (lowerBounds == null) {
            lowerBounds = DEFAULT_LOWER_BOUNDS;
        }
        this.upperBounds = (Type[])upperBounds.clone();
        this.lowerBounds = (Type[])lowerBounds.clone();
        boolean hasUpperBounds = !Arrays.equals(this.upperBounds, DEFAULT_UPPER_BOUNDS);
        boolean hasLowerBounds = !Arrays.equals(this.lowerBounds, DEFAULT_LOWER_BOUNDS);
        Utils.checkFalse(hasUpperBounds && hasLowerBounds, "Wildcard type cannot have both upper and lower bounds");
    }

    public Type[] getUpperBounds() {
        return (Type[])this.upperBounds.clone();
    }

    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
    }

    public boolean equals(Object object) {
        if (!(object instanceof WildcardType)) {
            return false;
        }
        WildcardType wildcardType = (WildcardType)object;
        return Arrays.equals(this.lowerBounds, wildcardType.getLowerBounds()) && Arrays.equals(this.upperBounds, wildcardType.getUpperBounds());
    }

    public String toString() {
        return TypeUtils.toString(this);
    }
}

