/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.TypeUtils;
import com.googlecode.jtype.Types;
import com.googlecode.jtype.Utils;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Generic<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Type type;

    protected Generic() {
        Type type = this.getActualTypeArgument();
        Generic.validateType(type);
        this.type = type;
    }

    Generic(Type type) {
        Generic.validateType(type);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Class<? super T> getRawType() {
        return TypeUtils.getErasedReferenceType(this.type);
    }

    public String toUnqualifiedString() {
        return TypeUtils.toUnqualifiedString(this.type);
    }

    public static <T> Generic<T> get(Class<T> klass) {
        Generic<?> generic = Generic.get(klass);
        return generic;
    }

    public static Generic<?> get(Type type) {
        Generic<Object> generic = GenericCache.get(type);
        if (generic == null) {
            generic = Generic.create(type);
        }
        return generic;
    }

    public static <T> Generic<? extends T> get(Class<T> rawType, Type ... actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            return Generic.get(rawType);
        }
        ParameterizedType paramType = Types.parameterizedType(rawType, actualTypeArguments);
        return Generic.get(paramType);
    }

    public static Generic<?> valueOf(String typeName) {
        return Generic.get(Types.valueOf(typeName));
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Generic)) {
            return false;
        }
        Generic generic = (Generic)object;
        return this.type.equals(generic.getType());
    }

    public String toString() {
        return TypeUtils.toString(this.type);
    }

    private static Map<Type, Generic<?>> createCache() {
        HashMap genericsByType = new HashMap();
        Generic.putCacheEntry(genericsByType, Object.class);
        Generic.putCacheEntry(genericsByType, Boolean.class);
        Generic.putCacheEntry(genericsByType, Byte.class);
        Generic.putCacheEntry(genericsByType, Character.class);
        Generic.putCacheEntry(genericsByType, Double.class);
        Generic.putCacheEntry(genericsByType, Float.class);
        Generic.putCacheEntry(genericsByType, Integer.class);
        Generic.putCacheEntry(genericsByType, Long.class);
        Generic.putCacheEntry(genericsByType, Short.class);
        Generic.putCacheEntry(genericsByType, String.class);
        return Collections.unmodifiableMap(genericsByType);
    }

    private static void putCacheEntry(Map<Type, Generic<?>> genericsByType, Type type) {
        genericsByType.put(type, Generic.create(type));
    }

    private static Generic<Object> create(Type type) {
        return new DefaultGeneric<Object>(type);
    }

    private static void validateType(Type type) {
        Utils.checkNotNull(type, "type");
        Utils.checkFalse(type instanceof TypeVariable, "Type variables are not supported: ", type);
        Utils.checkFalse(type instanceof WildcardType, "Wildcard types are not supported: ", type);
        Utils.checkTrue(type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType, "Unsupported type: ", type);
    }

    private Type getActualTypeArgument() {
        if (this.getClass().getSuperclass() != Generic.class) {
            throw new IllegalStateException("Generic must only be subclassed once");
        }
        Type superclass = this.getClass().getGenericSuperclass();
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    static /* synthetic */ Map access$000() {
        return Generic.createCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericCache {
        private static final Map<Type, Generic<?>> GENERICS_BY_TYPE = Generic.access$000();

        private GenericCache() {
        }

        public static Generic<?> get(Type type) {
            return GENERICS_BY_TYPE.get(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultGeneric<T>
    extends Generic<T> {
        public DefaultGeneric(Type type) {
            super(type);
        }
    }
}

