/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.Generic;
import com.googlecode.jtype.Types;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Generics {
    private static final Generic<Comparable<?>> COMPARABLE = Generic.get(Comparable.class, Types.unboundedWildcardType());
    private static final Generic<Comparator<?>> COMPARATOR = Generic.get(Comparator.class, Types.unboundedWildcardType());
    private static final Generic<Enumeration<?>> ENUMERATION = Generic.get(Enumeration.class, Types.unboundedWildcardType());
    private static final Generic<Iterable<?>> ITERABLE = Generic.get(Iterable.class, Types.unboundedWildcardType());
    private static final Generic<Iterator<?>> ITERATOR = Generic.get(Iterator.class, Types.unboundedWildcardType());
    private static final Generic<ListIterator<?>> LIST_ITERATOR = Generic.get(ListIterator.class, Types.unboundedWildcardType());
    private static final Generic<Collection<?>> COLLECTION = Generic.get(Collection.class, Types.unboundedWildcardType());
    private static final Generic<Set<?>> SET = Generic.get(Set.class, Types.unboundedWildcardType());
    private static final Generic<SortedSet<?>> SORTED_SET = Generic.get(SortedSet.class, Types.unboundedWildcardType());
    private static final Generic<List<?>> LIST = Generic.get(List.class, Types.unboundedWildcardType());
    private static final Generic<Map<?, ?>> MAP = Generic.get(Map.class, Types.unboundedWildcardType(), Types.unboundedWildcardType());
    private static final Generic<SortedMap<?, ?>> SORTED_MAP = Generic.get(SortedMap.class, Types.unboundedWildcardType(), Types.unboundedWildcardType());
    private static final Generic<Queue<?>> QUEUE = Generic.get(Queue.class, Types.unboundedWildcardType());

    private Generics() {
        throw new AssertionError();
    }

    public static Generic<Comparable<?>> comparable() {
        return COMPARABLE;
    }

    public static <T> Generic<Comparable<T>> comparable(Class<T> type) {
        return Generic.get(Comparable.class, type);
    }

    public static Generic<Comparator<?>> comparator() {
        return COMPARATOR;
    }

    public static <T> Generic<Comparator<T>> comparator(Class<T> type) {
        return Generic.get(Comparator.class, type);
    }

    public static Generic<Enumeration<?>> enumeration() {
        return ENUMERATION;
    }

    public static <E> Generic<Enumeration<E>> enumeration(Class<E> elementClass) {
        return Generic.get(Enumeration.class, elementClass);
    }

    public static Generic<Iterable<?>> iterable() {
        return ITERABLE;
    }

    public static <T> Generic<Iterable<T>> iterable(Class<T> elementClass) {
        return Generic.get(Iterable.class, elementClass);
    }

    public static Generic<Iterator<?>> iterator() {
        return ITERATOR;
    }

    public static <E> Generic<Iterator<E>> iterator(Class<E> elementClass) {
        return Generic.get(Iterator.class, elementClass);
    }

    public static Generic<ListIterator<?>> listIterator() {
        return LIST_ITERATOR;
    }

    public static <E> Generic<ListIterator<E>> listIterator(Class<E> elementClass) {
        return Generic.get(ListIterator.class, elementClass);
    }

    public static Generic<Collection<?>> collection() {
        return COLLECTION;
    }

    public static <E> Generic<Collection<E>> collection(Class<E> elementClass) {
        return Generic.get(Collection.class, elementClass);
    }

    public static Generic<Set<?>> set() {
        return SET;
    }

    public static <E> Generic<Set<E>> set(Class<E> elementClass) {
        return Generic.get(Set.class, elementClass);
    }

    public static Generic<SortedSet<?>> sortedSet() {
        return SORTED_SET;
    }

    public static <E> Generic<SortedSet<E>> sortedSet(Class<E> elementClass) {
        return Generic.get(SortedSet.class, elementClass);
    }

    public static Generic<List<?>> list() {
        return LIST;
    }

    public static <E> Generic<List<E>> list(Class<E> elementClass) {
        return Generic.get(List.class, elementClass);
    }

    public static Generic<Map<?, ?>> map() {
        return MAP;
    }

    public static <K, V> Generic<Map<K, V>> map(Class<K> keyClass, Class<V> valueClass) {
        return Generic.get(Map.class, keyClass, valueClass);
    }

    public static Generic<SortedMap<?, ?>> sortedMap() {
        return SORTED_MAP;
    }

    public static <K, V> Generic<SortedMap<K, V>> sortedMap(Class<K> keyClass, Class<V> valueClass) {
        return Generic.get(SortedMap.class, keyClass, valueClass);
    }

    public static Generic<Queue<?>> queue() {
        return QUEUE;
    }

    public static <E> Generic<Queue<E>> queue(Class<E> elementClass) {
        return Generic.get(Queue.class, elementClass);
    }
}

