/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua1;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA1NotesChecker {
    private PdfUA1NotesChecker() {
    }

    public static class PdfUA1NotesTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        public PdfUA1NotesTagHandler(PdfUAValidationContext context) {
            super(context);
        }

        public boolean accept(IStructureNode node) {
            return node != null;
        }

        public void processElement(IStructureNode elem) {
            PdfStructElem structElem = this.context.getElementIfRoleMatches(PdfName.Note, elem);
            if (structElem == null) {
                return;
            }
            PdfDictionary pdfObject = (PdfDictionary)structElem.getPdfObject();
            if (pdfObject.get(PdfName.ID) == null) {
                throw new PdfUAConformanceException("Note tags shall include a unique ID entry.");
            }
        }
    }
}

