/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse.syntax;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssAtRule;
import com.itextpdf.styledxmlparser.css.CssAtRuleFactory;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssImportAtRule;
import com.itextpdf.styledxmlparser.css.CssNestedAtRule;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssSemicolonAtRule;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import com.itextpdf.styledxmlparser.css.parse.syntax.AtRuleBlockState;
import com.itextpdf.styledxmlparser.css.parse.syntax.BlockState;
import com.itextpdf.styledxmlparser.css.parse.syntax.CommentEndState;
import com.itextpdf.styledxmlparser.css.parse.syntax.CommentInnerState;
import com.itextpdf.styledxmlparser.css.parse.syntax.CommentStartState;
import com.itextpdf.styledxmlparser.css.parse.syntax.ConditionalGroupAtRuleBlockState;
import com.itextpdf.styledxmlparser.css.parse.syntax.IParserState;
import com.itextpdf.styledxmlparser.css.parse.syntax.NoDuplicatesResourceRetriever;
import com.itextpdf.styledxmlparser.css.parse.syntax.RuleState;
import com.itextpdf.styledxmlparser.css.parse.syntax.UnknownState;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CssParserStateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssParserStateController.class);
    private static final Set<String> SUPPORTED_RULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("media", "page", "top-left-corner", "top-left", "top-center", "top-right", "top-right-corner", "bottom-left-corner", "bottom-left", "bottom-center", "bottom-right", "bottom-right-corner", "left-top", "left-middle", "left-bottom", "right-top", "right-middle", "right-bottom", "font-face")));
    private static final Set<String> CONDITIONAL_GROUP_RULES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("media")));
    private IParserState currentState;
    private boolean isCurrentRuleSupported = true;
    private IParserState previousActiveState;
    private final StringBuilder buffer = new StringBuilder();
    private String currentSelector;
    private final CssStyleSheet styleSheet;
    private final CssStyleSheet styleSheetFromImport;
    private final Stack<CssNestedAtRule> nestedAtRules;
    private final Stack<List<CssDeclaration>> storedPropertiesWithoutSelector;
    private final IParserState commentStartState;
    private final IParserState commendEndState;
    private final IParserState commendInnerState;
    private final IParserState unknownState;
    private final IParserState ruleState;
    private final IParserState propertiesState;
    private final IParserState conditionalGroupAtRuleBlockState;
    private final IParserState atRuleBlockState;
    private final ResourceResolver resourceResolver;

    @Deprecated
    public CssParserStateController() {
        this("");
    }

    public CssParserStateController(String baseUrl) {
        this(baseUrl == null || baseUrl.isEmpty() ? null : new ResourceResolver(baseUrl, new NoDuplicatesResourceRetriever()));
    }

    private CssParserStateController(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.styleSheet = new CssStyleSheet();
        this.styleSheetFromImport = new CssStyleSheet();
        this.nestedAtRules = new Stack();
        this.storedPropertiesWithoutSelector = new Stack();
        this.commentStartState = new CommentStartState(this);
        this.commendEndState = new CommentEndState(this);
        this.commendInnerState = new CommentInnerState(this);
        this.unknownState = new UnknownState(this);
        this.ruleState = new RuleState(this);
        this.propertiesState = new BlockState(this);
        this.atRuleBlockState = new AtRuleBlockState(this);
        this.conditionalGroupAtRuleBlockState = new ConditionalGroupAtRuleBlockState(this);
        this.currentState = this.unknownState;
    }

    public void process(char ch) {
        this.currentState.process(ch);
    }

    public CssStyleSheet getParsingResult() {
        CssStyleSheet parsingResult = new CssStyleSheet();
        parsingResult.appendCssStyleSheet(this.styleSheet);
        parsingResult.appendCssStyleSheet(this.styleSheetFromImport);
        return parsingResult;
    }

    void appendToBuffer(char ch) {
        this.buffer.append(ch);
    }

    String getBufferContents() {
        return this.buffer.toString();
    }

    void resetBuffer() {
        this.buffer.setLength(0);
    }

    void enterPreviousActiveState() {
        this.setState(this.previousActiveState);
    }

    void enterCommentStartState() {
        this.saveActiveState();
        this.setState(this.commentStartState);
    }

    void enterCommentEndState() {
        this.setState(this.commendEndState);
    }

    void enterCommentInnerState() {
        this.setState(this.commendInnerState);
    }

    void enterRuleState() {
        this.setState(this.ruleState);
    }

    void enterUnknownStateIfNestedBlocksFinished() {
        if (this.nestedAtRules.size() == 0) {
            this.setState(this.unknownState);
        } else {
            this.enterRuleStateBasedOnItsType();
        }
    }

    void enterRuleStateBasedOnItsType() {
        if (this.currentAtRuleIsConditionalGroupRule()) {
            this.enterConditionalGroupAtRuleBlockState();
        } else {
            this.enterAtRuleBlockState();
        }
    }

    void enterUnknownState() {
        this.setState(this.unknownState);
    }

    void enterAtRuleBlockState() {
        this.setState(this.atRuleBlockState);
    }

    void enterConditionalGroupAtRuleBlockState() {
        this.setState(this.conditionalGroupAtRuleBlockState);
    }

    void enterPropertiesState() {
        this.setState(this.propertiesState);
    }

    void storeCurrentSelector() {
        this.currentSelector = this.buffer.toString();
        this.buffer.setLength(0);
    }

    void storeCurrentProperties() {
        if (this.isCurrentRuleSupported) {
            this.processProperties(this.currentSelector, this.buffer.toString());
        }
        this.currentSelector = null;
        this.buffer.setLength(0);
    }

    void storeCurrentPropertiesWithoutSelector() {
        if (this.isCurrentRuleSupported) {
            this.processProperties(this.buffer.toString());
        }
        this.buffer.setLength(0);
    }

    void storeSemicolonAtRule() {
        if (this.isCurrentRuleSupported) {
            this.processSemicolonAtRule(this.buffer.toString());
        }
        this.buffer.setLength(0);
    }

    void finishAtRuleBlock() {
        List<CssDeclaration> storedProps = this.storedPropertiesWithoutSelector.pop();
        CssNestedAtRule atRule = this.nestedAtRules.pop();
        if (this.isCurrentRuleSupported) {
            this.processFinishedAtRuleBlock(atRule);
            if (!storedProps.isEmpty()) {
                atRule.addBodyCssDeclarations(storedProps);
            }
        }
        this.isCurrentRuleSupported = this.isCurrentRuleSupported();
        this.buffer.setLength(0);
    }

    void pushBlockPrecedingAtRule() {
        this.nestedAtRules.push(CssAtRuleFactory.createNestedRule(this.buffer.toString()));
        this.storedPropertiesWithoutSelector.push(new ArrayList());
        this.isCurrentRuleSupported = this.isCurrentRuleSupported();
        this.buffer.setLength(0);
    }

    private void saveActiveState() {
        this.previousActiveState = this.currentState;
    }

    private void setState(IParserState state) {
        this.currentState = state;
    }

    private void processProperties(String selector, String properties) {
        List<CssRuleSet> ruleSets = CssRuleSetParser.parseRuleSet(selector, properties);
        for (CssRuleSet ruleSet : ruleSets) {
            this.normalizeDeclarationURIs(ruleSet.getNormalDeclarations());
            this.normalizeDeclarationURIs(ruleSet.getImportantDeclarations());
        }
        for (CssRuleSet ruleSet : ruleSets) {
            if (this.nestedAtRules.isEmpty()) {
                this.styleSheet.addStatement(ruleSet);
                continue;
            }
            this.nestedAtRules.peek().addStatementToBody(ruleSet);
        }
    }

    private void processProperties(String properties) {
        if (!this.storedPropertiesWithoutSelector.isEmpty()) {
            List<CssDeclaration> cssDeclarations = CssRuleSetParser.parsePropertyDeclarations(properties);
            this.normalizeDeclarationURIs(cssDeclarations);
            this.storedPropertiesWithoutSelector.peek().addAll(cssDeclarations);
        }
    }

    private void normalizeDeclarationURIs(List<CssDeclaration> declarations) {
        if (this.resourceResolver == null) {
            return;
        }
        for (CssDeclaration declaration : declarations) {
            if (!declaration.getExpression().contains("url(")) continue;
            this.normalizeSingleDeclarationURI(declaration);
        }
    }

    private void normalizeSingleDeclarationURI(CssDeclaration declaration) {
        CssDeclarationValueTokenizer.Token token;
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(declaration.getExpression());
        StringBuilder normalizedDeclaration = new StringBuilder();
        while ((token = tokenizer.getNextValidToken()) != null) {
            String strToAppend;
            if (token.getType() == CssDeclarationValueTokenizer.TokenType.FUNCTION && token.getValue().startsWith("url(")) {
                String url = token.getValue().trim();
                url = url.substring(4, url.length() - 1).trim();
                if (CssTypesValidationUtils.isInlineData(url = CssUtils.extractUnquotedString(url)) || url.startsWith("#")) {
                    strToAppend = token.getValue().trim();
                } else {
                    String finalUrl = url;
                    try {
                        finalUrl = this.resourceResolver.resolveAgainstBaseUri(url).toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    strToAppend = MessageFormatUtil.format((String)"url({0})", (Object[])new Object[]{finalUrl});
                }
            } else {
                strToAppend = token.getType() == CssDeclarationValueTokenizer.TokenType.STRING && token.getStringQuote() != '\u0000' ? token.getStringQuote() + token.getValue() + token.getStringQuote() : token.getValue();
            }
            if (normalizedDeclaration.length() > 0 && token.getType() != CssDeclarationValueTokenizer.TokenType.COMMA) {
                normalizedDeclaration.append(' ');
            }
            normalizedDeclaration.append(strToAppend);
        }
        declaration.setExpression(normalizedDeclaration.toString());
    }

    private void processSemicolonAtRule(String ruleStr) {
        CssSemicolonAtRule atRule = CssAtRuleFactory.createSemicolonAtRule(ruleStr);
        if (atRule instanceof CssImportAtRule) {
            boolean isPositionCorrect = true;
            for (CssStatement statement : this.styleSheet.getStatements()) {
                if (statement instanceof CssAtRule) {
                    String ruleName = ((CssAtRule)statement).getRuleName();
                    if (CssImportAtRule.ALLOWED_RULES_BEFORE.contains(ruleName)) continue;
                    isPositionCorrect = false;
                    break;
                }
                isPositionCorrect = false;
                break;
            }
            if (isPositionCorrect) {
                if (this.resourceResolver == null) {
                    LOGGER.error("Import rule URL can't be resolved because of base URI absence.");
                    return;
                }
                String externalCss = CssUtils.extractUrl(atRule.getRuleParams());
                try (InputStream stream = this.resourceResolver.retrieveResourceAsInputStream(externalCss);){
                    if (stream != null) {
                        ResourceResolver newResourceResolver = new ResourceResolver(this.resourceResolver.resolveAgainstBaseUri(externalCss).toExternalForm(), this.resourceResolver.getRetriever());
                        CssParserStateController controller = new CssParserStateController(newResourceResolver);
                        CssStyleSheet externalStyleSheet = CssStyleSheetParser.parse(stream, controller);
                        this.styleSheetFromImport.appendCssStyleSheet(externalStyleSheet);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Unable to process external css file", (Throwable)e);
                }
            } else {
                LOGGER.warn("Imported rules must come before all other types of rules, except @charset rules and layer creating @layer statements. Rule will be ignored. ");
            }
        } else {
            this.styleSheet.addStatement(atRule);
        }
    }

    private void processFinishedAtRuleBlock(CssNestedAtRule atRule) {
        if (this.nestedAtRules.isEmpty()) {
            this.styleSheet.addStatement(atRule);
        } else {
            this.nestedAtRules.peek().addStatementToBody(atRule);
        }
    }

    private boolean isCurrentRuleSupported() {
        boolean isSupported;
        boolean bl = isSupported = this.nestedAtRules.isEmpty() || SUPPORTED_RULES.contains(this.nestedAtRules.peek().getRuleName());
        if (!isSupported) {
            LOGGER.error(MessageFormatUtil.format((String)"The rule @{0} is unsupported. All selectors in this rule will be ignored.", (Object[])new Object[]{this.nestedAtRules.peek().getRuleName()}));
        }
        return isSupported;
    }

    private boolean currentAtRuleIsConditionalGroupRule() {
        return !this.isCurrentRuleSupported || this.nestedAtRules.size() > 0 && CONDITIONAL_GROUP_RULES.contains(this.nestedAtRules.peek().getRuleName());
    }
}

