/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import java.util.HashMap;

public class RectangleSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private float x = 0.0f;
    private float y = 0.0f;
    private float width;
    private float height;
    private boolean rxPresent = false;
    private boolean ryPresent = false;
    private float rx = 0.0f;
    private float ry = 0.0f;

    public RectangleSvgNodeRenderer() {
        this.attributesAndStyles = new HashMap();
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% rect\n");
        this.setParameters(context);
        if (this.width <= 0.0f || this.height <= 0.0f) {
            return;
        }
        boolean singleValuePresent = this.rxPresent && !this.ryPresent || !this.rxPresent && this.ryPresent;
        AffineTransform transform = this.applyNonScalingStrokeTransform(context);
        if (!this.rxPresent && !this.ryPresent) {
            Point[] points = new Rectangle(this.x, this.y, this.width, this.height).toPointsArray();
            if (transform != null) {
                transform.transform(points, 0, points, 0, points.length);
                if (Math.abs(transform.getShearX()) > 0.0 || Math.abs(transform.getShearY()) > 0.0) {
                    int i = 0;
                    cv.moveTo(points[i].getX(), points[i++].getY()).lineTo(points[i].getX(), points[i++].getY()).lineTo(points[i].getX(), points[i++].getY()).lineTo(points[i].getX(), points[i].getY()).closePath();
                    return;
                }
            }
            cv.rectangle(points[0].getX(), points[0].getY(), points[1].getX() - points[0].getX(), points[2].getY() - points[0].getY());
        } else if (singleValuePresent) {
            cv.writeLiteral("% circle rounded rect\n");
            float radius = this.findCircularRadius(this.rx, this.ry, this.width, this.height);
            cv.roundRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)radius, (double)radius, transform);
        } else {
            cv.writeLiteral("% ellipse rounded rect\n");
            cv.roundRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)this.rx, (double)this.ry, transform);
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        this.setParameters(context);
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    private void setParameters(SvgDrawContext context) {
        float rawRadius;
        if (this.getAttribute("x") != null) {
            this.x = this.parseHorizontalLength(this.getAttribute("x"), context);
        }
        if (this.getAttribute("y") != null) {
            this.y = this.parseVerticalLength(this.getAttribute("y"), context);
        }
        this.width = this.parseHorizontalLength(this.getAttribute("width"), context);
        this.height = this.parseVerticalLength(this.getAttribute("height"), context);
        if (this.attributesAndStyles.containsKey("rx")) {
            rawRadius = this.parseHorizontalLength(this.getAttribute("rx"), context);
            this.rx = this.checkRadius(rawRadius, this.width);
            boolean bl = this.rxPresent = rawRadius >= 0.0f;
        }
        if (this.attributesAndStyles.containsKey("ry")) {
            rawRadius = this.parseVerticalLength(this.getAttribute("ry"), context);
            this.ry = this.checkRadius(rawRadius, this.height);
            this.ryPresent = rawRadius >= 0.0f;
        }
    }

    float checkRadius(float radius, float distance) {
        if (radius <= 0.0f) {
            return 0.0f;
        }
        if (radius > distance / 2.0f) {
            return distance / 2.0f;
        }
        return radius;
    }

    float findCircularRadius(float rx, float ry, float width, float height) {
        float maxRadius = Math.min(width, height) / 2.0f;
        float biggestRadius = Math.max(rx, ry);
        return Math.min(maxRadius, biggestRadius);
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        RectangleSvgNodeRenderer copy = new RectangleSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

