/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.CrossProcessTransactionStateImpl;
import com.newrelic.agent.DeobfuscatedInboundHeaders;
import com.newrelic.agent.DummyTransaction;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.InboundHeaderState;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Segment;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TimedSet;
import com.newrelic.agent.TimedTokenSet;
import com.newrelic.agent.TokenImpl;
import com.newrelic.agent.TracerList;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.TransactionStaticsHolder;
import com.newrelic.agent.WeakRefTransaction;
import com.newrelic.agent.application.AbstractApplicationNamingPolicy;
import com.newrelic.agent.application.HigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.application.PriorityApplicationName;
import com.newrelic.agent.application.SameOrHigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.CrossProcessState;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.NoOpToken;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.browser.BrowserTransactionState;
import com.newrelic.agent.browser.BrowserTransactionStateImpl;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.CachingDatabaseStatementParser;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.WebRequestDispatcher;
import com.newrelic.agent.errors.ErrorAnalyzerImpl;
import com.newrelic.agent.messaging.MessagingUtil;
import com.newrelic.agent.model.TimeoutCause;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.stats.AbstractMetricAggregator;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.agent.tracing.SpanProxy;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionCache;
import com.newrelic.agent.transaction.TransactionCounts;
import com.newrelic.agent.transaction.TransactionErrorTracker;
import com.newrelic.agent.transaction.TransactionErrorTrackerImpl;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import com.newrelic.agent.transaction.TransactionNamingUtility;
import com.newrelic.agent.transaction.TransactionThrowable;
import com.newrelic.agent.transaction.TransactionTimer;
import com.newrelic.agent.util.LazyAtomicReference;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.ApplicationNamePriority;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.Insights;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import com.newrelic.api.agent.TransportType;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class Transaction {
    static final ClassMethodSignature REQUEST_INITIALIZED_CLASS_SIGNATURE = new ClassMethodSignature("javax.servlet.ServletRequestListener", "requestInitialized", "(Ljavax/servlet/ServletRequestEvent;)V");
    static final int REQUEST_INITIALIZED_CLASS_SIGNATURE_ID = ClassMethodSignatures.get().add(REQUEST_INITIALIZED_CLASS_SIGNATURE);
    private static final String THREAD_ASSERTION_FAILURE = "Thread assertion failed!";
    private static final ThreadLocal<Transaction> transactionHolder = new ThreadLocal();
    private static volatile DatabaseStatementParser databaseStatementParser;
    private final String guid;
    private final boolean ttEnabled;
    private final TransactionCounts counts;
    private final boolean autoAppNamingEnabled;
    private final boolean transactionNamingEnabled;
    private final boolean ignoreErrorPriority;
    private final Object lock = new Object();
    private final Set<TransactionActivity> finishedChildren = Sets.newConcurrentHashSet();
    private final AtomicInteger nextActivityId = new AtomicInteger(0);
    private final long initiatingThreadId;
    private final AtomicReference<Float> priority = new AtomicReference<Object>(null);
    private final TransactionErrorTracker errorTracker = new TransactionErrorTrackerImpl();
    private final Map<String, Object> internalParameters;
    private final Map<String, Map<String, String>> prefixedAgentAttributes;
    private final Map<String, Object> agentAttributes;
    private final Map<String, Object> intrinsicAttributes;
    private final Map<String, Object> userAttributes;
    private final Map<String, Object> errorAttributes;
    private final AtomicReference<Insights> insights;
    private final Map<Integer, TransactionActivity> runningChildren;
    private volatile long wallClockStartTimeMs;
    private volatile long startGCTimeInMillis;
    private volatile boolean ignore;
    private volatile boolean ignoreErrors = false;
    private volatile Dispatcher dispatcher;
    private volatile Tracer rootTracer;
    private volatile TransactionTimer transactionTime;
    private volatile TransactionState transactionState = new TransactionStateImpl();
    private volatile TransactionActivity initialActivity = null;
    private volatile PriorityTransactionName priorityTransactionName = PriorityTransactionName.NONE;
    private volatile TimeoutCause timeoutCause;
    private volatile TransactionStats txStats = null;
    private Callable<AppNameAndConfig> appNameAndConfigInitializer = new Callable<AppNameAndConfig>(){

        @Override
        public AppNameAndConfig call() throws Exception {
            return AppNameAndConfig.getDefault();
        }
    };
    private LazyAtomicReference<AppNameAndConfig> appNameAndConfig = new LazyAtomicReference<AppNameAndConfig>(this.appNameAndConfigInitializer);
    private volatile CrossProcessTransactionState crossProcessTransactionState;
    private String normalizedUri;
    private SlowQueryListener slowQueryListener;
    private BrowserTransactionState browserTransactionState;
    private InboundHeaders providedHeaders;
    private volatile InboundHeaderState inboundHeaderState;
    private final AtomicReference<TimedSet<TokenImpl>> activeTokensCache;
    private final AtomicInteger activeCount;
    private final MetricAggregator metricAggregator = new AbstractMetricAggregator(){

        @Override
        protected void doRecordResponseTimeMetric(String name, long totalTime, long exclusiveTime, TimeUnit timeUnit) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getOrCreateResponseTimeStats(name).recordResponseTime(totalTime, exclusiveTime, timeUnit);
        }

        @Override
        protected void doRecordMetric(String name, float value) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).recordDataPoint(value);
        }

        @Override
        protected void doIncrementCounter(String name, int count) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).incrementCallCount(count);
        }
    };
    private static DummyTransaction dummyTransaction;
    private final AtomicReference<SpanProxy> spanProxy = new AtomicReference<SpanProxy>(new SpanProxy());
    private volatile long transportDurationInMillis = -1L;
    private volatile long largestTransportDurationInMillis = -1L;
    private volatile TransportType transportType = TransportType.Unknown;
    protected static final WebResponse DEFAULT_RESPONSE;
    private static final Request DUMMY_REQUEST;
    private static final Response DUMMY_RESPONSE;
    private static final int REQUEST_TRACER_FLAGS = 14;
    private final Object requestStateChangeLock = new Object();
    private static final String SEGMENT_TXA_DEFAULT_ASYNC_CONTEXT = "activity";
    private static final Object SEGMENT_INVOKER;
    private static final MetricNameFormat SEGMENT_URI;

    public void setTimeoutCause(TimeoutCause cause) {
        this.timeoutCause = cause;
    }

    public TimeoutCause getTimeoutCause() {
        return this.timeoutCause;
    }

    public long getTransportDurationInMillis() {
        return Math.max(this.transportDurationInMillis, 0L);
    }

    public DistributedTracePayloadImpl createDistributedTracePayload(String spanId) {
        SpanProxy spanProxy = this.spanProxy.get();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.getTransactionTimer().getStartTimeInNanos());
        long txnStartTimeSinceEpochInMillis = System.currentTimeMillis() - elapsedMillis;
        spanProxy.setTimestamp(txnStartTimeSinceEpochInMillis);
        DistributedTracePayloadImpl payload = (DistributedTracePayloadImpl)spanProxy.createDistributedTracePayload(this.priority.get(), spanId, this.getGuid());
        if (payload != null) {
            this.setPriorityIfNotNull(payload.priority);
        }
        return payload;
    }

    public boolean acceptDistributedTracePayload(String payload) {
        if (this.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.getTransactionTimer().getStartTimeInNanos());
            long txnStartTimeSinceEpochInMillis = System.currentTimeMillis() - elapsedMillis;
            this.spanProxy.get().setTimestamp(txnStartTimeSinceEpochInMillis);
            boolean accepted = this.spanProxy.get().acceptDistributedTracePayload(payload);
            if (accepted) {
                this.transportDurationInMillis = this.spanProxy.get().getTransportDurationInMillis();
                this.setPriorityIfNotNull(this.spanProxy.get().getInboundDistributedTracePayload().priority);
            }
            return accepted;
        }
        Agent.LOG.log(Level.FINE, "Not accepting payload, distributed tracing disabled");
        return false;
    }

    public boolean acceptDistributedTracePayload(DistributedTracePayload payload) {
        if (this.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.getTransactionTimer().getStartTimeInNanos());
            long txnStartTimeSinceEpochInMillis = System.currentTimeMillis() - elapsedMillis;
            this.spanProxy.get().setTimestamp(txnStartTimeSinceEpochInMillis);
            boolean accepted = this.spanProxy.get().acceptDistributedTracePayload(payload);
            if (accepted) {
                this.transportDurationInMillis = this.spanProxy.get().getTransportDurationInMillis();
                this.setPriorityIfNotNull(this.spanProxy.get().getInboundDistributedTracePayload().priority);
            }
            return accepted;
        }
        Agent.LOG.log(Level.FINE, "Not accepting payload, distributed tracing disabled");
        return false;
    }

    private void checkAndSetPriority() {
        if (this.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
            DistributedTracePayloadImpl inboundPayload = this.spanProxy.get().getInboundDistributedTracePayload();
            Float inboundPriority = inboundPayload != null ? inboundPayload.priority : null;
            DistributedSamplingPriorityQueue<TransactionEvent> reservoir = ServiceFactory.getTransactionEventsService().getOrCreateDistributedSamplingReservoir(this.getApplicationName());
            this.priority.compareAndSet(null, Float.valueOf(distributedTraceService.calculatePriority(inboundPriority, reservoir)));
        } else {
            this.priority.compareAndSet(null, Float.valueOf(DistributedTraceServiceImpl.nextTruncatedFloat()));
        }
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public long getLargestTransportDurationInMillis() {
        return Math.max(this.largestTransportDurationInMillis, 0L);
    }

    public SpanProxy getSpanProxy() {
        return this.spanProxy.get();
    }

    public String getOrCreateTraceId() {
        SpanProxy spanProxy = this.getSpanProxy();
        return spanProxy.getOrCreateTraceId();
    }

    protected Transaction() {
        Agent.LOG.log(Level.FINE, "create Transaction {0}", this);
        if (Agent.LOG.isFinestEnabled() && Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINEST, "backtrace: {0}", Arrays.toString(Thread.currentThread().getStackTrace()));
        }
        AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.guid = TransactionGuidFactory.generate16CharGuid();
        this.autoAppNamingEnabled = defaultConfig.isAutoAppNamingEnabled();
        this.transactionNamingEnabled = this.initializeTransactionNamingEnabled(defaultConfig);
        this.ignoreErrorPriority = defaultConfig.getErrorCollectorConfig().isIgnoreErrorPriority();
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.ttEnabled = ttService.isEnabled();
        this.counts = new TransactionCounts(defaultConfig);
        this.initiatingThreadId = Thread.currentThread().getId();
        MapMaker factory2 = new MapMaker().initialCapacity(8).concurrencyLevel(4);
        this.internalParameters = new LazyMapImpl<String, Object>(factory2);
        this.prefixedAgentAttributes = new LazyMapImpl<String, Map<String, String>>(factory2);
        this.agentAttributes = new LazyMapImpl<String, Object>(factory2);
        this.intrinsicAttributes = new LazyMapImpl<String, Object>(factory2);
        this.userAttributes = new LazyMapImpl<String, Object>(factory2);
        this.errorAttributes = new LazyMapImpl<String, Object>(factory2);
        this.insights = new AtomicReference();
        this.runningChildren = new LazyMapImpl<Integer, TransactionActivity>(factory2);
        this.activeTokensCache = new AtomicReference();
        this.activeCount = new AtomicInteger(0);
    }

    private void postConstruct() {
        this.initialActivity = TransactionActivity.create(this, this.nextActivityId.getAndIncrement());
        this.checkAndSetPriority();
    }

    private static long getGCTime() {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    private boolean initializeTransactionNamingEnabled(AgentConfig config) {
        return config.isAutoTransactionNamingEnabled();
    }

    public MetricAggregator getMetricAggregator() {
        return this.metricAggregator;
    }

    public long getInitiatingThreadId() {
        return this.initiatingThreadId;
    }

    public Object getLock() {
        return this.lock;
    }

    public String getGuid() {
        return this.guid;
    }

    public AgentConfig getAgentConfig() {
        return this.appNameAndConfig.get().getConfig();
    }

    public long getWallClockStartTimeMs() {
        this.captureWallClockStartTime();
        return this.wallClockStartTimeMs;
    }

    private void captureWallClockStartTime() {
        if (this.wallClockStartTimeMs == 0L) {
            this.wallClockStartTimeMs = System.currentTimeMillis();
        }
    }

    public Map<String, Object> getInternalParameters() {
        return this.internalParameters;
    }

    public boolean markFirstByteOfResponse(long endTimeNs) {
        return this.transactionTime.markTimeToFirstByte(endTimeNs);
    }

    public boolean markLastByteOfResponse(long endTimeNs) {
        return this.transactionTime.markTimeToLastByte(endTimeNs);
    }

    public Map<String, Map<String, String>> getPrefixedAgentAttributes() {
        return this.prefixedAgentAttributes;
    }

    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    public Map<String, Object> getIntrinsicAttributes() {
        return this.intrinsicAttributes;
    }

    public Map<String, Object> getErrorAttributes() {
        return this.errorAttributes;
    }

    public Insights getInsightsData() {
        Insights insightsData = this.insights.get();
        if (insightsData == null) {
            AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
            this.insights.compareAndSet(null, ServiceFactory.getServiceManager().getInsights().getTransactionInsights(defaultConfig));
            insightsData = this.insights.get();
        }
        return insightsData;
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        if (this.dispatcher == null) {
            return this.getAgentConfig().getTransactionTracerConfig();
        }
        return this.dispatcher.getTransactionTracerConfig();
    }

    public CrossProcessConfig getCrossProcessConfig() {
        return this.getAgentConfig().getCrossProcessConfig();
    }

    public boolean setTransactionName(com.newrelic.api.agent.TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.setTransactionName(TransactionNamePriority.convert((com.newrelic.api.agent.TransactionNamePriority)namePriority), override, category, parts);
    }

    public boolean setTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.doSetTransactionName(namePriority, override, category, parts);
    }

    @Deprecated
    public boolean isTransactionNameSet() {
        return TransactionNamingUtility.isGreaterThan(this.getPriorityTransactionName().getPriority(), TransactionNamePriority.NONE, this.getNamingScheme());
    }

    private boolean doSetTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        if (TransactionNamingUtility.isLessThan(namePriority, TransactionNamePriority.CUSTOM_HIGH, this.getNamingScheme()) && !this.isTransactionNamingEnabled()) {
            return false;
        }
        String name = Strings.join('/', parts);
        if (this.dispatcher == null) {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest(MessageFormat.format("Unable to set the transaction name to \"{0}\" - no transaction", name));
            }
            return false;
        }
        TransactionNamingPolicy policy = override ? TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy() : TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        return policy.setTransactionName(this, name, category, namePriority);
    }

    public PriorityTransactionName getPriorityTransactionName() {
        return this.priorityTransactionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeTransactionName() {
        Object object = this.lock;
        synchronized (object) {
            if (this.priorityTransactionName.isFrozen()) {
                return;
            }
            if (this.dispatcher != null) {
                this.dispatcher.setTransactionName();
            }
            this.renameTransaction();
            this.priorityTransactionName = this.priorityTransactionName.freeze();
        }
    }

    private void renameTransaction() {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        String appName = this.getApplicationName();
        Normalizer metricDataNormalizer = ServiceFactory.getNormalizationService().getMetricNormalizer(appName);
        String txName = metricDataNormalizer.normalize(this.priorityTransactionName.getName());
        Normalizer txNormalizer = ServiceFactory.getNormalizationService().getTransactionNormalizer(appName);
        txName = txNormalizer.normalize(txName);
        if (txName == null) {
            this.setIgnore(true);
            return;
        }
        if (!txName.equals(this.priorityTransactionName.getName())) {
            this.setPriorityTransactionNameLocked(PriorityTransactionName.create(txName, this.isWebTransaction() ? "Web" : "Other", TransactionNamePriority.REQUEST_URI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conditionalSetPriorityTransactionName(TransactionNamingPolicy policy, String name, String category, TransactionNamePriority priority) {
        Object object = this.lock;
        synchronized (object) {
            MetricNames.recordApiSupportabilityMetric("SetTransactionName");
            if (policy.canSetTransactionName(this, priority)) {
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Setting transaction name to \"{0}\" for transaction {1} using {2} scheme", name, this, (Object)this.getNamingScheme());
                } else {
                    Agent.LOG.log(Level.FINER, "Setting transaction name to \"{0}\" for transaction {1}", name, this);
                }
                return this.setPriorityTransactionNameLocked(policy.getPriorityTransactionName(this, name, category, priority));
            }
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Not setting the transaction name to  \"{0}\" for transaction {1} using {2} scheme: a higher priority name is already in place. Current transaction name is {3}", name, this, (Object)this.getNamingScheme(), this.getTransactionName());
            } else {
                Agent.LOG.log(Level.FINER, "Not setting the transaction name to  \"{0}\" for transaction {1}: a higher priority name is already in place. Current transaction name is {2}", name, this, this.getTransactionName());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPriorityTransactionName(PriorityTransactionName ptn) {
        Object object = this.lock;
        synchronized (object) {
            return this.setPriorityTransactionNameLocked(ptn);
        }
    }

    private boolean setPriorityTransactionNameLocked(PriorityTransactionName ptn) {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        if (ptn == null) {
            return false;
        }
        this.priorityTransactionName = ptn;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlowQueryListener getSlowQueryListener(boolean createIfNotExists) {
        Object object = this.lock;
        synchronized (object) {
            if (this.slowQueryListener == null && createIfNotExists) {
                String appName = this.getApplicationName();
                this.slowQueryListener = ServiceFactory.getSqlTraceService().getSlowQueryListener(appName);
            }
            return this.slowQueryListener;
        }
    }

    public TransactionCache getTransactionCache() {
        return this.getTransactionActivity().getTransactionCache();
    }

    public boolean isStarted() {
        return this.getDispatcher() != null;
    }

    public boolean isFinished() {
        return this.isStarted() && this.activeCount.get() == 0;
    }

    public boolean isInProgress() {
        return this.isStarted() && this.activeCount.get() != 0;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public long getExternalTime() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return ((WebRequestDispatcher)this.dispatcher).getQueueTime();
        }
        return 0L;
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public List<Tracer> getTracers() {
        return new TracerList(this.getRootTracer(), this.getFinishedChildren());
    }

    public TransactionStats getOverLimitTxStatsforTesting() {
        return this.txStats;
    }

    public TransactionActivity getTransactionActivity() {
        if (this != Transaction.getTransaction(false)) {
            return this.initialActivity;
        }
        TransactionActivity result = TransactionActivity.get();
        if (result == null) {
            AgentBridge.TokenAndRefCount activeToken = (AgentBridge.TokenAndRefCount)AgentBridge.activeToken.get();
            if (activeToken != null && activeToken.token.isActive()) {
                return ((TokenImpl)activeToken.token).getInitiatingTracer().getTransactionActivity();
            }
            throw new IllegalStateException("TransactionActivity is gone");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activityStarted(TransactionActivity activity) {
        Agent.LOG.log(Level.FINER, "activity {0} starting", activity);
        this.startTransactionIfBeginning(activity.getRootTracer());
        Object object = this.lock;
        synchronized (object) {
            this.runningChildren.put(activity.hashCode(), activity);
            this.activeCount.incrementAndGet();
        }
    }

    public void startTransactionIfBeginning(Tracer tracer) {
        if (tracer instanceof TransactionActivityInitiator && this.rootTracer == null) {
            AgentConfig defaultConfig;
            Agent.LOG.log(Level.FINER, "Starting transaction {0}", this);
            this.captureWallClockStartTime();
            this.startGCTimeInMillis = ServiceFactory.getTransactionTraceService().isEnabled() ? ((defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig()).getTransactionTracerConfig().isGCTimeEnabled() ? Transaction.getGCTime() : -1L) : -1L;
            if (this.rootTracer == null) {
                this.rootTracer = tracer;
            }
            if (this.transactionTime == null) {
                this.transactionTime = new TransactionTimer(tracer.getStartTime());
                Agent.LOG.log(Level.FINER, "Set timer for transaction {0}", this);
            }
            if (this.dispatcher == null) {
                this.setDispatcher(((TransactionActivityInitiator)((Object)tracer)).createDispatcher());
            }
            ServiceFactory.getTransactionService().transactionStarted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatcher(Dispatcher dispatcher) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                Agent.LOG.log(Level.FINER, "Not setting dispatcher for transaction {0}. Dispatcher is already a web dispatcher.", this);
            } else {
                this.dispatcher = dispatcher;
                Agent.LOG.log(Level.FINER, "Set dispatcher for transaction {0} to {1}", this, dispatcher);
                if (this.isWebRequestSet()) {
                    this.getInboundHeaderState();
                }
            }
        }
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    public TransactionTimer getTransactionTimer() {
        return this.transactionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTransaction() {
        try {
            Object object = this.lock;
            synchronized (object) {
                TimedSet<TokenImpl> tokenCache;
                String instanceName;
                String displayHost;
                DistributedTracingConfig distributedTracingConfig;
                int count;
                this.freezeTransactionName();
                if (this.ignore) {
                    Agent.LOG.log(Level.FINER, "Transaction {0} was cancelled: ignored. This is not an error condition.", this);
                    ServiceFactory.getTransactionService().transactionCancelled(this);
                    return;
                }
                if (this.finishedChildren.isEmpty()) {
                    Agent.LOG.log(Level.FINER, "Transaction {0} was cancelled: no activities. This is not an error condition.", this);
                    ServiceFactory.getTransactionService().transactionCancelled(this);
                    return;
                }
                TransactionStats transactionStats = this.transactionFinishedActivityMerging();
                this.transactionTime.markTransactionAsDone();
                this.recordFinalGCTime(transactionStats);
                this.handleTokenTimeout(transactionStats);
                String txName = this.priorityTransactionName.getName();
                this.getInboundHeaderState();
                this.dispatcher.transactionFinished(txName, transactionStats);
                if (Agent.LOG.isFinerEnabled()) {
                    String requestURI = this.dispatcher == null ? "No Dispatcher Defined" : this.dispatcher.getUri();
                    Agent.LOG.log(Level.FINER, "Transaction {0} for request: {1} finished {2}ms {3}", txName, requestURI, this.transactionTime.getResponseTimeInMilliseconds(), this);
                }
                if (!ServiceFactory.getServiceManager().isStarted()) {
                    Agent.LOG.log(Level.INFO, "Transaction {0} tried to finish but ServiceManager not started", this);
                    return;
                }
                TransactionTracerConfig ttConfig = this.getTransactionTracerConfig();
                TransactionCounts rootCounts = this.getTransactionCounts();
                if (rootCounts.isOverTracerSegmentLimit()) {
                    this.getIntrinsicAttributes().put("segment_clamp", rootCounts.getSegmentCount());
                    transactionStats.getUnscopedStats().getStats("Supportability/TransactionSegmentClamp").recordDataPoint(rootCounts.getSegmentCount());
                }
                if (rootCounts.isOverTransactionSize()) {
                    this.getIntrinsicAttributes().put("size_limit", "The transaction size limit was reached");
                }
                if ((count = rootCounts.getStackTraceCount()) >= ttConfig.getMaxStackTraces()) {
                    this.getIntrinsicAttributes().put("stack_trace_clamp", count);
                }
                if (rootCounts.isOverTokenLimit()) {
                    this.getIntrinsicAttributes().put("tokenClamp", rootCounts.getTokenCount());
                }
                if ((count = rootCounts.getExplainPlanCount()) >= ttConfig.getMaxExplainPlans()) {
                    this.getIntrinsicAttributes().put("explain_plan_clamp", count);
                }
                if (!(distributedTracingConfig = this.getAgentConfig().getDistributedTracingConfig()).isEnabled()) {
                    String tripId;
                    String referrerGuid;
                    if (this.getInboundHeaderState().isTrustedCatRequest()) {
                        String id = this.getInboundHeaderState().getClientCrossProcessId();
                        this.getIntrinsicAttributes().put("client_cross_process_id", id);
                    }
                    if ((referrerGuid = this.getInboundHeaderState().getReferrerGuid()) != null) {
                        this.getIntrinsicAttributes().put("referring_transaction_guid", referrerGuid);
                    }
                    if ((tripId = this.getCrossProcessTransactionState().getTripId()) != null) {
                        this.getIntrinsicAttributes().put("trip_id", tripId);
                        int pathHash = this.getCrossProcessTransactionState().generatePathHash();
                        this.getIntrinsicAttributes().put("path_hash", ServiceUtils.intToHexString(pathHash));
                    }
                }
                if (this.isSynthetic()) {
                    Agent.LOG.log(Level.FINEST, "Completing Synthetics transaction for monitor {0}", this.getInboundHeaderState().getSyntheticsMonitorId());
                    this.getIntrinsicAttributes().put("synthetics_resource_id", this.getInboundHeaderState().getSyntheticsResourceId());
                    this.getIntrinsicAttributes().put("synthetics_monitor_id", this.getInboundHeaderState().getSyntheticsMonitorId());
                    this.getIntrinsicAttributes().put("synthetics_job_id", this.getInboundHeaderState().getSyntheticsJobId());
                }
                if (this.timeoutCause != null && this.timeoutCause.cause != null) {
                    this.getIntrinsicAttributes().put("nr.timeoutCause", this.timeoutCause.cause);
                }
                if ((displayHost = (String)this.getAgentConfig().getValue("process_host.display_name", null)) != null) {
                    this.getAgentAttributes().put("host.displayName", displayHost);
                }
                if ((instanceName = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getInstanceName()) != null) {
                    this.getAgentAttributes().put("process.instanceName", instanceName);
                }
                if (!((tokenCache = this.activeTokensCache.get()) != null && tokenCache.timedOutCount() != 0 || this.finishedChildren.size() != 1 || ServiceFactory.getThreadService().isAgentThreadId(Thread.currentThread().getId()))) {
                    this.getAgentAttributes().put("jvm.thread_name", Thread.currentThread().getName());
                }
                this.getIntrinsicAttributes().put("priority", Float.valueOf(this.getPriority()));
                TransactionData transactionData = new TransactionData(this, rootCounts.getTransactionSize());
                ServiceFactory.getTransactionService().transactionFinished(transactionData, transactionStats);
            }
        }
        catch (Throwable th) {
            Agent.LOG.log(Level.WARNING, th, "Transaction {0} was not reported because of an internal error.", this);
            ServiceFactory.getTransactionService().transactionCancelled(this);
        }
    }

    private TransactionStats transactionFinishedActivityMerging() {
        TransactionStats transactionStats = this.txStats;
        long totalCpuTime = 0L;
        boolean reportingCpu = true;
        Object val = this.getIntrinsicAttributes().remove("cpuTime");
        if (val instanceof Long && (totalCpuTime = ((Long)val).longValue()) < 0L) {
            reportingCpu = false;
        }
        for (TransactionActivity kid : this.getFinishedChildren()) {
            if (transactionStats == null) {
                transactionStats = kid.getTransactionStats();
            } else {
                TransactionStats stats = kid.getTransactionStats();
                transactionStats.getScopedStats().mergeStats(stats.getScopedStats());
                transactionStats.getUnscopedStats().mergeStats(stats.getUnscopedStats());
            }
            if (kid.getRootTracer() != null) {
                Map<String, Object> tracerAtts;
                Tracer rootTracer = kid.getRootTracer();
                this.transactionTime.markTransactionActivityAsDone(rootTracer.getEndTime(), rootTracer.getDuration());
                if (Agent.LOG.isFinestEnabled() && (tracerAtts = rootTracer.getAgentAttributes()) != null && !tracerAtts.isEmpty()) {
                    Agent.LOG.log(Level.FINEST, "Tracer Attributes for {0} are {1}", rootTracer, tracerAtts);
                }
            }
            if (!reportingCpu) continue;
            if (kid.getTotalCpuTime() >= 0L) {
                totalCpuTime += kid.getTotalCpuTime();
                continue;
            }
            reportingCpu = false;
        }
        if (reportingCpu && totalCpuTime > 0L) {
            this.getIntrinsicAttributes().put("cpuTime", totalCpuTime);
        }
        return transactionStats;
    }

    public synchronized void addTotalCpuTimeForLegacy(long time) {
        Object val = this.getIntrinsicAttributes().remove("cpuTime");
        long totalCpuTime = val instanceof Long ? (Long)val : 0L;
        if (totalCpuTime != -1L) {
            totalCpuTime += time;
        }
        this.getIntrinsicAttributes().put("cpuTime", totalCpuTime);
    }

    public void recordFinalGCTime(TransactionStats stats) {
        long gcTime;
        Long totalGCTime;
        if (this.isTransactionTraceEnabled() && this.getRunningDurationInNanos() > this.getTransactionTracerConfig().getTransactionThresholdInNanos() && (totalGCTime = (Long)this.getIntrinsicAttributes().get("gc_time")) == null && this.startGCTimeInMillis > -1L && (gcTime = Transaction.getGCTime()) != this.startGCTimeInMillis) {
            totalGCTime = gcTime - this.startGCTimeInMillis;
            this.getIntrinsicAttributes().put("gc_time", totalGCTime);
            stats.getUnscopedStats().getOrCreateResponseTimeStats("GC/cumulative").recordResponseTime(totalGCTime, TimeUnit.MILLISECONDS);
        }
    }

    private void handleTokenTimeout(TransactionStats stats) {
        int timedOutTokens;
        TimedSet<TokenImpl> tokenCache = this.activeTokensCache.get();
        int n = timedOutTokens = tokenCache != null ? tokenCache.timedOutCount() : 0;
        if (timedOutTokens > 0) {
            stats.getUnscopedStats().getStats("Supportability/Async/Token/Timeout").incrementCallCount(timedOutTokens);
        }
    }

    void cleanUp() {
        this.checkExpireTracedActivities();
        TimedSet<TokenImpl> tokenCache = this.activeTokensCache.get();
        if (tokenCache != null) {
            tokenCache.cleanUp();
        }
    }

    public boolean isTransactionTraceEnabled() {
        return this.ttEnabled;
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    public boolean isTransactionNamingEnabled() {
        return this.transactionNamingEnabled;
    }

    public TransactionNamingScheme getNamingScheme() {
        String appName = this.getPriorityApplicationName().getName();
        AgentConfig appConfig = ServiceFactory.getConfigService().getAgentConfig(appName);
        return appConfig.getTransactionNamingScheme();
    }

    public boolean isSynthetic() {
        return this.getInboundHeaderState().isTrustedSyntheticsRequest();
    }

    public void provideHeaders(InboundHeaders headers) {
        if (headers != null) {
            String encodingKey = this.getCrossProcessConfig().getEncodingKey();
            this.provideRawHeaders((InboundHeaders)new DeobfuscatedInboundHeaders(headers, encodingKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideRawHeaders(InboundHeaders headers) {
        if (headers != null) {
            Object object = this.lock;
            synchronized (object) {
                Agent.LOG.log(Level.FINEST, "Provided headers in transaction {0}", this);
                this.providedHeaders = headers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundHeaderState getInboundHeaderState() {
        if (this.inboundHeaderState == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.inboundHeaderState == null) {
                    InboundHeaders requestHeaders = Transaction.getRequestHeaders(this);
                    if (requestHeaders == null) {
                        if (this.providedHeaders != null) {
                            Agent.LOG.log(Level.FINEST, "Using provided headers in transaction {0}", this);
                        }
                        requestHeaders = this.providedHeaders == null ? null : this.providedHeaders;
                    } else {
                        Agent.LOG.log(Level.FINEST, "Using request headers in transaction {0}", this);
                    }
                    try {
                        this.inboundHeaderState = new InboundHeaderState(this, requestHeaders);
                    }
                    catch (RuntimeException rex) {
                        Agent.LOG.log(Level.FINEST, "Unable to parse inbound headers in transaction {0}: {1}", this, rex);
                        this.inboundHeaderState = new InboundHeaderState(this, null);
                    }
                }
            }
        }
        return this.inboundHeaderState;
    }

    static InboundHeaders getRequestHeaders(Transaction tx) {
        if (tx.dispatcher != null && tx.dispatcher.getRequest() != null) {
            return new DeobfuscatedInboundHeaders((InboundHeaders)tx.dispatcher.getRequest(), tx.getCrossProcessConfig().getEncodingKey());
        }
        return null;
    }

    public IRPMService getRPMService() {
        return ServiceFactory.getRPMServiceManager().getOrCreateRPMService(this.getPriorityApplicationName());
    }

    public static void clearTransaction() {
        transactionHolder.remove();
        TransactionActivity.clear();
        AgentBridge.activeToken.remove();
    }

    public static void setTransaction(Transaction tx) {
        TransactionActivity.set(tx.initialActivity);
        transactionHolder.set(tx);
    }

    public static Transaction getTransaction() {
        return Transaction.getTransaction(true);
    }

    public void refreshToken(TokenImpl token) {
        TimedSet<TokenImpl> tokenCache = this.activeTokensCache.get();
        if (tokenCache != null) {
            tokenCache.refresh(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean linkTxOnThread(TokenImpl token) {
        Transaction newTx;
        WeakRefTransaction weakRefTransaction = token.getTransaction();
        Transaction transaction = newTx = weakRefTransaction == null ? null : weakRefTransaction.getTransactionIfExists();
        if (newTx != null) {
            newTx.refreshToken(token);
        }
        Transaction oldTx = null;
        AgentBridge.TokenAndRefCount activeToken = (AgentBridge.TokenAndRefCount)AgentBridge.activeToken.get();
        if (activeToken != null && activeToken.token.isActive()) {
            oldTx = ((TokenImpl)activeToken.token).getTransaction().getTransactionIfExists();
        }
        if (oldTx == null) {
            oldTx = transactionHolder.get();
        }
        if (newTx == null || newTx == oldTx) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because transaction already on thread.", newTx);
            return false;
        }
        Object object = newTx.lock;
        synchronized (object) {
            if (!newTx.isInProgress()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because transaction not in progress.", newTx);
                return false;
            }
            if (!token.isActive()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because token is no longer active {1}.", newTx, token);
                return false;
            }
            TransactionActivity oldTxa = TransactionActivity.get();
            if (oldTxa == null || !oldTxa.isStarted()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because there is no started txa to link to: {1}.", newTx, oldTxa);
                return false;
            }
            Tracer tracer = token.getInitiatingTracer();
            if (tracer == null || !token.isActive()) {
                return false;
            }
            int oldTxaId = oldTxa.hashCode();
            oldTxa.startAsyncActivity(newTx, newTx.nextActivityId.getAndIncrement(), tracer);
            if (oldTx != null) {
                PriorityTransactionName ptn;
                PriorityApplicationName pan = oldTx.getPriorityApplicationName();
                if (pan != PriorityApplicationName.NONE) {
                    newTx.setApplicationName(pan.getPriority(), pan.getName(), true);
                }
                if ((ptn = oldTx.getPriorityTransactionName()) != PriorityTransactionName.NONE) {
                    newTx.setTransactionName(ptn.getPriority(), true, ptn.getCategory(), oldTx.getTransactionName());
                }
                newTx.getInternalParameters().putAll(oldTx.getInternalParameters());
                newTx.getPrefixedAgentAttributes().putAll(oldTx.getPrefixedAgentAttributes());
                newTx.getAgentAttributes().putAll(oldTx.getAgentAttributes());
                newTx.getIntrinsicAttributes().putAll(oldTx.getIntrinsicAttributes());
                newTx.getUserAttributes().putAll(oldTx.getUserAttributes());
                newTx.getErrorAttributes().putAll(oldTx.getErrorAttributes());
                oldTx.ignore = true;
                oldTx.checkExpire();
                oldTx.checkFinishTransaction(oldTxa, oldTxaId);
                transactionHolder.set(null);
            }
            transactionHolder.set(newTx);
            return true;
        }
    }

    public void startFastAsyncWork(TransactionActivity txa, Tracer tracer) {
        txa.startAsyncActivity(this, this.nextActivityId.getAndIncrement(), tracer);
    }

    public static Transaction getTransaction(boolean createIfNotExists) {
        Transaction tx = transactionHolder.get();
        AgentBridge.TokenAndRefCount activeToken = (AgentBridge.TokenAndRefCount)AgentBridge.activeToken.get();
        if (activeToken != null && activeToken.token != null && activeToken.token.isActive() && tx == null) {
            WeakRefTransaction weakRefTx = (WeakRefTransaction)activeToken.token.getTransaction();
            tx = weakRefTx.getTransactionIfExists();
        }
        if (tx == null && createIfNotExists && !(Thread.currentThread() instanceof ThreadService.AgentThread)) {
            if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
                return Transaction.getOrCreateDummyTransaction();
            }
            try {
                tx = new Transaction();
                tx.postConstruct();
                transactionHolder.set(tx);
            }
            catch (RuntimeException rex) {
                Agent.LOG.log(Level.FINEST, rex, "while creating Transaction");
                TransactionActivity.clear();
                throw rex;
            }
        }
        return tx;
    }

    protected static synchronized Transaction getOrCreateDummyTransaction() {
        if (dummyTransaction == null) {
            dummyTransaction = new DummyTransaction();
        }
        return dummyTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setNormalizedUri(String normalizedUri) {
        Object object = this.lock;
        synchronized (object) {
            if (normalizedUri == null || normalizedUri.length() == 0) {
                return;
            }
            TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
            if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(this, TransactionNamePriority.CUSTOM_HIGH)) {
                String msg = MessageFormat.format("Setting transaction name to normalized URI \"{0}\" for transaction {1}", normalizedUri, this);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(this, normalizedUri, "NormalizedUri", TransactionNamePriority.CUSTOM_HIGH);
            this.normalizedUri = normalizedUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getNormalizedUri() {
        Object object = this.lock;
        synchronized (object) {
            return this.normalizedUri;
        }
    }

    public TransactionThrowable getThrowable() {
        return this.errorTracker.getThrowable();
    }

    public boolean isErrorReportableAndNotIgnored() {
        int responseStatus;
        ErrorAnalyzerImpl errorAnalyzer = new ErrorAnalyzerImpl(this.getAgentConfig().getErrorCollectorConfig());
        boolean isReportable = errorAnalyzer.isReportable(responseStatus = this.getStatus(), this.getThrowable());
        return isReportable && !this.ignoreErrors && !errorAnalyzer.isIgnoredError(responseStatus, this.getThrowable() == null ? null : this.getThrowable().throwable);
    }

    public boolean isErrorNotExpected() {
        int responseStatus = this.getStatus();
        ErrorAnalyzerImpl errorAnalyzer = new ErrorAnalyzerImpl(this.getAgentConfig().getErrorCollectorConfig());
        return !errorAnalyzer.isExpectedError(responseStatus, this.getThrowable());
    }

    public int getStatus() {
        return this.getWebResponse().getStatus();
    }

    public String getStatusMessage() {
        return this.getWebResponse().getStatusMessage();
    }

    public void freezeStatus() {
        this.getWebResponse().freezeStatus();
    }

    public void setThrowable(Throwable throwable, TransactionErrorPriority priority, boolean expected) {
        if (throwable == null) {
            return;
        }
        if (TransactionActivity.get() != this.initialActivity && priority != TransactionErrorPriority.API) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Non-API call to setThrowable from asynchronous activity ignored: {0} with priority {1}", throwable, (Object)priority);
            }
            return;
        }
        if (this.ignoreErrorPriority) {
            this.errorTracker.setThrowable(throwable, priority, expected, this.safeGetMostRecentSpanId());
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, "Attempting to set throwable in transaction: {0} having priority {1} with priority {2}", throwable.getClass().getName(), (Object)this.errorTracker.getPriority(), (Object)priority);
        }
        if (this.errorTracker.tryUpdatePriority(priority)) {
            this.errorTracker.setThrowable(throwable, priority, expected, this.safeGetMostRecentSpanId());
        }
    }

    private String safeGetMostRecentSpanId() {
        try {
            return this.getTransactionActivity().getLastTracer().getGuid();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public void noticeTracerException(Throwable throwable, String spanId) {
        this.errorTracker.noticeTracerException(throwable, spanId);
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void ignore() {
        this.setIgnore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnore(boolean ignore) {
        if (this.dispatcher != null) {
            Object object = this.lock;
            synchronized (object) {
                this.ignore = ignore;
                for (TransactionActivity child : this.runningChildren.values()) {
                    child.setOwningTransactionIsIgnored(true);
                }
                for (TransactionActivity finishedChild : this.finishedChildren) {
                    finishedChild.setOwningTransactionIsIgnored(true);
                }
            }
            MetricNames.recordApiSupportabilityMetric("Ignore");
        } else {
            Agent.LOG.log(Level.FINEST, "setIgnore called outside of an open transaction");
        }
    }

    public void ignoreApdex() {
        if (this.isStarted()) {
            this.dispatcher.setIgnoreApdex(true);
            MetricNames.recordApiSupportabilityMetric("IgnoreApdex");
        } else {
            Agent.LOG.finer("ignoreApdex invoked with no transaction");
        }
    }

    public void ignoreErrors() {
        if (this.isStarted()) {
            this.ignoreErrors = true;
            MetricNames.recordApiSupportabilityMetric("IgnoreErrors");
        } else {
            Agent.LOG.finer("ignoreErrors invoked with no transaction");
        }
    }

    public TransactionCounts getTransactionCounts() {
        return this.counts;
    }

    public boolean shouldGenerateTransactionSegment() {
        return this.ttEnabled && this.getTransactionCounts().shouldGenerateTransactionSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatementParser getDatabaseStatementParser() {
        if (databaseStatementParser == null) {
            Object object = this.lock;
            synchronized (object) {
                if (databaseStatementParser == null) {
                    databaseStatementParser = this.createDatabaseStatementParser();
                }
            }
        }
        return databaseStatementParser;
    }

    private DatabaseStatementParser createDatabaseStatementParser() {
        return new CachingDatabaseStatementParser(ServiceFactory.getDatabaseService().getDatabaseStatementParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserTransactionState getBrowserTransactionState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.browserTransactionState == null) {
                this.browserTransactionState = BrowserTransactionStateImpl.create(this);
            }
            return this.browserTransactionState;
        }
    }

    public CrossProcessState getCrossProcessState() {
        return this.getCrossProcessTransactionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrossProcessTransactionState getCrossProcessTransactionState() {
        if (this.crossProcessTransactionState == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.crossProcessTransactionState == null) {
                    this.crossProcessTransactionState = CrossProcessTransactionStateImpl.create(this);
                }
            }
        }
        return this.crossProcessTransactionState;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        Agent.disableFastPath();
        this.transactionState = transactionState;
    }

    public void addOutboundResponseHeaders() {
        this.getCrossProcessTransactionState().writeResponseHeaders();
    }

    public WebResponse getWebResponse() {
        if (this.dispatcher instanceof WebResponse) {
            return (WebResponse)this.dispatcher;
        }
        return DEFAULT_RESPONSE;
    }

    public boolean isWebTransaction() {
        return this.dispatcher != null && this.dispatcher.isWebTransaction();
    }

    public void convertToWebTransaction() {
        if (!this.isWebTransaction()) {
            this.setDispatcher(new WebRequestDispatcher(DUMMY_REQUEST, DUMMY_RESPONSE, this));
        }
    }

    public void setRequestAndResponse(Request request, Response response) {
        Request req = request == null ? DUMMY_REQUEST : request;
        Response res = response == null ? DUMMY_RESPONSE : response;
        this.setDispatcher(new WebRequestDispatcher(req, res, this));
    }

    public boolean isWebRequestSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_REQUEST.equals(this.dispatcher.getRequest());
        }
        return false;
    }

    public boolean isWebResponseSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_RESPONSE.equals(this.dispatcher.getResponse());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebRequest(Request req) {
        Request request = req == null ? DUMMY_REQUEST : req;
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                if (DUMMY_REQUEST.equals(this.dispatcher.getRequest())) {
                    this.dispatcher.setRequest(request);
                    Agent.LOG.log(Level.FINEST, "Set web request for transaction {0} to {1}", this, request);
                    this.getInboundHeaderState();
                } else {
                    Agent.LOG.log(Level.FINEST, "Not setting web request for transaction {0}. Web request is already set.", this);
                }
            } else {
                Agent.LOG.log(Level.FINEST, "Set web request for transaction {0}", this);
                this.setDispatcher(new WebRequestDispatcher(request, DUMMY_RESPONSE, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebResponse(Response resp) {
        Response response = resp == null ? DUMMY_RESPONSE : resp;
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                if (DUMMY_RESPONSE.equals(this.dispatcher.getResponse())) {
                    this.dispatcher.setResponse(response);
                    Agent.LOG.log(Level.FINEST, "Set web response for transaction {0} to {1}", this, response);
                } else {
                    Agent.LOG.log(Level.FINEST, "Not setting web response for transaction {0}. Web response is already set.", this);
                }
            } else {
                Agent.LOG.log(Level.FINEST, "Set web response for transaction {0}. Transaction does not have a corresponding request", this);
                this.setDispatcher(new WebRequestDispatcher(DUMMY_REQUEST, response, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(Request request, Response response) {
        Agent.LOG.log(Level.FINEST, "Request initialized: {0}", request.getRequestURI());
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Transaction/RequestInitialized", 1));
            if (this.isFinished()) {
                return;
            }
            if (this.dispatcher == null) {
                ExitTracer tracer = AgentBridge.instrumentation.createTracer(null, REQUEST_INITIALIZED_CLASS_SIGNATURE_ID, null, 14);
                if (tracer != null) {
                    if (response == null) {
                        response = DUMMY_RESPONSE;
                    }
                    this.setDispatcher(new WebRequestDispatcher(request, response, this));
                }
            } else {
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Transaction/RequestInitialized/TransactionStarted", 1));
                Agent.LOG.finer("requestInitialized(): transaction already started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed() {
        Agent.LOG.log(Level.FINEST, "Request destroyed");
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Transaction/RequestDestroyed", 1));
            if (!this.isInProgress()) {
                return;
            }
            Tracer rootTracer = this.getTransactionActivity().getRootTracer();
            Tracer lastTracer = this.getTransactionActivity().getLastTracer();
            if (lastTracer != null && rootTracer == lastTracer) {
                Transaction currentTxn = Transaction.getTransaction(false);
                if (currentTxn != null) {
                    currentTxn.addOutboundResponseHeaders();
                    lastTracer.finish(177, null);
                }
            } else {
                Agent.LOG.log(Level.FINER, "Inconsistent state!  tracer != last tracer for {0} ({1} != {2})", this, rootTracer, lastTracer);
            }
        }
    }

    public static boolean isDummyRequest(Request request) {
        return request == DUMMY_REQUEST;
    }

    public String getApplicationName() {
        return this.getPriorityApplicationName().getName();
    }

    public PriorityApplicationName getPriorityApplicationName() {
        return this.appNameAndConfig.get().getName();
    }

    public void setApplicationName(ApplicationNamePriority priority, String appName) {
        this.setApplicationName(priority, appName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setApplicationName(ApplicationNamePriority priority, String appName, boolean override) {
        if (appName == null || appName.length() == 0) {
            return;
        }
        AbstractApplicationNamingPolicy policy = override ? SameOrHigherPriorityApplicationNamingPolicy.getInstance() : HigherPriorityApplicationNamingPolicy.getInstance();
        Object object = this.lock;
        synchronized (object) {
            if (policy.canSetApplicationName(this, priority)) {
                String name = Transaction.stripLeadingForwardSlash(appName);
                PriorityApplicationName pan = PriorityApplicationName.create(name, priority);
                if (pan.equals(this.getPriorityApplicationName())) {
                    return;
                }
                Agent.LOG.log(Level.FINE, "Set application name to {0}", pan.getName());
                this.appNameAndConfig.set(new AppNameAndConfig(pan));
            }
        }
    }

    private static String stripLeadingForwardSlash(String appName) {
        String FORWARD_SLASH = "/";
        if (appName.length() > 1 && appName.startsWith("/")) {
            return appName.substring(1);
        }
        return appName;
    }

    public long getRunningDurationInNanos() {
        if (this.dispatcher == null) {
            return 0L;
        }
        return this.transactionTime.getRunningDurationInNanos();
    }

    public void saveMessageParameters(Map<String, String> parameters) {
        MessagingUtil.recordParameters(this, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken() {
        if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: cannot create token, circuit breaker is tripped.", this);
            return NoOpToken.INSTANCE;
        }
        if (this.isIgnore()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: cannot create token, transaction is ignored.", this);
            return NoOpToken.INSTANCE;
        }
        if (!this.isStarted()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: cannot create token, transaction not started.", this);
            return NoOpToken.INSTANCE;
        }
        Tracer parent = this.getTransactionActivity().getLastTracer();
        if (parent == null || parent.isLeaf()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: cannot create token, no last tracer on {1}.", this, this.getTransactionActivity());
            return NoOpToken.INSTANCE;
        }
        if (this.counts.isOverTokenLimit()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: async token limit {1} exceeded. Ignoring all further async activity", this, this.counts.getMaxTokens());
            return NoOpToken.INSTANCE;
        }
        TokenImpl token = null;
        boolean wasAdded = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isFinished()) {
                token = new TokenImpl(parent);
                this.activeCount.incrementAndGet();
                this.counts.getToken();
                TimedSet<TokenImpl> tokenCache = this.activeTokensCache.get();
                if (tokenCache == null) {
                    this.activeTokensCache.compareAndSet(null, new TimedTokenSet(TransactionStaticsHolder.ASYNC_TIMEOUT_SECONDS(), TimeUnit.SECONDS, ServiceFactory.getExpirationService()));
                    tokenCache = this.activeTokensCache.get();
                }
                tokenCache.put(token);
                wasAdded = true;
            }
        }
        if (!wasAdded) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: already finished. cannot create token", this);
            return NoOpToken.INSTANCE;
        }
        Agent.LOG.log(Level.FINEST, "Transaction {0}: created active token {1}", this, token);
        this.getMetricAggregator().incrementCounter(((WeavePackageType)AgentBridge.currentApiSource.get()).getSupportabilityMetric("Token"));
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean expireToken(TokenImpl token) {
        boolean tokenWasActive = false;
        Transaction tx = token.getTransaction().getTransactionIfExists();
        if (tx != null) {
            Object object = tx.lock;
            synchronized (object) {
                TimedSet<TokenImpl> tokenCache = tx.activeTokensCache.get();
                if (!tx.isFinished() && tokenCache != null) {
                    tokenWasActive = tokenCache.remove(token);
                    Agent.LOG.log(Level.FINEST, "Transaction {0}: expired token {1}", tx, token);
                } else {
                    Agent.LOG.log(Level.FINER, "Transaction {0}: token {1} is not active and so cannot be expired", tx, token);
                }
            }
        }
        return tokenWasActive;
    }

    public void expireAllTokensForCurrentTransaction() {
        int count = this.activeCount.get();
        TimedSet<TokenImpl> tokenCache = this.activeTokensCache.get();
        if (!this.isFinished() && count > 0 && tokenCache != null) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: forcibly expiring all {1} active tokens", this, count);
            tokenCache.removeAll();
        }
    }

    public void onRemoval() {
        this.checkFinishTransactionFromToken();
    }

    public void checkExpire() {
        this.checkExpireTracedActivities();
        this.checkExpireTokens();
    }

    private void checkExpireTokens() {
        int count;
        if (!this.isFinished() && this.runningChildren.size() == 0 && (count = this.activeCount.get()) > 0) {
            long time = this.transactionTime.getTimeLastTxaFinished() + TransactionStaticsHolder.ASYNC_TIMEOUT_NANO();
            if (System.nanoTime() >= time) {
                Agent.LOG.log(Level.FINE, "Transaction {0}: forcibly expiring {1} token(s) due to time out.", this, count);
                this.expireAllTokensForCurrentTransaction();
            }
        }
    }

    public Segment startSegment(String category, String segmentName) {
        if (this.counts.isOverTracerSegmentLimit() || ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped() || this.isIgnore()) {
            return null;
        }
        Tracer parent = this.getTransactionActivity().getLastTracer();
        if (parent == null || parent.isLeaf()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: cannot create event, no last tracer on {1}", this, this.getTransactionActivity());
            return null;
        }
        TransactionActivity txa = TransactionActivity.createWithoutHolder(this, this.nextActivityId.getAndIncrement(), SEGMENT_TXA_DEFAULT_ASYNC_CONTEXT);
        ClassMethodSignature cms = new ClassMethodSignature(segmentName, "", "");
        OtherRootTracer tracer = new OtherRootTracer(txa, cms, SEGMENT_INVOKER, SEGMENT_URI);
        tracer.setMetricName(new String[]{category, segmentName});
        AgentBridge.TokenAndRefCount tokenAndRefCount = (AgentBridge.TokenAndRefCount)AgentBridge.activeToken.get();
        if (tokenAndRefCount != null) {
            parent = tokenAndRefCount.tracedMethod.getAndSet(tracer);
        }
        Segment segment = new Segment(parent, tracer);
        txa.setSegment(segment);
        tracer.setParentTracer(parent);
        txa.tracerStarted(tracer);
        Agent.LOG.log(Level.FINEST, "Transaction {0}: startSegment(): {1} created and started with tracer {2}", this, segment, tracer);
        this.getMetricAggregator().incrementCounter(((WeavePackageType)AgentBridge.currentApiSource.get()).getSupportabilityMetric("Segment"));
        return segment;
    }

    public void ignoreSegmentIfUnfinished(Segment event) {
        Tracer segmentTracer = event.getTracer();
        MetricNames.recordApiSupportabilityMetric("Segment/Ignore");
        if (segmentTracer.getTransactionActivity().isFinished()) {
            Agent.LOG.log(Level.FINEST, "Transaction {0}: segment {1} already finished. Not ignoring it.");
        } else {
            segmentTracer.getTransactionActivity().setToIgnore();
            segmentTracer.finish(176, null);
        }
    }

    public void finishSegment(Segment segment, Throwable throwable, Tracer parent, String endThreadName) {
        Tracer tracer = segment.getTracer();
        if (!segment.getInitiatingThread().equals(endThreadName)) {
            tracer.setAgentAttribute("async_context", "segment-api");
            tracer.setAgentAttribute("start_thread", segment.getInitiatingThread());
            tracer.setAgentAttribute("end_thread", endThreadName);
        } else {
            tracer.removeAgentAttribute("async_context");
        }
        this.finishedChildren.add(tracer.getTransactionActivity());
        tracer.getTransactionActivity().setTotalCpuTime(0L);
        Agent.LOG.log(Level.FINEST, "{0}--finish segment(): {1} async finish with tracer {2}", this, segment, tracer);
        MetricNames.recordApiSupportabilityMetric("Segment/End");
        this.finishTracer(throwable, tracer);
    }

    private void finishTracer(Throwable throwable, Tracer tracer) {
        if (throwable == null) {
            tracer.finish(176, null);
        } else {
            tracer.finish(throwable);
        }
    }

    public int getRunningTransactionActivityCount() {
        return this.runningChildren.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFailedOrIgnored(TransactionActivity activity, int opcode) {
        String occurred = activity.isIgnored() ? "IGNORED" : "FAILED";
        Agent.LOG.log(Level.FINER, "Transaction {0}: activity {1} {2} with opcode {3}", this, activity, occurred, opcode);
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.isFinished()) {
                    this.finishedChildren.remove(activity);
                    this.checkFinishTransaction(activity);
                }
            }
            finally {
                if (!activity.isNotInThreadLocal()) {
                    transactionHolder.remove();
                }
            }
        }
    }

    private void checkFinishTransactionFromToken() {
        this.checkFinishTransaction(null, null);
    }

    private void checkFinishTransaction(TransactionActivity txa) {
        this.checkFinishTransaction(txa, txa.hashCode());
    }

    private void checkFinishTransaction(TransactionActivity txa, Integer runningChildrenKey) {
        if (this.isStarted()) {
            if (txa != null) {
                this.transactionTime.markTxaFinishTime(txa.getRootTracer());
                if (runningChildrenKey != null) {
                    this.runningChildren.remove(runningChildrenKey);
                }
            }
            if (this.activeCount.decrementAndGet() == 0) {
                this.finishTransaction();
            }
        }
    }

    private void threadAssertion() {
        if (Agent.LOG.isFinestEnabled() && !Thread.holdsLock(this.lock)) {
            Agent.LOG.log(Level.FINEST, THREAD_ASSERTION_FAILURE, new Exception(THREAD_ASSERTION_FAILURE).fillInStackTrace());
        }
    }

    private void checkExpireTracedActivities() {
        long currentMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        for (TransactionActivity txa : this.runningChildren.values()) {
            long duration;
            Tracer tracer;
            Segment segment = txa.getSegment();
            if (segment == null || segment.isFinished() || (tracer = segment.getTracer()) == null || (duration = currentMillis - tracer.getStartTimeInMilliseconds()) <= TransactionStaticsHolder.SEGMENT_TIMEOUT_MILLIS()) continue;
            this.reportTracedActivityTimeout(txa);
            segment.setTruncated();
            this.setTimeoutCause(TimeoutCause.SEGMENT);
            segment.end();
        }
    }

    private void reportTracedActivityTimeout(TransactionActivity txa) {
        String message = "Segment timed out after %d seconds. The \"segment_timeout\" configuration parameter can be used to adjust this timeout. The affected transaction name is %s.%n";
        String name = "unknown";
        if (txa.getTransaction() != null && txa.getTransaction().getTransactionName() != null) {
            name = "\"" + txa.getTransaction().getTransactionName() + "\"";
        }
        Agent.LOG.log(Level.INFO, String.format("Segment timed out after %d seconds. The \"segment_timeout\" configuration parameter can be used to adjust this timeout. The affected transaction name is %s.%n", TransactionStaticsHolder.SEGMENT_TIMEOUT_MILLIS() / 1000L, name));
        Agent.LOG.log(Level.FINE, "Segment {0}-{1} timed out on tx {2}", txa.getSegment(), txa, txa.getTransaction());
        NewRelic.incrementCounter((String)"Supportability/Timeout/finishSegmentNotCalled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFinished(TransactionActivity activity, Tracer tracer, int opcode) {
        Agent.LOG.log(Level.FINER, "Transaction {0}: Activity {1} finished with opcode {2}", this, activity, opcode);
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.isFinished()) {
                    if (!tracer.isTransactionSegment()) {
                        if (this.txStats == null) {
                            this.txStats = activity.getTransactionStats();
                        } else {
                            TransactionStats toMergeStats = activity.getTransactionStats();
                            this.txStats.getScopedStats().mergeStats(toMergeStats.getScopedStats());
                            this.txStats.getUnscopedStats().mergeStats(toMergeStats.getUnscopedStats());
                        }
                    } else {
                        this.finishedChildren.add(activity);
                    }
                    this.checkFinishTransaction(activity);
                }
            }
            finally {
                if (!activity.isNotInThreadLocal()) {
                    transactionHolder.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransactionActivity> getFinishedChildren() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<TransactionActivity>(this.finishedChildren);
        }
    }

    public float getPriority() {
        Float priority = this.priority.get();
        return priority == null ? 0.0f : priority.floatValue();
    }

    public void setPriorityIfNotNull(Float priority) {
        if (priority != null) {
            this.priority.set(priority);
        }
    }

    public boolean sampled() {
        Float priority = this.priority.get();
        return priority != null && DistributedTraceUtil.isSampledPriority(priority.floatValue());
    }

    private String getTransactionName() {
        String fullName = this.getPriorityTransactionName().getName();
        String category = this.getPriorityTransactionName().getCategory();
        String prefix = this.getPriorityTransactionName().getPrefix();
        String txnNamePrefix = prefix + '/' + category + '/';
        if (fullName != null && fullName.startsWith(txnNamePrefix)) {
            return fullName.substring(txnNamePrefix.length());
        }
        return fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getCountOfRunningAndFinishedTransactionActivities() {
        Object object = this.lock;
        synchronized (object) {
            return this.runningChildren.size() + this.finishedChildren.size();
        }
    }

    static {
        DEFAULT_RESPONSE = new WebResponse(){

            public void setStatusMessage(String message) {
            }

            public void setStatus(int statusCode) {
            }

            public int getStatus() {
                return 0;
            }

            public String getStatusMessage() {
                return null;
            }

            public void freezeStatus() {
            }
        };
        DUMMY_REQUEST = new Request(){

            public String[] getParameterValues(String name) {
                return null;
            }

            public Enumeration<?> getParameterNames() {
                return null;
            }

            public Object getAttribute(String name) {
                return null;
            }

            public String getRequestURI() {
                return "/";
            }

            public String getRemoteUser() {
                return null;
            }

            public String getHeader(String name) {
                return null;
            }

            public String getCookieValue(String name) {
                return null;
            }

            public HeaderType getHeaderType() {
                return HeaderType.HTTP;
            }
        };
        DUMMY_RESPONSE = new Response(){

            public int getStatus() throws Exception {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Using default status code 0.");
                return 0;
            }

            public String getStatusMessage() throws Exception {
                Agent.LOG.log(Level.FINEST, "Web response is not set. No status message.");
                return null;
            }

            public void setHeader(String name, String value) {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Not setting header {0} : {1}.", name, value);
            }

            public String getContentType() {
                Agent.LOG.log(Level.FINEST, "Web response is not set. No content type.");
                return null;
            }

            public HeaderType getHeaderType() {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Header type is HTTP.");
                return HeaderType.HTTP;
            }
        };
        SEGMENT_INVOKER = null;
        SEGMENT_URI = new SimpleMetricNameFormat(SEGMENT_TXA_DEFAULT_ASYNC_CONTEXT);
    }

    private static class AppNameAndConfig {
        private final PriorityApplicationName appName;
        private volatile AgentConfig appConfig;

        AppNameAndConfig(PriorityApplicationName name) {
            this(name, null);
        }

        AppNameAndConfig(PriorityApplicationName name, AgentConfig config) {
            this.appName = name;
            this.appConfig = config;
        }

        PriorityApplicationName getName() {
            return this.appName;
        }

        AgentConfig getConfig() {
            if (this.appConfig == null) {
                this.appConfig = ServiceFactory.getConfigService().getAgentConfig(this.appName.getName());
            }
            return this.appConfig;
        }

        public static AppNameAndConfig getDefault() {
            AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
            String appName = defaultConfig.getApplicationName();
            PriorityApplicationName pan = PriorityApplicationName.create(appName, ApplicationNamePriority.NONE);
            return new AppNameAndConfig(pan, defaultConfig);
        }
    }
}

