/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.CommandParserConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CommandParserConfigImpl
extends BaseConfig
implements CommandParserConfig {
    public static final String ROOT = "command_parser";
    public static final String ENABLED = "enabled";
    public static final String DISALLOW = "disallow";
    @Deprecated
    public static final String BLACKLIST = "blacklist";
    private static final boolean DEFAULT_ENABLED = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.command_parser.";
    private final boolean enabled = this.getProperty("enabled", true);
    private final Set<String> disallowedCommands;

    public CommandParserConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        HashSet<String> disallowedList = new HashSet<String>(this.getUniqueStrings(DISALLOW));
        CommandParserConfigImpl.addDeprecatedProperty(new String[]{ROOT, BLACKLIST}, new String[]{ROOT, DISALLOW});
        if (disallowedList.isEmpty()) {
            disallowedList.addAll(this.getUniqueStrings(BLACKLIST));
        }
        this.disallowedCommands = Collections.unmodifiableSet(disallowedList);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Set<String> getDisallowedCommands() {
        return this.disallowedCommands;
    }
}

