/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StripExceptionConfigImpl
extends BaseConfig
implements StripExceptionConfig {
    public static final String ENABLED = "enabled";
    @Deprecated
    public static final String WHITELIST = "whitelist";
    public static final String ALLOWED_CLASSES = "allowed_classes";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.strip_exception_messages.";
    private final boolean isEnabled;
    private final Set<String> allowedClasses;

    private StripExceptionConfigImpl(Map<String, Object> props, boolean highSecurity) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.isEnabled = this.getProperty(ENABLED, highSecurity);
        HashSet<String> allowedClasses = new HashSet<String>(this.getUniqueStrings(ALLOWED_CLASSES));
        StripExceptionConfigImpl.addDeprecatedProperty(new String[]{"strip_exception_messages", WHITELIST}, new String[]{"strip_exception_messages", ALLOWED_CLASSES});
        if (allowedClasses.isEmpty()) {
            allowedClasses.addAll(this.getUniqueStrings(WHITELIST));
        }
        this.allowedClasses = Collections.unmodifiableSet(new HashSet<String>(allowedClasses));
    }

    @VisibleForTesting
    public StripExceptionConfigImpl(boolean enabled, Set<String> allowedClasses) {
        super(Collections.emptyMap());
        this.isEnabled = enabled;
        this.allowedClasses = allowedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(allowedClasses);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Set<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    static StripExceptionConfig createStripExceptionConfig(Map<String, Object> settings, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new StripExceptionConfigImpl(settings, highSecurity);
    }
}

