/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.internal;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.com.google.common.util.concurrent.ListenableFuture;
import com.newrelic.agent.deps.com.google.common.util.concurrent.SettableFuture;
import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.InternalChannelz;
import com.newrelic.agent.deps.io.grpc.InternalLogId;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import com.newrelic.agent.deps.io.grpc.Status;
import com.newrelic.agent.deps.io.grpc.internal.ClientStream;
import com.newrelic.agent.deps.io.grpc.internal.ClientStreamListener;
import com.newrelic.agent.deps.io.grpc.internal.ClientTransport;
import com.newrelic.agent.deps.io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        return new FailingClientStream(this.error, this.rpcProgress);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

