/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.kotlin.time;

import com.newrelic.agent.deps.kotlin.Metadata;
import com.newrelic.agent.deps.kotlin.SinceKotlin;
import com.newrelic.agent.deps.kotlin.jvm.internal.DefaultConstructorMarker;
import com.newrelic.agent.deps.kotlin.jvm.internal.Intrinsics;
import com.newrelic.agent.deps.kotlin.time.Duration;
import com.newrelic.agent.deps.kotlin.time.DurationKt;
import com.newrelic.agent.deps.kotlin.time.ExperimentalTime;
import com.newrelic.agent.deps.kotlin.time.TimeMark;
import com.newrelic.agent.deps.kotlin.time.TimeSource;
import com.newrelic.agent.deps.org.jetbrains.annotations.NotNull;
import java.util.concurrent.TimeUnit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\fB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH$R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/newrelic/agent/deps/kotlin/time/AbstractDoubleTimeSource;", "Lcom/newrelic/agent/deps/kotlin/time/TimeSource;", "unit", "Ljava/util/concurrent/TimeUnit;", "Lcom/newrelic/agent/deps/kotlin/time/DurationUnit;", "(Ljava/util/concurrent/TimeUnit;)V", "getUnit", "()Ljava/util/concurrent/TimeUnit;", "markNow", "Lcom/newrelic/agent/deps/kotlin/time/TimeMark;", "read", "", "DoubleTimeMark", "com.newrelic.agent.deps.kotlin-stdlib"})
@SinceKotlin(version="1.3")
@ExperimentalTime
public abstract class AbstractDoubleTimeSource
implements TimeSource {
    @NotNull
    private final TimeUnit unit;

    protected abstract double read();

    @Override
    @NotNull
    public TimeMark markNow() {
        return new DoubleTimeMark(this.read(), this, Duration.Companion.getZERO(), null);
    }

    @NotNull
    protected final TimeUnit getUnit() {
        return this.unit;
    }

    public AbstractDoubleTimeSource(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        this.unit = unit;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007H\u0096\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/newrelic/agent/deps/kotlin/time/AbstractDoubleTimeSource$DoubleTimeMark;", "Lcom/newrelic/agent/deps/kotlin/time/TimeMark;", "startedAt", "", "timeSource", "Lcom/newrelic/agent/deps/kotlin/time/AbstractDoubleTimeSource;", "offset", "Lcom/newrelic/agent/deps/kotlin/time/Duration;", "(DLkotlin/time/AbstractDoubleTimeSource;DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "D", "elapsedNow", "()D", "plus", "duration", "plus-LRDsOJo", "(D)Lkotlin/time/TimeMark;", "com.newrelic.agent.deps.kotlin-stdlib"})
    private static final class DoubleTimeMark
    extends TimeMark {
        private final double startedAt;
        private final AbstractDoubleTimeSource timeSource;
        private final double offset;

        @Override
        public double elapsedNow() {
            return Duration.minus-LRDsOJo(DurationKt.toDuration(this.timeSource.read() - this.startedAt, this.timeSource.getUnit()), this.offset);
        }

        @Override
        @NotNull
        public TimeMark plus-LRDsOJo(double duration) {
            return new DoubleTimeMark(this.startedAt, this.timeSource, Duration.plus-LRDsOJo(this.offset, duration), null);
        }

        private DoubleTimeMark(double startedAt, AbstractDoubleTimeSource timeSource, double offset) {
            this.startedAt = startedAt;
            this.timeSource = timeSource;
            this.offset = offset;
        }

        public /* synthetic */ DoubleTimeMark(double startedAt, AbstractDoubleTimeSource timeSource, double offset, DefaultConstructorMarker $constructor_marker) {
            this(startedAt, timeSource, offset);
        }
    }
}

