/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.StopProcessingException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.logging.Level;

public abstract class AbstractClassTransformer
implements StartableClassFileTransformer {
    private final int classreaderFlags;
    private final boolean enabled;

    public AbstractClassTransformer(int classreaderFlags) {
        this(classreaderFlags, true);
    }

    public AbstractClassTransformer(int classreaderFlags, boolean enabled) {
        this.enabled = enabled;
        this.classreaderFlags = classreaderFlags;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassWriter cw;
            if (!PointCutClassTransformer.isValidClassName(className)) {
                return null;
            }
            if (!this.matches(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) {
                return null;
            }
            if (!this.isAbleToResolveAgent(loader, className)) {
                String msg = MessageFormat.format("Not instrumenting {0}: class loader unable to load agent classes", className);
                Agent.LOG.log(Level.FINER, msg);
                return null;
            }
            byte[] classBytesWithUID = InstrumentationUtils.generateClassBytesWithSerialVersionUID(classfileBuffer, this.classreaderFlags, loader);
            ClassReader cr = new ClassReader(classBytesWithUID);
            ClassVisitor classVisitor = this.getClassVisitor(cr, cw = InstrumentationUtils.getClassWriter(cr, loader), className, loader);
            if (null == classVisitor) {
                return null;
            }
            cr.accept(classVisitor, this.classreaderFlags);
            String msg = MessageFormat.format("Instrumenting {0}", className);
            Agent.LOG.finer(msg);
            return cw.toByteArray();
        }
        catch (StopProcessingException e) {
            String msg = MessageFormat.format("Instrumentation aborted for {0}: {1}", className, e);
            Agent.LOG.log(Level.FINER, msg, e);
            return null;
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, t, "Instrumentation error for {0}", className);
            return null;
        }
    }

    protected boolean isAbleToResolveAgent(ClassLoader loader, String className) {
        return InstrumentationUtils.isAbleToResolveAgent(loader, className);
    }

    protected int getClassReaderFlags() {
        return this.classreaderFlags;
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        boolean canRetransform;
        boolean bl = canRetransform = isRetransformSupported && this.isRetransformSupported();
        if (this.isEnabled()) {
            instrumentation.addTransformer(this, canRetransform);
            this.start();
        }
    }

    protected void start() {
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected abstract boolean isRetransformSupported();

    protected abstract ClassVisitor getClassVisitor(ClassReader var1, ClassWriter var2, String var3, ClassLoader var4);

    protected abstract boolean matches(ClassLoader var1, String var2, Class<?> var3, ProtectionDomain var4, byte[] var5);
}

