/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.api.agent.TraceByReturnType;
import java.util.ArrayList;
import java.util.List;

public class TraceByReturnTypeMatchVisitor
implements ClassMatchVisitorFactory {
    private static final String TRACE_BY_RETURN_TYPE_DESC = Type.getDescriptor(TraceByReturnType.class);
    private static final String TRACE_RETURN_TYPES_NAME = "traceReturnTypes";

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(458752, cv){
            private boolean isScalaFutureTrace;
            private List<String> traceReturnTypeDescriptors;
            {
                super(x0, x1);
                this.isScalaFutureTrace = false;
                this.traceReturnTypeDescriptors = new ArrayList<String>();
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
                if (TRACE_BY_RETURN_TYPE_DESC.equals(descriptor)) {
                    this.isScalaFutureTrace = true;
                    av = new AnnotationVisitor(458752, av){

                        @Override
                        public AnnotationVisitor visitArray(String name) {
                            AnnotationVisitor av = super.visitArray(name);
                            if (TraceByReturnTypeMatchVisitor.TRACE_RETURN_TYPES_NAME.equals(name)) {
                                return new AnnotationVisitor(458752, av){

                                    @Override
                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        traceReturnTypeDescriptors.add(((Type)value).getDescriptor());
                                    }
                                };
                            }
                            return av;
                        }
                    };
                }
                return av;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (this.isScalaFutureTrace && this.isTracedMethod(descriptor)) {
                    Method method = new Method(name, descriptor);
                    TraceDetails traceDetails = TraceDetailsBuilder.newBuilder().setMetricName(method.getName()).setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(TraceByReturnType.class.getName()).setTransactionName(TransactionNamePriority.FRAMEWORK_LOW, false, "Custom", method.getName()).build();
                    context.addTrace(method, traceDetails);
                }
                return mv;
            }

            private boolean isTracedMethod(String descriptor) {
                boolean matchFound = false;
                for (String returnTypeDescriptor : this.traceReturnTypeDescriptors) {
                    if (!descriptor.endsWith(returnTypeDescriptor)) continue;
                    matchFound = true;
                    break;
                }
                return matchFound;
            }
        };
    }
}

