/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.Annotation;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.api.agent.Trace;
import com.newrelic.weave.UtilityClass;

class TraceMatchVisitor
implements ClassMatchVisitorFactory {
    private static final String WEAVE_UTILITY_CLASS_PACKAGE_NAME = "weavePackageName";
    private static final String WEAVE_UTILITY_CLASS_DESC = Type.getDescriptor(UtilityClass.class);
    private static final String TRACE_DESC = Type.getDescriptor(Trace.class);
    private final AnnotationMatcher traceAnnotationMatcher;
    private final AnnotationMatcher ignoreTransactionAnnotationMatcher;
    private final AnnotationMatcher ignoreApdexAnnotationMatcher;

    public TraceMatchVisitor() {
        ConfigService configService = ServiceFactory.getConfigService();
        ClassTransformerConfig classTransformerConfig = configService.getDefaultAgentConfig().getClassTransformerConfig();
        this.traceAnnotationMatcher = classTransformerConfig.getTraceAnnotationMatcher();
        this.ignoreTransactionAnnotationMatcher = classTransformerConfig.getIgnoreTransactionAnnotationMatcher();
        this.ignoreApdexAnnotationMatcher = classTransformerConfig.getIgnoreApdexAnnotationMatcher();
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(458752, cv){
            private String source;
            private boolean isWeaveUtilityClass;
            {
                super(x0, x1);
                this.isWeaveUtilityClass = false;
            }

            @Override
            public void visitSource(String source2, String debug) {
                super.visitSource(source2, debug);
                this.source = source2;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (WEAVE_UTILITY_CLASS_DESC.equals(desc)) {
                    this.isWeaveUtilityClass = true;
                    av = new AnnotationVisitor(458752, av){

                        @Override
                        public void visit(String name, Object value) {
                            if (TraceMatchVisitor.WEAVE_UTILITY_CLASS_PACKAGE_NAME.equals(name)) {
                                source = (String)value;
                            }
                            super.visit(name, value);
                        }
                    };
                }
                return av;
            }

            @Override
            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                return new MethodVisitor(458752, super.visitMethod(access, methodName, methodDesc, signature, exceptions)){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (TraceMatchVisitor.this.traceAnnotationMatcher.matches(desc) || TRACE_DESC.equals(desc) && isWeaveUtilityClass) {
                            return this.processTraceAnnotation(desc, visible);
                        }
                        if (TraceMatchVisitor.this.ignoreApdexAnnotationMatcher.matches(desc)) {
                            context.addIgnoreApdexMethod(methodName, methodDesc);
                        }
                        if (TraceMatchVisitor.this.ignoreTransactionAnnotationMatcher.matches(desc)) {
                            context.addIgnoreTransactionMethod(methodName, methodDesc);
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    private AnnotationVisitor processTraceAnnotation(String desc, boolean visible) {
                        InstrumentationType type = isWeaveUtilityClass ? InstrumentationType.TracedWeaveInstrumentation : InstrumentationType.TraceAnnotation;
                        Annotation node = new Annotation(super.visitAnnotation(desc, visible), TRACE_DESC, TraceDetailsBuilder.newBuilder().setInstrumentationType(type).setInstrumentationSourceName(source)){

                            @Override
                            public void visitEnd() {
                                context.putTraceAnnotation(new Method(methodName, methodDesc), this.getTraceDetails(!isWeaveUtilityClass));
                                super.visitEnd();
                            }
                        };
                        return node;
                    }
                };
            }
        };
    }
}

