/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class MethodLineNumberMatcher {
    public static String getMethodDescription(Class<?> currentClass, String mMethodName, int lineNumber) {
        try {
            if (currentClass != null && mMethodName != null && lineNumber > 0) {
                ClassReader cr = MethodLineNumberMatcher.getClassReader(currentClass);
                LineNumberClassVisitor cv = new LineNumberClassVisitor(mMethodName, lineNumber);
                cr.accept(cv, 4);
                return cv.getActualMethodDesc();
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, "Unable to grab method info using line numbers", e);
        }
        return null;
    }

    private static ClassReader getClassReader(Class<?> currentClass) {
        ClassReader cr;
        ClassLoader loader = currentClass.getClassLoader() == null ? AgentBridge.getAgent().getClass().getClassLoader() : currentClass.getClassLoader();
        String resource = currentClass.getName().replace('.', '/') + ".class";
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(resource);
            cr = new ClassReader(is);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to access resource: " + resource, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return cr;
    }

    public static class LineNumberClassVisitor
    extends ClassVisitor {
        private final String methodName;
        private final int lineNumber;
        private String actualMethodDesc;

        public LineNumberClassVisitor(ClassVisitor cv, String mName, int lNumber) {
            super(458752, cv);
            this.methodName = mName;
            this.lineNumber = lNumber;
            this.actualMethodDesc = null;
        }

        public LineNumberClassVisitor(String mName, int lNumber) {
            super(458752);
            this.methodName = mName;
            this.lineNumber = lNumber;
            this.actualMethodDesc = null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String pMethodName, final String methodDesc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, pMethodName, methodDesc, signature, exceptions);
            if (this.methodName.equals(pMethodName)) {
                mv = new MethodVisitor(458752, mv){

                    @Override
                    public void visitLineNumber(int line, Label start) {
                        super.visitLineNumber(line, start);
                        if (lineNumber == line) {
                            actualMethodDesc = methodDesc;
                        }
                    }
                };
            }
            return mv;
        }

        public boolean foundMethod() {
            return this.actualMethodDesc != null;
        }

        public String getActualMethodDesc() {
            return this.actualMethodDesc;
        }
    }
}

