/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.Agent;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class AbstractMetricAggregator
implements MetricAggregator {
    private final Logger logger;

    protected AbstractMetricAggregator() {
        this(Agent.LOG);
    }

    protected AbstractMetricAggregator(Logger logger) {
        this.logger = logger;
    }

    public final void recordResponseTimeMetric(String name, long totalTime, long exclusiveTime, TimeUnit timeUnit) {
        if (name == null || name.length() == 0) {
            this.logger.log(Level.FINER, "recordResponseTimeMetric was invoked with a null or empty name");
            return;
        }
        try {
            this.doRecordResponseTimeMetric(name, totalTime, exclusiveTime, timeUnit);
            this.logger.log(Level.FINER, "Recorded response time metric \"{0}\": {1}", (Object)name, (Object)totalTime);
        }
        catch (Throwable t) {
            AbstractMetricAggregator.logException(this.logger, t, "Exception recording response time metric \"{0}\": {1}", name, t);
        }
    }

    protected abstract void doRecordResponseTimeMetric(String var1, long var2, long var4, TimeUnit var6);

    public final void recordMetric(String name, float value) {
        if (name == null || name.length() == 0) {
            this.logger.log(Level.FINER, "recordMetric was invoked with a null or empty name");
            return;
        }
        try {
            this.doRecordMetric(name, value);
            if (Agent.isDebugEnabled()) {
                this.logger.log(Level.FINER, "Recorded metric \"{0}\": {1}", (Object)name, (Object)Float.valueOf(value));
            }
        }
        catch (Throwable t) {
            AbstractMetricAggregator.logException(this.logger, t, "Exception recording metric \"{0}\": {1}", name, t);
        }
    }

    protected abstract void doRecordMetric(String var1, float var2);

    public final void recordResponseTimeMetric(String name, long millis) {
        this.recordResponseTimeMetric(name, millis, millis, TimeUnit.MILLISECONDS);
    }

    public final void incrementCounter(String name) {
        this.incrementCounter(name, 1);
    }

    public final void incrementCounter(String name, int count) {
        if (name == null || name.length() == 0) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "incrementCounter was invoked with a null metric name");
            }
            return;
        }
        try {
            this.doIncrementCounter(name, count);
            if (Agent.isDebugEnabled()) {
                this.logger.log(Level.FINER, "incremented counter \"{0}\": {1}", (Object)name, (Object)count);
            }
        }
        catch (Throwable t) {
            AbstractMetricAggregator.logException(this.logger, t, "Exception incrementing counter \"{0}\",{1} : {2}", name, count, t);
        }
    }

    protected abstract void doIncrementCounter(String var1, int var2);

    private static void logException(Logger logger, Throwable t, String pattern, Object part1, Object part2) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, t, pattern, part1, part2);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, pattern, part1, part2);
        }
    }

    private static void logException(Logger logger, Throwable t, String pattern, Object part1, Object part2, Object part3) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, t, pattern, part1, part2, part3);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, pattern, part1, part2, part3);
        }
    }
}

