/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.datastore.ConnectionFactory;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.bridge.datastore.DatastoreInstanceDetection;
import com.newrelic.agent.bridge.datastore.DatastoreVendor;
import com.newrelic.agent.bridge.datastore.JdbcHelper;
import com.newrelic.agent.bridge.datastore.RecordSql;
import com.newrelic.agent.bridge.datastore.UnknownDatabaseVendor;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.DatastoreMetrics;
import com.newrelic.agent.database.DefaultExplainPlanExecutor;
import com.newrelic.agent.database.ExplainPlanExecutor;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.PreparedStatementExplainPlanExecutor;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import com.newrelic.agent.deps.org.json.simple.JSONAware;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.SqlTracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.QueryConverter;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DefaultSqlTracer
extends DefaultTracer
implements SqlTracer,
Comparable<DefaultSqlTracer> {
    private static final String PARAMETER_REGEX = "\\?";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\?");
    private ConnectionFactory connectionFactory = null;
    private String sql = null;
    private Object[] params = null;
    private Object sqlObject = null;
    private long rpmConnectTimestamp = 0L;
    private ParsedDatabaseStatement parsedDatabaseStatement = null;
    private ExplainPlanExecutor explainPlanExecutor = null;
    private String host = null;
    private Integer port = null;
    private String identifier = null;
    private String databaseName = null;

    public DefaultSqlTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        super(transaction, sig, object, metricNameFormatter, tracerFlags);
    }

    public DefaultSqlTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags, long time) {
        super(transaction.getTransactionActivity(), sig, object, metricNameFormatter, tracerFlags, time);
    }

    public DefaultSqlTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        super(txa, sig, object, metricNameFormatter, tracerFlags);
    }

    public DefaultSqlTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags, long pStartTime) {
        super(txa, sig, object, metricNameFormatter, tracerFlags, pStartTime);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setHost(String host) {
        this.host = host;
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Setting host to {0} {1}", (Object)this.host, (Object)this);
    }

    public void setPort(int port) {
        this.port = port;
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Setting port to {0} {1}", (Object)this.port, (Object)this);
    }

    @Override
    public String getRawSql() {
        return this.sql;
    }

    @Override
    public void provideConnection(Connection conn) {
        try {
            if (conn == null) {
                return;
            }
            this.setConnectionFactory(JdbcHelper.getConnectionFactory((Connection)conn));
            this.setDatabaseName(JdbcHelper.getDatabaseName((Connection)conn));
            InetSocketAddress address = DatastoreInstanceDetection.getAddressForConnection((Object)conn);
            if (address != null) {
                this.setHost(address.getHostName());
                this.setPort(address.getPort());
                return;
            }
            String cachedIdentifier = JdbcHelper.getCachedIdentifierForConnection((Connection)conn);
            String identifier = cachedIdentifier != null ? cachedIdentifier : JdbcHelper.parseAndCacheInMemoryIdentifier((Connection)conn);
            if (identifier != null && !identifier.equals("unknown")) {
                this.setHost("localhost");
            }
            this.setIdentifier(identifier);
        }
        catch (Throwable t) {
            AgentBridge.getAgent().getLogger().log(Level.FINEST, t, "Unable to provide connection: {0} to {1}", (Object)conn, (Object)this);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setRawSql(String sql) {
        this.sql = sql;
    }

    @Override
    public Object[] getParams() {
        return this.params;
    }

    @Override
    public void setParams(Object[] params) {
        if (params != null && params.length > 0) {
            this.params = params;
        }
    }

    protected DatabaseVendor getDatabaseVendor() {
        if (this.connectionFactory == null) {
            if (this.parsedDatabaseStatement != null) {
                return this.parsedDatabaseStatement.getDbVendor();
            }
            return UnknownDatabaseVendor.INSTANCE;
        }
        return this.connectionFactory.getDatabaseVendor();
    }

    @Override
    protected void doFinish(Throwable throwable) {
        Transaction transaction;
        super.doFinish(throwable);
        Object sql = this.getSql();
        if (sql != null && (transaction = this.getTransaction()) != null) {
            if (this.getRecordSql().equals((Object)RecordSql.raw)) {
                this.getTransaction().getIntrinsicAttributes().put("sql", sql.toString());
            } else if (this.getRecordSql().equals((Object)RecordSql.obfuscated)) {
                String appName = this.getTransaction().getApplicationName();
                SqlQueryConverter converter = new SqlQueryConverter(appName, this.getDatabaseVendor());
                String obfuscatedQueryString = converter.toObfuscatedQueryString(sql.toString());
                this.getTransaction().getIntrinsicAttributes().put("sql", obfuscatedQueryString);
            }
        }
    }

    @Override
    protected void doFinish(int opcode, Object returnValue) {
        super.doFinish(opcode, returnValue);
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            TransactionTracerConfig transactionTracerConfig = transaction.getTransactionTracerConfig();
            double explainThresholdInNanos = transactionTracerConfig.getExplainThresholdInNanos();
            if ("raw" == transactionTracerConfig.getRecordSql() || (double)this.getDuration() > explainThresholdInNanos) {
                Object[] sqlParameters;
                Object[] objectArray = sqlParameters = this.params == null ? null : new Object[this.params.length];
                if (sqlParameters != null) {
                    System.arraycopy(this.params, 0, sqlParameters, 0, this.params.length);
                    this.params = sqlParameters;
                }
            }
            if (this.isTransactionSegment() && this.captureSql()) {
                this.sqlObject = this.getSql();
            }
            this.parseStatement(returnValue, transaction.getRPMService().getConnectionTimestamp());
            if (this.isTransactionSegment() && this.sql != null) {
                if (transactionTracerConfig.isExplainEnabled()) {
                    this.captureExplain(this.parsedDatabaseStatement, explainThresholdInNanos, transactionTracerConfig);
                } else if (Agent.isDebugEnabled()) {
                    String msg = MessageFormat.format("Statement exceeded threshold?: {0}", (double)this.getDuration() > explainThresholdInNanos);
                    Agent.LOG.finer(msg);
                }
            }
        }
    }

    @Override
    protected boolean shouldStoreStackTrace() {
        return super.shouldStoreStackTrace() && this.sql != null;
    }

    @Override
    public boolean isMetricProducer() {
        return this.parsedDatabaseStatement != null && this.parsedDatabaseStatement.recordMetric();
    }

    @Override
    protected void recordMetrics(TransactionStats transactionStats) {
        if (this.isMetricProducer() && this.getTransaction() != null) {
            String rawSql = null;
            Object sqlObject = this.getSql();
            if (sqlObject != null) {
                rawSql = new PreparedStatementSql(this.sql, this.params).toString();
            }
            String appName = this.getTransaction().getApplicationName();
            String hostToReport = DatastoreMetrics.replaceLocalhost(this.getHost());
            if (this.getIdentifier() != null) {
                this.reportAsExternal((ExternalParameters)DatastoreParameters.product((String)this.getDatabaseVendor().getDatastoreVendor().name()).collection(this.parsedDatabaseStatement.getModel()).operation(this.parsedDatabaseStatement.getOperation()).instance(hostToReport, this.getIdentifier()).databaseName(this.getDatabaseName()).slowQuery((Object)rawSql, (QueryConverter)new SqlQueryConverter(appName, this.getDatabaseVendor())).build());
            } else {
                String portToReport = DatastoreMetrics.replacePort(this.getPort());
                this.reportAsExternal((ExternalParameters)DatastoreParameters.product((String)this.getDatabaseVendor().getDatastoreVendor().name()).collection(this.parsedDatabaseStatement.getModel()).operation(this.parsedDatabaseStatement.getOperation()).instance(hostToReport, portToReport).databaseName(this.getDatabaseName()).slowQuery((Object)rawSql, (QueryConverter)new SqlQueryConverter(appName, this.getDatabaseVendor())).build());
            }
            if (this.parsedDatabaseStatement == DatabaseStatementParser.UNPARSEABLE_STATEMENT) {
                DatastoreMetrics.unparsedQuerySupportability(this.getDatabaseVendor().getDatastoreVendor().name());
            }
        }
        super.recordMetrics(transactionStats);
    }

    @Override
    public Object getSql() {
        if (this.sqlObject != null) {
            return this.sqlObject;
        }
        if (RecordSql.raw.equals((Object)this.getRecordSql())) {
            if (this.params != null) {
                return new PreparedStatementSql(this.sql, this.params);
            }
            return this.sql;
        }
        return this.sql;
    }

    @Override
    public boolean hasExplainPlan() {
        return this.getAgentAttribute("explanation") != null;
    }

    @Override
    public ExplainPlanExecutor getExplainPlanExecutor() {
        return this.explainPlanExecutor;
    }

    protected ExplainPlanExecutor createExplainPlanExecutor(String sql) {
        if (this.params != null && this.params.length > 0) {
            return new PreparedStatementExplainPlanExecutor(this, this.getRawSql(), this.getParams(), this.getRecordSql());
        }
        return new DefaultExplainPlanExecutor(this, sql, this.getRecordSql());
    }

    private RecordSql getRecordSql() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return RecordSql.off;
        }
        return RecordSql.get((String)tx.getTransactionTracerConfig().getRecordSql());
    }

    private boolean captureSql() {
        Transaction tx = this.getTransaction();
        return tx != null && "off" != tx.getTransactionTracerConfig().getRecordSql();
    }

    private void parseStatement(Object returnValue, long configTimestamp) {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return;
        }
        if (this.parsedDatabaseStatement == null) {
            ResultSetMetaData metaData;
            block7: {
                metaData = null;
                try {
                    if (returnValue instanceof ResultSet) {
                        metaData = ((ResultSet)returnValue).getMetaData();
                    }
                }
                catch (Exception e) {
                    if (!Agent.isDebugEnabled()) break block7;
                    Agent.LOG.log(Level.FINER, "Unable to get the result set meta data from a statement", e);
                }
            }
            this.rpmConnectTimestamp = System.nanoTime();
            this.parsedDatabaseStatement = tx.getDatabaseStatementParser().getParsedDatabaseStatement(this.getDatabaseVendor(), this.getRawSql(), metaData);
        } else if (configTimestamp > this.rpmConnectTimestamp) {
            this.parsedDatabaseStatement = null;
            this.rpmConnectTimestamp = 0L;
            this.parseStatement(returnValue, configTimestamp);
        }
    }

    private void captureExplain(ParsedDatabaseStatement parsedStatement, double explainThresholdInNanos, TransactionTracerConfig transactionTracerConfig) {
        Transaction tx = this.getTransaction();
        if (tx != null && (double)this.getDuration() > explainThresholdInNanos && "select".equals(parsedStatement.getOperation())) {
            if (tx.getTransactionCounts().getExplainPlanCount() >= transactionTracerConfig.getMaxExplainPlans()) {
                return;
            }
            if (StringUtils.isEmpty(this.sql)) {
                this.setExplainPlan("Unable to run the explain plan because we have no sql");
                return;
            }
            try {
                if (!this.getDatabaseVendor().isExplainPlanSupported()) {
                    this.setExplainPlan("Unable to run explain plans for " + this.getDatabaseVendor().getName() + " databases");
                    return;
                }
                if (this.connectionFactory != null) {
                    this.explainPlanExecutor = this.createExplainPlanExecutor(this.sql);
                    if (this.explainPlanExecutor != null) {
                        if (Agent.LOG.isLoggable(Level.FINEST)) {
                            Agent.LOG.finest("Capturing information for explain plan");
                        }
                        tx.getTransactionCounts().incrementExplainPlanCountAndLogIfReachedMax(transactionTracerConfig.getMaxExplainPlans());
                    }
                } else {
                    this.setExplainPlan("Unable to create a connection to run the explain plan");
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format("An error occurred running the explain plan: {0}", e);
                this.setExplainPlan(msg);
                Agent.LOG.finer(msg);
            }
        }
    }

    @Override
    public void setExplainPlan(Object ... explainPlan) {
        this.setAgentAttribute("explanation", Arrays.asList(explainPlan));
        if (this.getDatabaseVendor().getDatastoreVendor() != DatastoreVendor.JDBC) {
            this.setAgentAttribute("database_vendor", this.getDatabaseVendor().getType());
            this.setAgentAttribute("explanation_format", this.getDatabaseVendor().getExplainPlanFormat());
        }
    }

    @Override
    public int compareTo(DefaultSqlTracer otherTracer) {
        long durationDifference = this.getDuration() - otherTracer.getDuration();
        if (durationDifference < 0L) {
            return -1;
        }
        if (durationDifference > 0L) {
            return 1;
        }
        return 0;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Setting identifier to {0} {1}", (Object)this.identifier, (Object)this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Setting database name to {0} {1}", (Object)this.databaseName, (Object)this);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static String parameterizeSql(String sql, Object[] parameters) throws Exception {
        if (sql == null || parameters == null || parameters.length == 0) {
            return sql;
        }
        String[] pieces = PARAMETER_PATTERN.split(sql);
        StringBuilder sb = new StringBuilder(sql.length() * 2);
        int i = 0;
        int j = 1;
        while (i < pieces.length) {
            String piece = pieces[i];
            if (j == pieces.length && sql.endsWith(piece)) {
                sb.append(piece);
            } else {
                Object val;
                Object object = val = i < parameters.length ? parameters[i] : null;
                if (val instanceof Number) {
                    sb.append(piece).append(val.toString());
                } else if (val == null) {
                    sb.append(piece).append("?");
                } else {
                    sb.append(piece).append("'").append(val.toString()).append("'");
                }
            }
            ++i;
            ++j;
        }
        return sb.toString();
    }

    private static class SqlQueryConverter
    implements QueryConverter<String> {
        private final String appName;
        private final DatabaseVendor databaseVendor;

        public SqlQueryConverter(String appName, DatabaseVendor databaseVendor) {
            this.appName = appName;
            this.databaseVendor = databaseVendor;
        }

        public String toRawQueryString(String rawQuery) {
            return rawQuery;
        }

        public String toObfuscatedQueryString(String rawQuery) {
            SqlObfuscator sqlObfuscator = ServiceFactory.getDatabaseService().getSqlObfuscator(this.appName);
            String dialect = this.databaseVendor.getType();
            return sqlObfuscator.obfuscateSql(rawQuery, dialect);
        }
    }

    private static class PreparedStatementSql
    implements JSONAware {
        private final String sql;
        private final Object[] sqlParameters;

        public PreparedStatementSql(String sql, Object[] sqlParameters) {
            this.sql = sql;
            this.sqlParameters = sqlParameters;
        }

        @Override
        public String toJSONString() {
            try {
                return DefaultSqlTracer.parameterizeSql(this.sql, this.sqlParameters);
            }
            catch (Exception ignored) {
                return this.sql;
            }
        }

        public String toString() {
            return this.toJSONString();
        }
    }
}

