/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.org.apache.commons.codec.binary.Base64;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.Sampled;
import com.newrelic.api.agent.MetricAggregator;
import java.util.logging.Level;

public class DistributedTracePayloadParser {
    private static final Base64 base64 = new Base64();
    private final MetricAggregator metricAggregator;
    private final DistributedTraceService distributedTraceService;
    private final IAgentLogger logger;

    public DistributedTracePayloadParser(MetricAggregator metricAggregator, DistributedTraceService distributedTraceService, IAgentLogger logger) {
        this.metricAggregator = metricAggregator;
        this.distributedTraceService = distributedTraceService;
        this.logger = logger;
    }

    public DistributedTracePayloadImpl parse(DistributedTracePayloadImpl outboundPayloadData, String payload) {
        char firstChar;
        if (payload == null) {
            this.logger.log(Level.FINER, "Incoming distributed trace payload is null.");
            this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/Ignored/Null");
            return null;
        }
        if (outboundPayloadData != null) {
            this.logger.log(Level.WARNING, "Error: createDistributedTracePayload was called before acceptDistributedTracePayload. Ignoring Call");
            this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept");
            return null;
        }
        if (!payload.trim().isEmpty() && (firstChar = (payload = payload.trim()).charAt(0)) != '{') {
            payload = new String(base64.decode(payload), Charsets.UTF_8);
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject object = (JSONObject)parser.parse(payload);
            JSONArray version = (JSONArray)object.get("v");
            Long majorVersion = (Long)version.get(0);
            int majorSupportedVersion = this.distributedTraceService.getMajorSupportedCatVersion();
            if (majorVersion > (long)majorSupportedVersion) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload major version: {0} is newer than supported agent version: {1}. Ignoring payload.", majorVersion, majorSupportedVersion);
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/Ignored/MajorVersion");
                return null;
            }
            JSONObject data = (JSONObject)object.get("d");
            String payloadAccountId = (String)data.get("ac");
            String payloadTrustKey = (String)data.get("tk");
            String trustKey = this.distributedTraceService.getTrustKey();
            if (trustKey == null) {
                this.logger.log(Level.FINER, "The agent has not connected yet. Unable to accept incoming distributed trace payload.");
                return null;
            }
            if (payloadAccountId == null) {
                this.logger.log(Level.FINER, "Invalid payload {0}. Payload missing accountId.", data);
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String applicationId = (String)data.get("ap");
            if (applicationId == null) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload is missing application id");
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            boolean isTrustedAccountKey = trustKey.equals(payloadTrustKey == null ? payloadAccountId : payloadTrustKey);
            if (!isTrustedAccountKey) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload trustKey: {0} does not match trusted account key: {1}. Ignoring payload.", payloadTrustKey, trustKey);
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/Ignored/UntrustedAccount");
                return null;
            }
            long timestamp = (Long)data.get("ti");
            if (timestamp <= 0L) {
                this.logger.log(Level.FINER, "Invalid payload {0}. Payload missing keys.", data);
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String parentType = (String)data.get("ty");
            if (parentType == null) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload is missing type");
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String traceId = (String)data.get("tr");
            if (traceId == null) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload is missing traceId");
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String guid = (String)data.get("id");
            String txnId = (String)data.get("tx");
            if (guid == null && txnId == null) {
                this.logger.log(Level.FINER, "Incoming distributed trace payload is missing traceId");
                this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            Number priorityNumber = (Number)data.get("pr");
            Float priority = priorityNumber != null ? Float.valueOf(priorityNumber.floatValue()) : null;
            Sampled sampled = Sampled.parse(data.get("sa"));
            DistributedTracePayloadImpl distributedTracePayload = new DistributedTracePayloadImpl(timestamp, parentType, payloadAccountId, payloadTrustKey, applicationId, guid, traceId, txnId, priority, sampled);
            if (this.logger.isFinestEnabled()) {
                this.logger.log(Level.FINEST, "Parsed distributed trace payload: {0}", distributedTracePayload);
            }
            return distributedTracePayload;
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, e, "Failed to parse distributed trace payload");
            this.metricAggregator.incrementCounter("Supportability/DistributedTrace/AcceptPayload/ParseException");
            return null;
        }
    }
}

