/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.relocated.internal.bind;

import com.newrelic.relocated.Gson;
import com.newrelic.relocated.JsonSyntaxException;
import com.newrelic.relocated.TypeAdapter;
import com.newrelic.relocated.TypeAdapterFactory;
import com.newrelic.relocated.reflect.TypeToken;
import com.newrelic.relocated.stream.JsonReader;
import com.newrelic.relocated.stream.JsonToken;
import com.newrelic.relocated.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

