/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.events;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import com.newrelic.telemetry.events.EventBatch;
import com.newrelic.telemetry.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class EventBuffer {
    private static final Logger logger = LoggerFactory.getLogger(EventBuffer.class);
    private final Queue<Event> events = new ConcurrentLinkedQueue<Event>();
    private final Attributes commonAttributes;

    public EventBuffer(Attributes commonAttributes) {
        this.commonAttributes = Utils.verifyNonNull(commonAttributes);
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public int size() {
        return this.events.size();
    }

    public EventBatch createBatch() {
        Event event;
        logger.debug("Creating Event batch.");
        ArrayList<Event> eventsForBatch = new ArrayList<Event>(this.events.size());
        while ((event = this.events.poll()) != null) {
            eventsForBatch.add(event);
        }
        return new EventBatch((Collection<Event>)eventsForBatch, this.commonAttributes);
    }

    Queue<Event> getEvents() {
        return this.events;
    }

    Attributes getCommonAttributes() {
        return this.commonAttributes;
    }

    public String toString() {
        return "EventBuffer{events=" + this.events + ", commonAttributes=" + this.commonAttributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBuffer that = (EventBuffer)o;
        if (this.getEvents() != null ? !this.getEvents().equals(that.getEvents()) : that.getEvents() != null) {
            return false;
        }
        return this.getCommonAttributes() != null ? this.getCommonAttributes().equals(that.getCommonAttributes()) : that.getCommonAttributes() == null;
    }

    public int hashCode() {
        int result = this.getEvents() != null ? this.getEvents().hashCode() : 0;
        result = 31 * result + (this.getCommonAttributes() != null ? this.getCommonAttributes().hashCode() : 0);
        return result;
    }
}

