/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.TelemetryBatch;
import com.newrelic.telemetry.spans.Span;
import java.util.Collection;
import java.util.Optional;

public class SpanBatch
extends TelemetryBatch<Span> {
    private final String traceId;

    public SpanBatch(Collection<Span> telemetry, Attributes commonAttributes) {
        this(telemetry, commonAttributes, null);
    }

    @Override
    public TelemetryBatch<Span> createSubBatch(Collection<Span> telemetry) {
        return new SpanBatch(telemetry, this.getCommonAttributes(), this.traceId);
    }

    public SpanBatch(Collection<Span> telemetry, Attributes commonAttributes, String traceId) {
        super(telemetry, commonAttributes);
        this.traceId = traceId;
    }

    public Optional<String> getTraceId() {
        return Optional.ofNullable(this.traceId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpanBatch spanBatch = (SpanBatch)o;
        return this.getTraceId() != null ? this.getTraceId().equals(spanBatch.getTraceId()) : spanBatch.getTraceId() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getTraceId() != null ? this.getTraceId().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SpanBatch{traceId='" + this.traceId + '\'' + "} " + super.toString();
    }
}

