/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.SpanBatchSenderFactory;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.json.SpanBatchMarshaller;
import com.newrelic.telemetry.spans.json.SpanJsonCommonBlockWriter;
import com.newrelic.telemetry.spans.json.SpanJsonTelemetryBlockWriter;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.URL;
import java.util.function.Supplier;

public class SpanBatchSender {
    private static final String SPANS_PATH = "/trace/v1";
    private static final String DEFAULT_URL = "https://trace-api.newrelic.com/";
    private static final Logger logger = LoggerFactory.getLogger(SpanBatchSender.class);
    private final SpanBatchMarshaller marshaller;
    private final BatchDataSender sender;

    SpanBatchSender(SpanBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    public Response sendBatch(SpanBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending a null or empty span batch");
            return new Response(202, "Ignored", "Empty batch");
        }
        logger.debug("Sending a span batch (number of spans: {}) to the New Relic span ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch);
    }

    public static SpanBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return SpanBatchSender.create(SpanBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static SpanBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        URL url = configuration.getEndpointUrl();
        SpanBatchMarshaller marshaller = new SpanBatchMarshaller(new SpanJsonCommonBlockWriter(new AttributesJson()), new SpanJsonTelemetryBlockWriter(new AttributesJson()));
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent(), configuration.useLicenseKey());
        return new SpanBatchSender(marshaller, sender);
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, SPANS_PATH);
    }
}

