/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.HashMap;
import java.util.Map;

public final class ReferenceUtils {
    private ReferenceUtils() {
    }

    public static ClassVisitor getRenamingVisitor(Map<String, String> oldToNew, ClassVisitor delegate) {
        return new ClassRenamingVisitor(oldToNew, delegate);
    }

    public static ClassVisitor getFieldRenamingVisitor(ClassVisitor delegate, String className, String oldFieldName, String newFieldName) {
        return new FieldRenamingVisitor(delegate, className, oldFieldName, newFieldName);
    }

    public static ClassVisitor getMethodRenamingVisitor(ClassVisitor delegate, String className, String oldMethodName, String oldMethodDesc, String newMethodName) {
        return new MethodRenamingVisitor(delegate, className, oldMethodName, oldMethodDesc, newMethodName);
    }

    private static class MethodRenamingVisitor
    extends ClassVisitor {
        private final String className;
        private final String oldMethodName;
        private final String oldMethodDesc;
        private final String newMethodName;
        private String visitingClassName;

        private MethodRenamingVisitor(ClassVisitor delegatee, String className, String oldMethodName, String oldMethodDesc, String newMethodName) {
            super(458752, delegatee);
            this.className = className;
            this.oldMethodName = oldMethodName;
            this.oldMethodDesc = oldMethodDesc;
            this.newMethodName = newMethodName;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitingClassName = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.className.equals(this.visitingClassName) && this.oldMethodName.equals(name) && this.oldMethodDesc.equals(desc)) {
                name = this.newMethodName;
            }
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ((0x400 & access) == 0) {
                mv = new MethodVisitor(458752, mv){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (className.equals(owner) && oldMethodName.equals(name) && oldMethodDesc.equals(desc)) {
                            name = newMethodName;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        if (className.equals(owner) && oldMethodName.equals(name) && oldMethodDesc.equals(desc)) {
                            name = newMethodName;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }
                };
            }
            return mv;
        }
    }

    private static class FieldRenamingVisitor
    extends ClassVisitor {
        private final String className;
        private final String oldFieldName;
        private final String newFieldName;
        private String visitingClassName;

        private FieldRenamingVisitor(ClassVisitor delegatee, String className, String oldFieldName, String newFieldName) {
            super(458752, delegatee);
            this.className = className;
            this.oldFieldName = oldFieldName;
            this.newFieldName = newFieldName;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitingClassName = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        private String updateFieldName(String fieldName) {
            if (this.oldFieldName.equals(fieldName)) {
                return this.newFieldName;
            }
            return fieldName;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.className.equals(this.visitingClassName)) {
                name = this.updateFieldName(name);
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ((0x400 & access) == 0) {
                mv = new MethodVisitor(458752, mv){

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (className.equals(owner)) {
                            name = this.updateFieldName(name);
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }
                };
            }
            return mv;
        }
    }

    private static class ClassRenamingVisitor
    extends ClassVisitor {
        final Map<String, String> oldToNewInternalNames;
        final Map<String, String> oldToNewDescs;

        private ClassRenamingVisitor(Map<String, String> oldToNew, ClassVisitor delegatee) {
            super(458752, delegatee);
            if (null == oldToNew) {
                oldToNew = new HashMap<String, String>(0);
            }
            HashMap<String, String> internalNameMap = new HashMap<String, String>(oldToNew.size());
            HashMap<String, String> descMap = new HashMap<String, String>(oldToNew.size());
            for (String key : oldToNew.keySet()) {
                String internalNameKey = WeaveUtils.getClassInternalName(key);
                String internalNameValue = WeaveUtils.getClassInternalName(oldToNew.get(key));
                internalNameMap.put(internalNameKey, internalNameValue);
                String descKey = "L" + internalNameKey + ";";
                String descValue = "L" + internalNameValue + ";";
                descMap.put(descKey, descValue);
            }
            this.oldToNewInternalNames = ImmutableMap.builder().putAll(internalNameMap).build();
            this.oldToNewDescs = ImmutableMap.builder().putAll(descMap).build();
        }

        private String updateName(String oldName) {
            String newName = this.oldToNewInternalNames.get(oldName);
            return null == newName ? oldName : newName;
        }

        private String updateDesc(String desc) {
            if (null == desc) {
                return null;
            }
            for (Map.Entry<String, String> entry : this.oldToNewDescs.entrySet()) {
                desc = desc.replace(entry.getKey(), entry.getValue());
            }
            return desc;
        }

        private String updateSignature(String signature) {
            if (null == signature) {
                return null;
            }
            for (Map.Entry<String, String> entry : this.oldToNewInternalNames.entrySet()) {
                signature = signature.replace(entry.getKey(), entry.getValue());
            }
            return signature;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            name = this.updateName(name);
            superName = this.updateName(superName);
            if (interfaces != null) {
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = this.updateName(interfaces[i]);
                }
            }
            signature = this.updateSignature(signature);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            desc = this.updateDesc(desc);
            signature = this.updateSignature(signature);
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            desc = this.updateDesc(desc);
            signature = this.updateSignature(signature);
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ((0x400 & access) == 0) {
                mv = new MethodVisitor(458752, mv){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        desc = this.updateDesc(desc);
                        owner = this.updateName(owner);
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        desc = this.updateDesc(desc);
                        owner = this.updateName(owner);
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        desc = this.updateDesc(desc);
                        owner = this.updateName(owner);
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        desc = this.updateDesc(desc);
                        signature = this.updateSignature(signature);
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }

                    @Override
                    public void visitMultiANewArrayInsn(String desc, int dims) {
                        desc = this.updateDesc(desc);
                        super.visitMultiANewArrayInsn(desc, dims);
                    }

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        type = type.startsWith("[") ? this.updateDesc(type) : this.updateName(type);
                        super.visitTypeInsn(opcode, type);
                    }

                    @Override
                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof Type) {
                            String newInternalClassName = this.updateName(((Type)cst).getInternalName());
                            super.visitLdcInsn(Type.getType("L" + newInternalClassName + ";"));
                            return;
                        }
                        super.visitLdcInsn(cst);
                    }
                };
            }
            return mv;
        }
    }
}

