/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ReferenceUtils;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.WeaveClassInfo;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.Reference;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import com.newrelic.weave.weavepackage.language.LanguageAdapter;
import com.newrelic.weave.weavepackage.language.LanguageAdapterResult;
import com.newrelic.weave.weavepackage.language.RegisteredLanguageAdapters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class WeavePackage {
    private final Map<String, ClassNode> exactWeaves = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, ClassNode> baseWeaves = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, ClassNode> utilClasses = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, MatchType> weaveMatches = new ConcurrentHashMap<String, MatchType>();
    private final Map<String, ClassNode> allClassAnnotationWeaves = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, ClassNode> allMethodAnnotationWeaves = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, ClassNode> baseAnnotationWeaves = new ConcurrentHashMap<String, ClassNode>();
    private final Map<String, Set<String>> requiredClassAnnotationsLookup = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> requiredMethodAnnotationsLookup = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Reference> references = new ConcurrentHashMap<String, Reference>();
    private final Set<String> skipIfPresentClasses = Sets.newConcurrentHashSet();
    private final Set<String> methodSignatures = Sets.newConcurrentHashSet();
    private final Queue<WeaveViolation> packageViolations = Queues.newConcurrentLinkedQueue();
    private final Map<String, String> renames = new ConcurrentHashMap<String, String>();
    private final WeavePackageConfig config;
    private volatile boolean weavesBootstrap = false;
    private ClassNode errorHandler;
    private ClassNode extensionTemplate;

    public static WeavePackage createWeavePackage(JarInputStream jarStream, WeavePackageConfig config) throws Exception {
        ArrayList<byte[]> classBytes = new ArrayList<byte[]>();
        JarEntry entry = null;
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (!entry.getName().endsWith(".class")) continue;
            classBytes.add(Streams.read(jarStream, false));
        }
        return new WeavePackage(config, classBytes);
    }

    public WeavePackage(WeavePackageConfig config, List<byte[]> weavePackageBytes) {
        this.config = config;
        this.processWeaveBytes(weavePackageBytes);
    }

    protected final List<WeaveViolation> processWeaveBytes(List<byte[]> weavePackageBytes) {
        ArrayList<WeaveViolation> violations = new ArrayList<WeaveViolation>();
        for (LanguageAdapter adapter : RegisteredLanguageAdapters.getLanguageAdapters()) {
            try {
                LanguageAdapterResult result = adapter.adapt(weavePackageBytes);
                weavePackageBytes = result.getAdaptedBytes();
                violations.addAll(result.getViolations());
            }
            catch (Throwable result) {}
        }
        block6: for (byte[] weaveClassBytes : weavePackageBytes) {
            boolean isMethodAnnotationMatch;
            ClassNode weaveNode = WeaveUtils.convertToClassNode(weaveClassBytes);
            WeaveClassInfo weave = new WeaveClassInfo(weaveNode);
            violations.addAll(weave.getViolations());
            boolean isClassAnnotationMatch = !weave.getRequiredClassAnnotations().isEmpty();
            boolean bl = isMethodAnnotationMatch = !weave.getRequiredMethodAnnotations().isEmpty();
            if (isClassAnnotationMatch || isMethodAnnotationMatch) {
                if (isClassAnnotationMatch) {
                    for (String requiredAnnotation : weave.getRequiredClassAnnotations()) {
                        if (weave.getMatchType().equals((Object)MatchType.Interface)) {
                            this.baseAnnotationWeaves.put(requiredAnnotation, weaveNode);
                        }
                        this.allClassAnnotationWeaves.put(requiredAnnotation, weaveNode);
                    }
                    this.requiredClassAnnotationsLookup.put(weaveNode.name, weave.getRequiredClassAnnotations());
                }
                if (!isMethodAnnotationMatch) continue;
                for (String requiredAnnotation : weave.getRequiredMethodAnnotations()) {
                    if (!isClassAnnotationMatch) {
                        this.allMethodAnnotationWeaves.put(requiredAnnotation, weaveNode);
                        continue;
                    }
                    if (this.allMethodAnnotationWeaves.containsKey(requiredAnnotation)) continue;
                    this.allMethodAnnotationWeaves.put(requiredAnnotation, weaveNode);
                }
                this.requiredMethodAnnotationsLookup.put(weaveNode.name, weave.getRequiredMethodAnnotations());
                continue;
            }
            if (null == weave.getMatchType()) {
                if (weave.isSkipIfPresent()) {
                    this.skipIfPresentClasses.add(weave.getOriginalName());
                    continue;
                }
                this.utilClasses.put(weaveNode.name, weaveNode);
                continue;
            }
            if (!weaveNode.name.equals(weave.getOriginalName())) {
                this.renames.put(weaveNode.name, weave.getOriginalName());
            }
            this.weaveMatches.put(weave.getOriginalName(), weave.getMatchType());
            switch (weave.getMatchType()) {
                case BaseClass: 
                case Interface: {
                    this.baseWeaves.put(weave.getOriginalName(), weaveNode);
                    continue block6;
                }
            }
            this.exactWeaves.put(weave.getOriginalName(), weaveNode);
        }
        this.preprocessAllWeaveCode();
        this.packageViolations.addAll(violations);
        if (this.isBootstrapClassName(this.exactWeaves.keySet()) || this.isBootstrapClassName(this.baseWeaves.keySet())) {
            this.weavesBootstrap = true;
        }
        return violations;
    }

    public boolean isBootstrapClassName(Collection<String> names) {
        for (String name : names) {
            if (!BootstrapLoader.get().isBootstrapClass(name)) continue;
            return true;
        }
        return false;
    }

    private void preprocessAllWeaveCode() {
        ClassNode node;
        HashSet<String> renamedUtilityClassesToRemove = new HashSet<String>();
        for (ClassNode classNode : this.utilClasses.values()) {
            String nameBefore = classNode.name;
            ClassNode classNode2 = this.preprocess(classNode);
            this.utilClasses.put(classNode2.name, classNode2);
            if (classNode2.name.equals(nameBefore)) continue;
            renamedUtilityClassesToRemove.add(nameBefore);
        }
        for (Map.Entry entry : this.exactWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.baseWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.allClassAnnotationWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.allMethodAnnotationWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.baseAnnotationWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        this.errorHandler = this.preprocess(this.config.getErrorHandleClassNode());
        this.extensionTemplate = this.preprocess(this.config.getExtensionTemplate());
        for (String string : renamedUtilityClassesToRemove) {
            this.utilClasses.remove(string);
        }
        for (ClassNode classNode : this.utilClasses.values()) {
            this.checkReferences(classNode);
        }
        for (Map.Entry entry : this.exactWeaves.entrySet()) {
            this.checkReferences((ClassNode)entry.getValue());
            for (MethodNode methodNode : ((ClassNode)entry.getValue()).methods) {
                if (WeaveUtils.isEmptyConstructor(methodNode)) continue;
                this.methodSignatures.add(methodNode.name + methodNode.desc);
            }
        }
        for (Map.Entry entry : this.baseWeaves.entrySet()) {
            this.checkReferences((ClassNode)entry.getValue());
            for (MethodNode methodNode : ((ClassNode)entry.getValue()).methods) {
                if (WeaveUtils.isEmptyConstructor(methodNode)) continue;
                this.methodSignatures.add(methodNode.name + methodNode.desc);
            }
        }
    }

    private void checkReferences(ClassNode node) {
        Set<Reference> referencedClasses = Reference.create(node);
        for (Reference reference : referencedClasses) {
            if (reference.className.startsWith("java/") || reference.className.startsWith("javax/") || reference.className.startsWith("com/newrelic/api/") || reference.className.startsWith("com/newrelic/agent/") || this.utilClasses.containsKey(reference.className) || this.exactWeaves.containsKey(reference.className) || this.baseWeaves.containsKey(reference.className)) continue;
            if (this.references.containsKey(reference.className)) {
                Reference otherReference = this.references.get(reference.className);
                otherReference.merge(reference);
                continue;
            }
            this.references.put(reference.className, reference);
        }
    }

    private ClassNode preprocess(ClassNode input) {
        SynchronizedClassNode result = new SynchronizedClassNode(458752);
        ClassVisitor preprocessChain = this.config.getPreprocessor().preprocess(result, this.utilClasses.keySet(), this);
        preprocessChain = MethodProcessors.fixInvocationInstructions(preprocessChain, this.weaveMatches);
        preprocessChain = MethodProcessors.replaceGetImplementationTitle(preprocessChain, this.getName());
        if (this.renames.size() > 0) {
            preprocessChain = ReferenceUtils.getRenamingVisitor(this.renames, preprocessChain);
        }
        input.accept(preprocessChain);
        return result;
    }

    public boolean hasMatcher(String className, String[] superNames, String[] interfaceNames, Set<String> classAnnotations, Set<String> methodAnnotations, ClassCache classCache) throws IOException {
        Sets.SetView<String> matchingMethodAnnotations;
        int i;
        if (this.exactWeaves.containsKey(className) || this.baseWeaves.containsKey(className)) {
            return true;
        }
        for (i = 0; i < superNames.length; ++i) {
            if (!this.baseWeaves.containsKey(superNames[i])) continue;
            return true;
        }
        for (i = 0; i < interfaceNames.length; ++i) {
            if (!this.baseWeaves.containsKey(interfaceNames[i])) continue;
            return true;
        }
        Sets.SetView<String> matchingAnnotations = Sets.intersection(this.allClassAnnotationWeaves.keySet(), classAnnotations);
        if (!matchingAnnotations.isEmpty()) {
            return true;
        }
        if (!this.baseAnnotationWeaves.isEmpty()) {
            Set<String> requiredBaseAnnotations = this.baseAnnotationWeaves.keySet();
            for (String interfaceName : interfaceNames) {
                ClassInformation classInformation = classCache.getClassInformation(interfaceName);
                if (!this.classHasRequiredAnnotations(classInformation, requiredBaseAnnotations)) continue;
                return true;
            }
        }
        return !(matchingMethodAnnotations = Sets.intersection(this.allMethodAnnotationWeaves.keySet(), methodAnnotations)).isEmpty();
    }

    private boolean classHasRequiredAnnotations(ClassInformation classInformation, Set<String> requiredAnnotations) {
        return classInformation != null && !Sets.intersection(classInformation.classAnnotationNames, requiredAnnotations).isEmpty();
    }

    public List<WeaveViolation> getPackageViolations() {
        return new ArrayList<WeaveViolation>(this.packageViolations);
    }

    public PackageValidationResult validate(ClassCache cache) throws IOException {
        if (this.packageViolations.size() == 0) {
            return new PackageValidationResult(this, cache, this.references.values(), this.exactWeaves, this.baseWeaves, this.allClassAnnotationWeaves, this.baseAnnotationWeaves, this.allMethodAnnotationWeaves, this.utilClasses, this.skipIfPresentClasses, this.errorHandler, this.extensionTemplate);
        }
        return new PackageValidationResult(this, this.packageViolations);
    }

    public WeavePackageConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config.getName();
    }

    public float getVersion() {
        return this.config.getVersion();
    }

    public Map<String, MatchType> getMatchTypes() {
        return this.weaveMatches;
    }

    public Set<String> getReferencedClassNames() {
        return this.references.keySet();
    }

    public Map<String, String> getRenames() {
        return this.renames;
    }

    public Set<String> getAllRequiredAnnotationClasses() {
        return this.allClassAnnotationWeaves.keySet();
    }

    public Set<String> getAllRequiredMethodAnnotationClasses() {
        return this.allMethodAnnotationWeaves.keySet();
    }

    Map<String, ClassNode> getAllClassAnnotationWeaves() {
        return this.allClassAnnotationWeaves;
    }

    Map<String, ClassNode> getAllMethodAnnotationWeaves() {
        return this.allMethodAnnotationWeaves;
    }

    public Set<String> getRequiredAnnotationClassesForAnnotationWeave(String annotationWeaveClassName) {
        Set<String> requiredAnnotations = this.requiredClassAnnotationsLookup.get(annotationWeaveClassName);
        return requiredAnnotations != null ? requiredAnnotations : Collections.emptySet();
    }

    public Set<String> getRequiredAnnotationClassesForMethodAnnotationWeave(String annotationWeaveClassName) {
        Set<String> requiredAnnotations = this.requiredMethodAnnotationsLookup.get(annotationWeaveClassName);
        return requiredAnnotations != null ? requiredAnnotations : Collections.emptySet();
    }

    public Set<String> getRequiredClasses() {
        HashSet<String> required = new HashSet<String>();
        required.addAll(this.exactWeaves.keySet());
        required.addAll(this.baseWeaves.keySet());
        required.addAll(this.references.keySet());
        required.addAll(this.allClassAnnotationWeaves.keySet());
        required.addAll(this.allMethodAnnotationWeaves.keySet());
        return required;
    }

    public Set<String> getIllegalClasses() {
        return this.skipIfPresentClasses;
    }

    public boolean weavesBootstrap() {
        return this.weavesBootstrap;
    }

    public Set<String> getMethodSignatures() {
        return this.methodSignatures;
    }

    public String toString() {
        return "WeavePackage [config=" + this.config + "]";
    }

    Map<String, ClassNode> getExactWeaves() {
        return this.exactWeaves;
    }

    Map<String, ClassNode> getBaseWeaves() {
        return this.baseWeaves;
    }

    Map<String, ClassNode> getUtilClasses() {
        return this.utilClasses;
    }

    Map<String, Reference> getReferences() {
        return this.references;
    }

    void setWeavesBootstrap() {
        this.weavesBootstrap = true;
    }

    public ClassNode getExtensionTemplate() {
        return this.extensionTemplate;
    }
}

