/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.KeyTransactionConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class KeyTransactionConfigImpl
implements KeyTransactionConfig {
    private final Map<String, Long> apdexTs;
    private final long apdexTInMillis;

    private KeyTransactionConfigImpl(Map<String, Object> props, long apdexTInMillis) {
        this.apdexTInMillis = apdexTInMillis;
        HashMap<String, Long> apdexTs = new HashMap<String, Long>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Object apdexT = entry.getValue();
            if (!(apdexT instanceof Number)) continue;
            Long apdexTinMillis = (long)(((Number)apdexT).doubleValue() * 1000.0);
            String txName = entry.getKey();
            apdexTs.put(txName, apdexTinMillis);
        }
        this.apdexTs = Collections.unmodifiableMap(apdexTs);
    }

    @Override
    public boolean isApdexTSet(String transactionName) {
        return this.apdexTs.containsKey(transactionName);
    }

    @Override
    public long getApdexTInMillis(String transactionName) {
        Long apdexT = this.apdexTs.get(transactionName);
        if (apdexT == null) {
            return this.apdexTInMillis;
        }
        return apdexT;
    }

    static KeyTransactionConfig createKeyTransactionConfig(Map<String, Object> settings, long apdexTInMillis) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new KeyTransactionConfigImpl(settings, apdexTInMillis);
    }
}

