/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.ExtensionInstrumentation;
import com.newrelic.agent.instrumentation.InstrumentationImpl;
import com.newrelic.agent.instrumentation.InterfaceImplementationClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMixinClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ClassesMatcher;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextClassMatcherHelper;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.custom.ClassRetransformer;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.instrumentation.weaver.ClassLoaderClassTransformer;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.security.schema.SecurityMetaData;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class ClassTransformerServiceImpl
extends AbstractService
implements ClassTransformerService {
    private final boolean isEnabled;
    private volatile PointCutClassTransformer classTransformer;
    private volatile ClassRetransformer localRetransformer;
    private volatile ClassRetransformer remoteRetransformer;
    private final List<ClassFileTransformer> classTransformers = Collections.synchronizedList(new ArrayList());
    private final long shutdownTime;
    private InstrumentationContextManager contextManager;
    private TraceMatchTransformer traceMatchTransformer;
    private ClassLoaderClassTransformer classLoaderClassTransformer = null;
    private final InstrumentationImpl instrumentation;
    private final ScheduledExecutorService executor;
    private final Instrumentation extensionInstrumentation;
    private final AtomicReference<Set<ClassMatchVisitorFactory>> retransformClassMatchers = new AtomicReference<Set<ClassMatchVisitorFactory>>(this.createRetransformClassMatcherList());

    public ClassTransformerServiceImpl(InstrumentationProxy instrumentationProxy) throws Exception {
        super(ClassTransformerServiceImpl.class.getSimpleName());
        ClassTransformerConfig classTransformerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig();
        this.isEnabled = classTransformerConfig.isEnabled();
        if (this.isEnabled) {
            this.classLoaderClassTransformer = new ClassLoaderClassTransformer(instrumentationProxy, classTransformerConfig.getClassloaderDelegationExcludes(), classTransformerConfig.getClassloaderDelegationIncludes());
            this.classLoaderClassTransformer.start(instrumentationProxy.getAllLoadedClasses());
        }
        this.extensionInstrumentation = new ExtensionInstrumentation(instrumentationProxy);
        this.instrumentation = new InstrumentationImpl(this.logger, classTransformerConfig);
        AgentBridge.instrumentation = this.instrumentation;
        DefaultThreadFactory factory2 = new DefaultThreadFactory("New Relic Retransformer", true);
        this.executor = Executors.newSingleThreadScheduledExecutor(factory2);
        long shutdownDelayInNanos = classTransformerConfig.getShutdownDelayInNanos();
        if (shutdownDelayInNanos > 0L) {
            this.shutdownTime = System.nanoTime() + shutdownDelayInNanos;
            String msg = MessageFormat.format("The Class Transformer Service will stop instrumenting classes after {0} secs", TimeUnit.SECONDS.convert(shutdownDelayInNanos, TimeUnit.NANOSECONDS));
            this.getLogger().info(msg);
        } else {
            this.shutdownTime = Long.MAX_VALUE;
        }
    }

    private Set<ClassMatchVisitorFactory> createRetransformClassMatcherList() {
        return Sets.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("The class transformer is disabled.  No classes will be instrumented.");
            return;
        }
        InstrumentationProxy instrProxy = ServiceFactory.getCoreService().getInstrumentation();
        if (instrProxy == null) {
            this.getLogger().severe("Unable to initialize the class transformer because there is no instrumentation hook");
        } else {
            this.classTransformer = this.startClassTransformer(instrProxy);
        }
        this.queueRetransform();
    }

    private void queueRetransform() {
        this.executor.schedule(() -> this.retransformMatchingClasses(), this.getRetransformPeriodInSeconds(), TimeUnit.SECONDS);
    }

    private long getRetransformPeriodInSeconds() {
        return (Long)ServiceFactory.getConfigService().getDefaultAgentConfig().getValue("class_transformer.retransformation_period", 10L);
    }

    @Override
    public void checkShutdown() {
        if (this.shutdownTime == Long.MAX_VALUE || this.isStopped()) {
            return;
        }
        long nsTilShutdown = this.shutdownTime - System.nanoTime();
        if (nsTilShutdown < 0L) {
            try {
                this.getLogger().info("Stopping Class Transformer Service based on configured shutdown_delay");
                this.stop();
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Failed to stop Class Transformer Service: {0}", e);
                this.getLogger().error(msg);
            }
        }
    }

    private PointCutClassTransformer startClassTransformer(InstrumentationProxy instrProxy) throws Exception {
        StartableClassFileTransformer[] startableClassTransformers;
        boolean retransformSupported = this.isRetransformationSupported(instrProxy);
        PointCutClassTransformer classTransformer = new PointCutClassTransformer(instrProxy, retransformSupported);
        this.contextManager = InstrumentationContextManager.create(this.classLoaderClassTransformer, instrProxy, AgentBridge.class.getClassLoader() == null);
        NewRelic.getAgent().getTransaction();
        StringUtils.startsWithAny("\n", "", "\n");
        new SecurityMetaData();
        this.contextManager.addContextClassTransformer(classTransformer.getMatcher(), classTransformer);
        for (PointCut pc : classTransformer.getPointcuts()) {
            Agent.LOG.log(Level.FINER, "pointcut {0} active", pc);
            pc.noticeTransformerStarted(classTransformer);
        }
        Agent.LOG.log(Level.FINE, "enabled {0} pointcuts", classTransformer.getPointcuts().size());
        this.localRetransformer = new ClassRetransformer(this.contextManager);
        this.localRetransformer.setClassMethodMatchers(ServiceFactory.getExtensionService().getEnabledPointCuts());
        this.remoteRetransformer = new ClassRetransformer(this.contextManager);
        this.traceMatchTransformer = new TraceMatchTransformer(this.contextManager);
        for (StartableClassFileTransformer transformer : startableClassTransformers = new StartableClassFileTransformer[]{new InterfaceMixinClassTransformer(classTransformer.getClassReaderFlags())}) {
            transformer.start(instrProxy, retransformSupported);
            this.classTransformers.add(transformer);
        }
        for (StartableClassFileTransformer transformer : InterfaceImplementationClassTransformer.getClassTransformers(classTransformer)) {
            transformer.start(instrProxy, retransformSupported);
            this.classTransformers.add(transformer);
        }
        return classTransformer;
    }

    private boolean isRetransformationSupported(InstrumentationProxy instrProxy) {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        Boolean enableClassRetransformation = (Boolean)config.getProperty("enable_class_retransformation");
        if (enableClassRetransformation != null) {
            return enableClassRetransformation;
        }
        try {
            return instrProxy.isRetransformClassesSupported();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unexpected error asking current JVM configuration if it supports retransformation of classes: {0}", e);
            this.getLogger().warning(msg);
            return false;
        }
    }

    private void retransformMatchingClasses() {
        Set<ClassMatchVisitorFactory> matchers = this.retransformClassMatchers.getAndSet(this.createRetransformClassMatcherList());
        if (!matchers.isEmpty()) {
            InstrumentationProxy instrumentation = ServiceFactory.getCoreService().getInstrumentation();
            this.retransformMatchingClassesImmediately(instrumentation.getAllLoadedClasses(), matchers);
        }
    }

    @Override
    public void retransformMatchingClasses(Collection<ClassMatchVisitorFactory> matchers) {
        this.retransformClassMatchers.get().addAll(matchers);
        this.queueRetransform();
    }

    @Override
    public void retransformMatchingClassesImmediately(Class<?>[] loadedClasses, Collection<ClassMatchVisitorFactory> matchers) {
        InstrumentationProxy instrumentation = ServiceFactory.getCoreService().getInstrumentation();
        InstrumentationContextClassMatcherHelper matcherHelper = new InstrumentationContextClassMatcherHelper();
        Set<Class<?>> classesToRetransform = ClassesMatcher.getMatchingClasses(matchers, matcherHelper, loadedClasses);
        if (!classesToRetransform.isEmpty()) {
            try {
                instrumentation.retransformClasses(classesToRetransform.toArray(new Class[0]));
            }
            catch (UnmodifiableClassException e) {
                this.logger.log(Level.FINER, "Error retransforming classes: " + classesToRetransform, e);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.executor.shutdown();
        InstrumentationProxy instrProxy = ServiceFactory.getCoreService().getInstrumentation();
        if (instrProxy == null) {
            return;
        }
        for (ClassFileTransformer classFileTransformer : this.classTransformers) {
            instrProxy.removeTransformer(classFileTransformer);
        }
    }

    @Override
    public InstrumentationContextManager getContextManager() {
        return this.contextManager;
    }

    @Override
    public PointCutClassTransformer getClassTransformer() {
        return this.classTransformer;
    }

    @Override
    public ClassRetransformer getLocalRetransformer() {
        return this.localRetransformer;
    }

    @Override
    public ClassRetransformer getRemoteRetransformer() {
        return this.remoteRetransformer;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean addTraceMatcher(ClassAndMethodMatcher matcher, String metricPrefix) {
        return this.addTraceMatcher(matcher, TraceDetailsBuilder.newBuilder().setMetricPrefix(metricPrefix).build());
    }

    @Override
    public boolean addTraceMatcher(ClassAndMethodMatcher matcher, TraceDetails traceDetails) {
        return this.traceMatchTransformer.addTraceMatcher(matcher, traceDetails);
    }

    @Override
    public Instrumentation getExtensionInstrumentation() {
        return this.extensionInstrumentation;
    }

    @Override
    public void retransformForAttach() {
        AnnotationMatcher traceAnnotationMatcher = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig().getTraceAnnotationMatcher();
        Predicate<Class> traceMatcher = Utils.getAnnotationsMatcher(traceAnnotationMatcher);
        List<Class> classesToRejit = Arrays.asList(this.getExtensionInstrumentation().getAllLoadedClasses()).stream().filter(traceMatcher).collect(Collectors.toList());
        if (!classesToRejit.isEmpty()) {
            try {
                this.getExtensionInstrumentation().retransformClasses(classesToRejit.toArray(new Class[0]));
            }
            catch (UnmodifiableClassException e) {
                Agent.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private static class TraceMatchTransformer
    implements ContextClassTransformer {
        private final Map<ClassAndMethodMatcher, TraceDetails> matchersToTraceDetails = new ConcurrentHashMap<ClassAndMethodMatcher, TraceDetails>();
        private final Set<ClassMatchVisitorFactory> matchVisitors = Sets.newConcurrentHashSet();
        private final InstrumentationContextManager contextManager;

        TraceMatchTransformer(InstrumentationContextManager manager) {
            this.contextManager = manager;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
            for (Method method : match.getMethods()) {
                for (ClassAndMethodMatcher matcher : match.getClassMatches().keySet()) {
                    if (!matcher.getMethodMatcher().matches(-1, method.getName(), method.getDescriptor(), match.getMethodAnnotations(method))) continue;
                    context.putTraceAnnotation(method, this.matchersToTraceDetails.get(matcher));
                }
            }
            return null;
        }

        public boolean addTraceMatcher(ClassAndMethodMatcher matcher, TraceDetails traceDetails) {
            if (!this.matchersToTraceDetails.containsKey(matcher)) {
                return this.addMatchVisitor(matcher, traceDetails);
            }
            return false;
        }

        private synchronized boolean addMatchVisitor(ClassAndMethodMatcher matcher, TraceDetails traceDetails) {
            if (!this.matchersToTraceDetails.containsKey(matcher)) {
                this.matchersToTraceDetails.put(matcher, traceDetails);
                OptimizedClassMatcherBuilder builder = OptimizedClassMatcherBuilder.newBuilder();
                builder.addClassMethodMatcher(matcher);
                ClassMatchVisitorFactory matchVisitor = builder.build();
                this.matchVisitors.add(matchVisitor);
                this.contextManager.addContextClassTransformer(matchVisitor, this);
                return true;
            }
            return false;
        }
    }
}

