/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Multimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimaps;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.TraceDetailsList;
import com.newrelic.agent.instrumentation.context.TraceInformation;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstrumentationContext
implements TraceDetailsList {
    private static final TraceInformation EMPTY_TRACE_INFO = new TraceInformation();
    protected final byte[] bytes;
    private boolean modified;
    private Multimap<Method, String> weavedMethods;
    private Multimap<Method, String> skipMethods;
    private Set<String> scalaFinalFields;
    private Set<Method> timedMethods;
    private Map<Method, PointCut> oldReflectionStyleInstrumentationMethods;
    private Map<Method, PointCut> oldInvokerStyleInstrumentationMethods;
    private TraceInformation tracedInfo;
    private Map<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> matches;
    private String[] interfaces;
    private Map<Method, Method> bridgeMethods;
    private String className;
    private final Class<?> classBeingRedefined;
    private final ProtectionDomain protectionDomain;
    private List<ClassResolver> classResolvers;
    private boolean generated;
    private boolean hasSource;

    public InstrumentationContext(byte[] bytes, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
        this.bytes = bytes;
        this.classBeingRedefined = classBeingRedefined;
        this.protectionDomain = protectionDomain;
    }

    public String[] getInterfaces() {
        return null == this.interfaces ? new String[]{} : this.interfaces;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getClassBeingRedefined() {
        return this.classBeingRedefined;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public void markAsModified() {
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public TraceInformation getTraceInformation() {
        return this.tracedInfo == null ? EMPTY_TRACE_INFO : this.tracedInfo;
    }

    public boolean isTracerMatch() {
        return this.tracedInfo != null && this.tracedInfo.isMatch();
    }

    public void addWeavedMethod(Method method, String instrumentationTitle) {
        if (this.weavedMethods == null) {
            this.weavedMethods = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        }
        if (this.skipMethods == null || !this.skipMethods.containsKey(method)) {
            this.weavedMethods.put(method, instrumentationTitle);
            this.modified = true;
        }
    }

    public void addSkipMethod(Method method, String owningClass) {
        if (this.skipMethods == null) {
            this.skipMethods = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        }
        this.skipMethods.put(method, owningClass);
    }

    public void addScalaFinalField(String fieldName) {
        if (this.scalaFinalFields == null) {
            this.scalaFinalFields = new HashSet<String>();
        }
        this.scalaFinalFields.add(fieldName);
    }

    public PointCut getOldStylePointCut(Method method) {
        PointCut pc = this.getOldInvokerStyleInstrumentationMethods().get(method);
        if (pc == null) {
            pc = this.getOldReflectionStyleInstrumentationMethods().get(method);
        }
        return pc;
    }

    private Map<Method, PointCut> getOldInvokerStyleInstrumentationMethods() {
        return this.oldInvokerStyleInstrumentationMethods == null ? Collections.emptyMap() : this.oldInvokerStyleInstrumentationMethods;
    }

    private Map<Method, PointCut> getOldReflectionStyleInstrumentationMethods() {
        return this.oldReflectionStyleInstrumentationMethods == null ? Collections.emptyMap() : this.oldReflectionStyleInstrumentationMethods;
    }

    public Set<Method> getWeavedMethods() {
        return this.weavedMethods == null ? Collections.emptySet() : this.weavedMethods.keySet();
    }

    public Map<Method, Collection<String>> getSkipMethods() {
        return this.skipMethods == null ? Collections.emptyMap() : this.skipMethods.asMap();
    }

    public Set<String> getScalaFinalFields() {
        return this.scalaFinalFields == null ? Collections.emptySet() : new HashSet<String>(this.scalaFinalFields);
    }

    public Set<Method> getTimedMethods() {
        return this.timedMethods == null ? Collections.emptySet() : this.timedMethods;
    }

    public Collection<String> getMergeInstrumentationPackages(Method method) {
        return this.weavedMethods == null ? Collections.emptySet() : this.weavedMethods.asMap().get(method);
    }

    public boolean isModified(Method method) {
        return this.getTimedMethods().contains(method) || this.getWeavedMethods().contains(method);
    }

    public void addTimedMethods(Method ... methods) {
        if (this.timedMethods == null) {
            this.timedMethods = new HashSet<Method>();
        }
        Collections.addAll(this.timedMethods, methods);
        this.modified = true;
    }

    public void addOldReflectionStyleInstrumentationMethod(Method method, PointCut pointCut) {
        if (this.oldReflectionStyleInstrumentationMethods == null) {
            this.oldReflectionStyleInstrumentationMethods = new HashMap<Method, PointCut>();
        }
        this.oldReflectionStyleInstrumentationMethods.put(method, pointCut);
        this.modified = true;
    }

    public void addOldInvokerStyleInstrumentationMethod(Method method, PointCut pointCut) {
        if (this.oldInvokerStyleInstrumentationMethods == null) {
            this.oldInvokerStyleInstrumentationMethods = new HashMap<Method, PointCut>();
        }
        this.oldInvokerStyleInstrumentationMethods.put(method, pointCut);
        this.modified = true;
    }

    public Map<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> getMatches() {
        return this.matches == null ? Collections.emptyMap() : this.matches;
    }

    public void putTraceAnnotation(Method method, TraceDetails traceDetails) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.putTraceAnnotation(method, traceDetails);
    }

    public void addIgnoreApdexMethod(String methodName, String methodDesc) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreApdexMethod(methodName, methodDesc);
    }

    public void addIgnoreTransactionMethod(String methodName, String methodDesc) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreTransactionMethod(methodName, methodDesc);
    }

    public void addIgnoreTransactionMethod(Method m4) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreTransactionMethod(m4);
    }

    public void putMatch(ClassMatchVisitorFactory matcher, OptimizedClassMatcher.Match match) {
        if (this.matches == null) {
            this.matches = new HashMap<ClassMatchVisitorFactory, OptimizedClassMatcher.Match>();
        }
        this.matches.put(matcher, match);
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addTracedMethods(Map<Method, TraceDetails> tracedMethods) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.pullAll(tracedMethods);
    }

    @Override
    public void addTrace(Method method, TraceDetails traceDetails) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.putTraceAnnotation(method, traceDetails);
    }

    public void match(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, Collection<ClassMatchVisitorFactory> classVisitorFactories) {
        ClassVisitor visitor = null;
        for (ClassMatchVisitorFactory factory2 : classVisitorFactories) {
            ClassVisitor nextVisitor = factory2.newClassMatchVisitor(loader, classBeingRedefined, reader, visitor, this);
            if (nextVisitor == null) continue;
            visitor = nextVisitor;
        }
        if (visitor != null) {
            reader.accept(visitor, 4);
            if (this.bridgeMethods != null) {
                this.resolveBridgeMethods(reader);
            } else {
                this.bridgeMethods = ImmutableMap.of();
            }
        }
    }

    private void resolveBridgeMethods(ClassReader reader) {
        ClassVisitor visitor = new ClassVisitor(589824){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final Method method = new Method(name, desc);
                if (InstrumentationContext.this.bridgeMethods.containsKey(method)) {
                    return new MethodVisitor(589824){

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            InstrumentationContext.this.bridgeMethods.put(method, new Method(name, desc));
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return null;
            }
        };
        reader.accept(visitor, 6);
    }

    public void addBridgeMethod(Method method) {
        if (this.bridgeMethods == null) {
            this.bridgeMethods = new HashMap<Method, Method>();
        }
        this.bridgeMethods.put(method, method);
    }

    public Map<Method, Method> getBridgeMethods() {
        return this.bridgeMethods;
    }

    public boolean isUsingLegacyInstrumentation() {
        return null != this.oldInvokerStyleInstrumentationMethods || null != this.oldReflectionStyleInstrumentationMethods;
    }

    public boolean hasModifiedClassStructure() {
        return null != this.oldInvokerStyleInstrumentationMethods;
    }

    public void addClassResolver(ClassResolver classResolver) {
        if (this.classResolvers == null) {
            this.classResolvers = new ArrayList<ClassResolver>();
        }
        this.classResolvers.add(classResolver);
    }

    public ClassResolver getClassResolver(ClassLoader loader) {
        ClassResolver classResolver = ClassResolvers.getClassLoaderResolver(loader);
        if (this.classResolvers != null) {
            this.classResolvers.add(classResolver);
            classResolver = ClassResolvers.getMultiResolver(this.classResolvers);
        }
        return classResolver;
    }

    public void setGenerated(boolean isGenerated) {
        this.generated = isGenerated;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setSourceAttribute(boolean hasSource) {
        this.hasSource = hasSource;
    }

    public boolean hasSourceAttribute() {
        return this.hasSource;
    }

    public URL getCodeSourceLocation() {
        if (this.protectionDomain == null || this.protectionDomain.getCodeSource() == null) {
            return null;
        }
        return this.protectionDomain.getCodeSource().getLocation();
    }
}

