/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.model;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.model.AnalyticsEvent;
import com.newrelic.agent.model.AttributeFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ErrorEvent
extends AnalyticsEvent
implements JSONStreamAware {
    public static final float UNASSIGNED = Float.NEGATIVE_INFINITY;
    public static final int UNASSIGNED_INT = Integer.MIN_VALUE;
    public static final String TYPE = "TransactionError";
    public static final String UNKNOWN = "Unknown";
    final String errorClass;
    final String errorMessage;
    final boolean errorExpected;
    final String transactionName;
    final float duration;
    final float queueDuration;
    final float externalDuration;
    final float databaseDuration;
    final float gcCumulative;
    final float databaseCallCount;
    final float externalCallCount;
    final String transactionGuid;
    final String referringTransactionGuid;
    final String syntheticsResourceId;
    final String syntheticsMonitorId;
    final String syntheticsJobId;
    final String syntheticsType;
    final String syntheticsInitiator;
    final Map<String, String> syntheticsAttributes;
    final int port;
    final String timeoutCause;
    final String tripId;
    final Map<String, Object> distributedTraceIntrinsics;
    final Map<String, Object> agentAttributes;
    final String appName;
    private final AttributeFilter attributeFilter;

    public ErrorEvent(String appName, long timestamp, float priority, Map<String, Object> userAttributes, String errorClass, String errorMessage, boolean errorExpected, String transactionName, float duration, float queueDuration, float externalDuration, float databaseDuration, float gcCumulative, float databaseCallCount, float externalCallCount, String transactionGuid, String referringTransactionGuid, String syntheticsResourceId, String syntheticsMonitorId, String syntheticsJobId, String syntheticsType, String syntheticsInitiator, Map<String, String> syntheticsAttributes, int port, String timeoutCause, String tripId, Map<String, Object> distributedTraceIntrinsics, Map<String, Object> agentAttributes, AttributeFilter attributeFilter) {
        super(TYPE, timestamp, priority, new HashMap<String, Object>(userAttributes));
        this.errorClass = errorClass;
        this.errorMessage = errorMessage;
        this.errorExpected = errorExpected;
        this.transactionName = transactionName;
        this.duration = duration;
        this.queueDuration = queueDuration;
        this.externalDuration = externalDuration;
        this.databaseDuration = databaseDuration;
        this.gcCumulative = gcCumulative;
        this.databaseCallCount = databaseCallCount;
        this.externalCallCount = externalCallCount;
        this.transactionGuid = transactionGuid;
        this.referringTransactionGuid = referringTransactionGuid;
        this.syntheticsResourceId = syntheticsResourceId;
        this.syntheticsMonitorId = syntheticsMonitorId;
        this.syntheticsJobId = syntheticsJobId;
        this.syntheticsType = syntheticsType;
        this.syntheticsInitiator = syntheticsInitiator;
        this.syntheticsAttributes = syntheticsAttributes;
        this.port = port;
        this.timeoutCause = timeoutCause;
        this.tripId = tripId;
        this.distributedTraceIntrinsics = distributedTraceIntrinsics;
        this.agentAttributes = agentAttributes;
        this.appName = appName;
        this.attributeFilter = attributeFilter;
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public Map<String, Object> getDistributedTraceIntrinsics() {
        return this.distributedTraceIntrinsics;
    }

    public String getTransactionGuid() {
        return this.transactionGuid;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("type", this.getType());
        obj.put("error.class", this.errorClass);
        obj.put("error.message", this.errorMessage);
        obj.put("timestamp", this.getTimestamp());
        obj.put("transactionName", this.transactionName);
        obj.put("error.expected", this.errorExpected);
        if (this.duration != Float.NEGATIVE_INFINITY) {
            obj.put("duration", Float.valueOf(this.duration));
        }
        if (this.queueDuration != Float.NEGATIVE_INFINITY) {
            obj.put("queueDuration", Float.valueOf(this.queueDuration));
        }
        if (this.externalDuration != Float.NEGATIVE_INFINITY) {
            obj.put("externalDuration", Float.valueOf(this.externalDuration));
        }
        if (this.databaseDuration > 0.0f) {
            obj.put("databaseDuration", Float.valueOf(this.databaseDuration));
        }
        if (this.gcCumulative != Float.NEGATIVE_INFINITY) {
            obj.put("gcCumulative", Float.valueOf(this.gcCumulative));
        }
        if (this.databaseCallCount > 0.0f) {
            obj.put("databaseCallCount", Float.valueOf(this.databaseCallCount));
        }
        if (this.externalCallCount > 0.0f) {
            obj.put("externalCallCount", Float.valueOf(this.externalCallCount));
        }
        if (this.transactionGuid != null) {
            obj.put("nr.transactionGuid", this.transactionGuid);
        }
        if (this.referringTransactionGuid != null) {
            obj.put("nr.referringTransactionGuid", this.referringTransactionGuid);
        }
        if (this.syntheticsResourceId != null) {
            obj.put("nr.syntheticsResourceId", this.syntheticsResourceId);
        }
        if (this.syntheticsMonitorId != null) {
            obj.put("nr.syntheticsMonitorId", this.syntheticsMonitorId);
        }
        if (this.syntheticsJobId != null) {
            obj.put("nr.syntheticsJobId", this.syntheticsJobId);
        }
        if (this.syntheticsType != null) {
            obj.put("nr.syntheticsType", this.syntheticsType);
        }
        if (this.syntheticsInitiator != null) {
            obj.put("nr.syntheticsInitiator", this.syntheticsInitiator);
        }
        if (this.syntheticsAttributes != null) {
            for (String key : this.syntheticsAttributes.keySet()) {
                String upperCaseKey = Character.toUpperCase(key.charAt(0)) + key.substring(1);
                String attrName = String.format("nr.synthetics%s", upperCaseKey);
                obj.put(attrName, this.syntheticsAttributes.get(key));
            }
        }
        if (this.port != Integer.MIN_VALUE) {
            obj.put("port", this.port);
        }
        if (this.timeoutCause != null) {
            obj.put("nr.timeoutCause", this.timeoutCause);
        }
        if (this.distributedTraceIntrinsics != null && !this.distributedTraceIntrinsics.isEmpty()) {
            obj.putAll(this.distributedTraceIntrinsics);
        }
        if (this.tripId != null) {
            obj.put("nr.tripId", this.tripId);
        }
        if (this.getPriority() != Float.NEGATIVE_INFINITY) {
            obj.put("priority", Float.valueOf(this.getPriority()));
        }
        Map<String, ?> filteredUserAttrs = this.attributeFilter.filterUserAttributes(this.appName, this.getMutableUserAttributes());
        Map<String, ?> filteredAgentAttrs = this.attributeFilter.filterAgentAttributes(this.appName, this.agentAttributes);
        if (filteredAgentAttrs.isEmpty()) {
            if (filteredUserAttrs.isEmpty()) {
                JSONArray.writeJSONString(Collections.singletonList(obj), out);
            } else {
                JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAttrs), out);
            }
        } else {
            JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAttrs, filteredAgentAttrs), out);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public Map<String, Object> getAgentAttributes() {
        return Collections.unmodifiableMap(this.agentAttributes);
    }
}

