/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.utilization.CGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerData {
    private static final String FILE_WITH_CONTAINER_ID_V1 = "/proc/self/cgroup";
    private static final String FILE_WITH_CONTAINER_ID_V2 = "/proc/self/mountinfo";
    private static final String CPU = "cpu";
    private static final Pattern VALID_CONTAINER_ID = Pattern.compile("^[0-9a-f]{64}$");
    private static final Pattern DOCKER_CONTAINER_STRING_V1 = Pattern.compile("^.*[^0-9a-f]+([0-9a-f]{64,}).*");
    private static final Pattern DOCKER_CONTAINER_STRING_V2 = Pattern.compile(".*/docker/containers/([0-9a-f]{64,}).*");

    public String getDockerContainerId(boolean isLinux) {
        if (isLinux) {
            File containerIdFileV2 = new File(FILE_WITH_CONTAINER_ID_V2);
            String idResultV2 = this.getDockerIdFromFile(containerIdFileV2, CGroup.V2);
            if (idResultV2 != null) {
                return idResultV2;
            }
            File containerIdFileV1 = new File(FILE_WITH_CONTAINER_ID_V1);
            return this.getDockerIdFromFile(containerIdFileV1, CGroup.V1);
        }
        return null;
    }

    String getDockerIdFromFile(File mountInfoFile, CGroup cgroup) {
        if (mountInfoFile.exists() && mountInfoFile.canRead()) {
            try {
                return this.readFile(new FileReader(mountInfoFile), cgroup);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readFile(Reader reader, CGroup cgroup) {
        try (BufferedReader bReader = new BufferedReader(reader);){
            String line;
            StringBuilder resultGoesHere = new StringBuilder();
            do {
                if ((line = bReader.readLine()) == null) return null;
            } while (!this.checkLineAndGetResult(line, resultGoesHere, cgroup));
            String value = resultGoesHere.toString().trim();
            if (this.isInvalidDockerValue(value)) {
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to validate Docker value {0}", value));
                String string = null;
                return string;
            }
            String string = value;
            return string;
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Exception occurred when reading docker file.");
        }
        return null;
    }

    boolean checkLineAndGetResult(String line, StringBuilder resultGoesHere, CGroup cgroup) {
        if (cgroup == CGroup.V1) {
            return this.checkLineAndGetResultV1(line, resultGoesHere);
        }
        if (cgroup == CGroup.V2) {
            return this.checkLineAndGetResultV2(line, resultGoesHere);
        }
        return false;
    }

    private boolean checkLineAndGetResultV1(String line, StringBuilder resultGoesHere) {
        String[] parts = line.split(":");
        if (parts.length == 3 && this.validCpuLine(parts[1])) {
            String mayContainId = parts[2];
            if (this.checkAndGetMatch(DOCKER_CONTAINER_STRING_V1, resultGoesHere, mayContainId)) {
                return true;
            }
            if (!mayContainId.equals("/")) {
                Agent.LOG.log(Level.FINE, "Docker Data: Ignoring unrecognized cgroup ID format: {0}", mayContainId);
            }
        }
        return false;
    }

    private boolean checkLineAndGetResultV2(String line, StringBuilder resultGoesHere) {
        String mayContainId;
        String[] parts = line.split(" ");
        return parts.length >= 4 && this.checkAndGetMatch(DOCKER_CONTAINER_STRING_V2, resultGoesHere, mayContainId = parts[3]);
    }

    boolean isInvalidDockerValue(String value) {
        return value == null || !VALID_CONTAINER_ID.matcher(value).matches();
    }

    private boolean validCpuLine(String segment) {
        if (segment != null) {
            String[] parts;
            for (String current : parts = segment.split(",")) {
                if (!current.equals(CPU)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAndGetMatch(Pattern p, StringBuilder result, String segment) {
        Matcher m4 = p.matcher(segment);
        if (m4.matches() && m4.groupCount() == 1) {
            result.append(m4.group(1));
            return true;
        }
        return false;
    }
}

