/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.preferences.OperaScopePreferences;
import java.util.logging.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;

public class OperaProxy {
    private static final String PROXY_SECTION = "Proxy";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final OperaDriver driver;
    private final OperaProduct product;
    private final OperaScopePreferences preferences;

    public OperaProxy(OperaDriver parent) {
        this.driver = parent;
        this.product = this.driver.utils().getProduct();
        this.preferences = this.driver.preferences();
    }

    public String getHttpProxy() {
        return (String)this.getProxyValue(ProxyToPreference.HTTP_SERVER);
    }

    public void setHttpProxy(String host) {
        this.setProxyValue(ProxyToPreference.HTTP_SERVER, host);
        this.setProxyValue(ProxyToPreference.USE_HTTP, host != null);
    }

    public String getHttpsProxy() {
        return (String)this.getProxyValue(ProxyToPreference.HTTPS_SERVER);
    }

    public void setHttpsProxy(String host) {
        this.setProxyValue(ProxyToPreference.HTTPS_SERVER, host);
        this.setProxyValue(ProxyToPreference.USE_HTTPS, host != null);
    }

    public String getFtpProxy() {
        return (String)this.getProxyValue(ProxyToPreference.FTP_SERVER);
    }

    public void setFtpProxy(String host) {
        this.setProxyValue(ProxyToPreference.FTP_SERVER, host);
        this.setProxyValue(ProxyToPreference.USE_FTP, host != null);
    }

    public String getSocksProxy() {
        this.assertNotMobile();
        return (String)this.getProxyValue(ProxyToPreference.SOCKS_SERVER);
    }

    public void setSocksProxy(String host) {
        this.assertNotMobile();
        this.setProxyValue(ProxyToPreference.SOCKS_SERVER, host);
        this.setProxyValue(ProxyToPreference.USE_SOCKS, host != null);
    }

    public String getSocksUsername() {
        this.assertNotMobile();
        return (String)this.getProxyValue(ProxyToPreference.SOCKS_USERNAME);
    }

    public void setSocksUsername(String username) {
        this.assertNotMobile();
        this.setProxyValue(ProxyToPreference.SOCKS_USERNAME, username);
    }

    public String getSocksPassword() {
        this.assertNotMobile();
        return (String)this.getProxyValue(ProxyToPreference.SOCKS_PASSWORD);
    }

    public void setSocksPassword(String password) {
        this.assertNotMobile();
        this.setProxyValue(ProxyToPreference.SOCKS_PASSWORD, password);
    }

    public boolean isProxyLocal() {
        return (Boolean)this.getProxyValue(ProxyToPreference.PROXY_LOCAL_SERVERS);
    }

    public void setProxyLocal(boolean proxyLocalServers) {
        this.setProxyValue(ProxyToPreference.PROXY_LOCAL_SERVERS, proxyLocalServers);
    }

    public String getAutoconfigUrl() {
        return (String)this.getProxyValue(ProxyToPreference.AUTOMATIC_PROXY_CONFIGURATION_URL);
    }

    public void setAutoconfigUrl(String url) {
        this.setProxyValue(ProxyToPreference.AUTOMATIC_PROXY_CONFIGURATION_URL, url);
    }

    public boolean isUsePAC() {
        return (Boolean)this.getProxyValue(ProxyToPreference.USE_AUTOMATIC_PROXY_CONFIGURATION);
    }

    public void setUsePAC(boolean enabled) {
        this.setProxyValue(ProxyToPreference.USE_AUTOMATIC_PROXY_CONFIGURATION, enabled);
    }

    public boolean isEnabled() {
        if (this.product.is(OperaProduct.MOBILE)) {
            return true;
        }
        return (Boolean)this.getProxyValue(ProxyToPreference.ENABLE_PROXY);
    }

    public void setEnabled(boolean enabled) {
        this.assertNotMobile();
        this.setProxyValue(ProxyToPreference.ENABLE_PROXY, enabled);
    }

    public void parse(Proxy proxy) {
        if (proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return;
        }
        this.reset();
        switch (proxy.getProxyType()) {
            case DIRECT: {
                if (!this.product.is(OperaProduct.MOBILE)) {
                    this.setEnabled(false);
                }
                this.setUsePAC(false);
                break;
            }
            case MANUAL: {
                if (!this.product.is(OperaProduct.MOBILE)) {
                    this.setEnabled(true);
                }
                this.setUsePAC(false);
                if (proxy.getHttpProxy() != null) {
                    this.setHttpProxy(proxy.getHttpProxy());
                }
                if (proxy.getFtpProxy() == null) break;
                this.setFtpProxy(proxy.getFtpProxy());
                break;
            }
            case PAC: {
                if (!this.product.is(OperaProduct.MOBILE)) {
                    this.setEnabled(true);
                }
                this.setUsePAC(true);
                if (proxy.getProxyAutoconfigUrl() == null) break;
                this.setAutoconfigUrl(proxy.getProxyAutoconfigUrl());
                break;
            }
            default: {
                this.logger.warning("Unsupported proxy type: " + proxy.getProxyType());
            }
        }
    }

    protected void reset() {
        this.assertIsConnected();
        for (ProxyToPreference preference : ProxyToPreference.values()) {
            OperaScopePreferences.ScopePreference p = this.preferences.get(PROXY_SECTION, preference.getPreferenceKey());
            if (p == null) continue;
            p.reset();
        }
    }

    private Object getProxyValue(ProxyToPreference key) {
        Object value = this.preferences.get(PROXY_SECTION, key.getPreferenceKey()).getValue();
        if (value instanceof String && ((String)value).isEmpty()) {
            return null;
        }
        return value;
    }

    private void setProxyValue(ProxyToPreference key, Object value) {
        this.assertIsConnected();
        this.preferences.set(PROXY_SECTION, key.getPreferenceKey(), value);
    }

    private void assertIsConnected() {
        if (!this.driver.getScopeServices().isConnected()) {
            throw new WebDriverException("Unable to update proxy configuration; not connected!");
        }
    }

    private void assertNotMobile() {
        if (this.product.is(OperaProduct.MOBILE)) {
            throw new UnsupportedOperationException(String.format("Proxy setting not supported by product %s", new Object[]{this.product}));
        }
    }

    protected static enum ProxyToPreference {
        ENABLE_PROXY("Enable Proxy"),
        HTTP_SERVER("HTTP server"),
        USE_HTTP("Use HTTP"),
        HTTPS_SERVER("HTTPS server"),
        USE_HTTPS("Use HTTPS"),
        FTP_SERVER("FTP server"),
        USE_FTP("Use FTP"),
        SOCKS_SERVER("SOCKS server"),
        SOCKS_USERNAME("SOCKS username"),
        SOCKS_PASSWORD("SOCKS password"),
        USE_SOCKS("Use SOCKS"),
        PROXY_LOCAL_SERVERS("Use Proxy On Local Names Check"),
        AUTOMATIC_PROXY_CONFIGURATION_URL("Automatic Proxy Configuration URL"),
        USE_AUTOMATIC_PROXY_CONFIGURATION("Use Automatic Proxy Configuration");

        private final String key;

        private ProxyToPreference(String preferenceName) {
            this.key = preferenceName;
        }

        public String getPreferenceKey() {
            return this.key;
        }
    }
}

