/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.protobuf.GeneratedMessage;
import com.opera.core.systems.OperaBinary;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.arguments.OperaArgument;
import com.opera.core.systems.common.io.Closeables;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaLaunchers;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.launcher.OperaLauncherBinary;
import com.opera.core.systems.runner.launcher.OperaLauncherProtocol;
import com.opera.core.systems.runner.launcher.OperaLauncherProtos;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.PortProber;

public class OperaLauncherRunner
extends OperaRunner
implements com.opera.core.systems.runner.interfaces.OperaRunner {
    public static final String LAUNCHER_ENV_VAR = "OPERA_LAUNCHER";
    public static final String LAUNCHER_NAME = OperaLauncherRunner.launcherNameForOS();
    public static final File LAUNCHER_DIRECTORY = new File(System.getProperty("user.home"), ".launcher");
    public static final File LAUNCHER_DEFAULT_LOCATION = new File(LAUNCHER_DIRECTORY, LAUNCHER_NAME);
    private final int launcherPort = PortProber.findFreePort();
    private final List<String> arguments;
    private OperaLauncherBinary binary = null;
    private OperaLauncherProtocol protocol = null;
    private String crashlog = null;

    public OperaLauncherRunner() {
        this(new OperaSettings());
    }

    public OperaLauncherRunner(OperaSettings s) {
        super(s);
        URL bundledLauncher = OperaLaunchers.class.getClassLoader().getResource("launchers/" + LAUNCHER_NAME);
        if (bundledLauncher == null) {
            throw new OperaRunnerException("Not able to locate bundled launcher: " + bundledLauncher);
        }
        File launcher = this.settings.getLauncher();
        try {
            if (launcher.getCanonicalPath().equals(LAUNCHER_DEFAULT_LOCATION.getCanonicalPath()) && (!launcher.exists() || this.isLauncherOutdated(launcher))) {
                this.extractLauncher(bundledLauncher, launcher);
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException(e);
        }
        if (!launcher.canExecute() && !launcher.setExecutable(true)) {
            throw new OperaRunnerException("Unable to make launcher executable: " + launcher.getPath());
        }
        if (this.settings.getBinary() == null) {
            File binary = OperaBinary.find(this.settings.getProduct());
            if (binary == null) {
                throw new OperaRunnerException(String.format("Unable to find executable for product %s", new Object[]{this.settings.getProduct()}));
            }
            this.settings.setBinary(binary);
        }
        this.arguments = this.buildArguments();
        this.logger.config("launcher arguments: " + this.arguments);
        this.init();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        try {
            this.binary = new OperaLauncherBinary(this.settings.getLauncher().getPath(), this.arguments.toArray(new String[this.arguments.size()]));
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to start launcher: " + e.getMessage());
        }
        this.logger.fine("Waiting for launcher connection on port " + this.launcherPort);
        ServerSocket listenerServer = null;
        try {
            listenerServer = new ServerSocket(this.launcherPort);
            listenerServer.setSoTimeout((int)OperaIntervals.LAUNCHER_CONNECT_TIMEOUT.getMs());
            this.protocol = new OperaLauncherProtocol(listenerServer.accept());
            this.logger.fine("Connected with launcher on port " + this.launcherPort);
            OperaLauncherProtos.LauncherHandshakeRequest.Builder request = OperaLauncherProtos.LauncherHandshakeRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_HELLO, request.build().toByteArray());
            if (!res.isSuccess()) throw new OperaRunnerException("Did not get launcher handshake: " + res.getResponse().toString());
            this.logger.finer("Got launcher handshake: " + res.getResponse().toString());
        }
        catch (SocketTimeoutException e) {
            try {
                throw new OperaRunnerException("Timeout waiting for launcher to connect on port " + this.launcherPort, e);
                catch (IOException e2) {
                    throw new OperaRunnerException("Unable to listen to launcher port " + this.launcherPort, e2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(listenerServer);
                throw throwable;
            }
        }
        Closeables.closeQuietly(listenerServer);
    }

    protected List<String> buildArguments() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"-host").add((Object)this.settings.getHost());
        builder.add((Object)"-port").add((Object)String.format("%s", this.launcherPort));
        if (this.settings.getDisplay() != null && this.settings.getDisplay() > 0) {
            builder.add((Object)"-display").add((Object)String.format(":%s", this.settings.getDisplay()));
        }
        if (this.settings.logging().getLevel() != Level.OFF) {
            builder.add((Object)"-console");
            builder.add((Object)"-verbosity").add((Object)OperaLauncherRunner.toLauncherLoggingLevel(this.settings.logging().getLevel()).toString());
        }
        if (this.settings.getProduct() != OperaProduct.ALL) {
            builder.add((Object)"-profile").add((Object)this.settings.getProduct().getDescriptionString());
        }
        if (this.settings.getBackend() != null && !this.settings.getBackend().isEmpty()) {
            builder.add((Object)"-backend").add((Object)this.settings.getBackend());
        }
        if (this.settings.hasDetach()) {
            builder.add((Object)"-noquit");
        }
        builder.add((Object)"-bin").add((Object)this.settings.getBinary().getAbsolutePath());
        for (OperaArgument argument : this.settings.arguments()) {
            builder.add((Object)(this.settings.arguments().sign() + argument.getArgument()));
            if (argument.getValue() == null || argument.getValue().isEmpty()) continue;
            builder.add((Object)argument.getValue());
        }
        return builder.build();
    }

    @Override
    public void startOpera() throws OperaRunnerException {
        this.assertLauncherAlive();
        try {
            byte[] request = OperaLauncherProtos.LauncherStartRequest.newBuilder().build().toByteArray();
            OperaLauncherProtocol.ResponseEncapsulation res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_START, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new IOException("launcher unable to start binary");
            }
            try {
                Thread.sleep(OperaIntervals.PROCESS_START_SLEEP.getMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new IOException("Opera exited immediately; possibly incorrect arguments?  Command: " + this.binary.getCommands());
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not start Opera: " + e.getMessage());
        }
    }

    @Override
    public void stopOpera() throws OperaRunnerException {
        this.assertLauncherAlive();
        if (!this.isOperaRunning()) {
            return;
        }
        try {
            OperaLauncherProtos.LauncherStopRequest.Builder request = OperaLauncherProtos.LauncherStopRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STOP, request.build().toByteArray());
            if (this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new IOException("launcher unable to stop binary");
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not stop Opera: " + e.getMessage());
        }
    }

    @Override
    public boolean isOperaRunning() {
        return this.isOperaRunning(0);
    }

    public boolean isOperaRunning(int processId) {
        if (!this.isLauncherRunning()) {
            return false;
        }
        try {
            OperaLauncherProtos.LauncherStatusRequest.Builder request = OperaLauncherProtos.LauncherStatusRequest.newBuilder();
            if (processId > 0) {
                request.setProcessid(processId);
            }
            OperaLauncherProtocol.ResponseEncapsulation res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request.build().toByteArray());
            this.logger.finer("Getting Opera's status from launcher: " + res.getResponse().toString());
            return this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING;
        }
        catch (IOException e) {
            this.logger.fine("Could not get state of Opera, assuming launcher has shut down");
            return false;
        }
    }

    @Override
    public boolean hasOperaCrashed() {
        return this.crashlog != null;
    }

    @Override
    public String getOperaCrashlog() {
        return this.crashlog;
    }

    @Override
    public void shutdown() {
        if (!this.isLauncherRunning()) {
            return;
        }
        try {
            this.protocol.sendRequestWithoutResponse(OperaLauncherProtocol.MessageType.MSG_SHUTDOWN, null);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.protocol.shutdown();
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to shut down launcher", e);
        }
        finally {
            this.binary.shutdown();
            this.protocol = null;
            this.binary = null;
        }
    }

    @Override
    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) throws OperaRunnerException {
        byte[] resultBytes;
        String resultMd5;
        this.assertLauncherAlive();
        boolean blank = false;
        try {
            OperaLauncherProtos.LauncherScreenshotRequest.Builder request = OperaLauncherProtos.LauncherScreenshotRequest.newBuilder();
            for (String hash : hashes) {
                request.addKnownMD5S(hash);
            }
            request.setKnownMD5STimeoutMs((int)timeout);
            OperaLauncherProtocol.ResponseEncapsulation res = this.protocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_SCREENSHOT, request.build().toByteArray());
            OperaLauncherProtos.LauncherScreenshotResponse response = (OperaLauncherProtos.LauncherScreenshotResponse)res.getResponse();
            resultMd5 = response.getMd5();
            resultBytes = response.getImagedata().toByteArray();
            if (response.hasBlank()) {
                blank = response.getBlank();
            }
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher", e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher", e);
        }
        ScreenShotReply screenshotreply = new ScreenShotReply(resultMd5, resultBytes);
        screenshotreply.setBlank(blank);
        screenshotreply.setCrashed(this.hasOperaCrashed());
        return screenshotreply;
    }

    private OperaLauncherProtos.LauncherStatusResponse.StatusType handleStatusMessage(GeneratedMessage msg) {
        OperaLauncherProtos.LauncherStatusResponse response = (OperaLauncherProtos.LauncherStatusResponse)msg;
        this.logger.finest("[LAUNCHER] Status: " + response.getStatus().toString());
        if (response.hasExitcode()) {
            this.logger.finest("[LAUNCHER] Status: exitCode=" + response.getExitcode());
        }
        if (response.hasCrashlog()) {
            this.logger.finest("[LAUNCHER] Status: crashLog=yes");
        } else {
            this.logger.finest("[LAUNCHER] Status: crashLog=no");
        }
        if (response.getLogmessagesCount() > 0) {
            for (String message : response.getLogmessagesList()) {
                this.logger.finest("[LAUNCHER LOG] " + message);
            }
        } else {
            this.logger.finest("[LAUNCHER LOG] No log...");
        }
        OperaLauncherProtos.LauncherStatusResponse.StatusType status = response.getStatus();
        this.crashlog = status == OperaLauncherProtos.LauncherStatusResponse.StatusType.CRASHED ? (response.hasCrashlog() ? response.getCrashlog().toStringUtf8() : "") : null;
        return status;
    }

    private void extractLauncher(URL sourceLauncher, File targetLauncher) {
        Preconditions.checkNotNull((Object)sourceLauncher);
        Preconditions.checkNotNull((Object)targetLauncher);
        InputStream is = null;
        FileOutputStream os = null;
        try {
            targetLauncher.getParentFile().mkdirs();
            if (!targetLauncher.exists()) {
                Files.touch((File)targetLauncher);
            }
            is = sourceLauncher.openStream();
            os = new FileOutputStream(targetLauncher);
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new OperaRunnerException("Cannot write file to disk: " + e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                Closeables.closeQuietly(os);
                throw throwable;
            }
        }
        Closeables.closeQuietly(is);
        Closeables.closeQuietly(os);
        this.logger.fine("New launcher copied to " + targetLauncher.getPath());
    }

    private boolean isLauncherOutdated(File launcher) {
        try {
            return !OperaLauncherRunner.md5sum(OperaLauncherRunner.md5(launcher)).equals(OperaLaunchers.LAUNCHER_CHECKSUMS.get(launcher.getName()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperaRunnerException("Algorithm is not available in your environment: " + e.getMessage());
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to open stream or file: " + e.getMessage());
        }
    }

    private void assertLauncherAlive() {
        if (!this.isLauncherRunning()) {
            throw new OperaRunnerException("launcher was shutdown");
        }
    }

    private boolean isLauncherRunning() {
        return this.binary != null && this.binary.isRunning();
    }

    public static void assertLauncherGood(File launcher) throws IOException {
        if (!launcher.exists()) {
            throw new IOException("Unknown file: " + launcher.getPath());
        }
        if (!launcher.isFile()) {
            throw new IOException("Not a real file: " + launcher.getPath());
        }
        if (!FileHandler.canExecute((File)launcher).booleanValue()) {
            throw new IOException("Not executable: " + launcher.getPath());
        }
    }

    private static String launcherNameForOS() {
        Platform currentPlatform = Platform.getCurrent();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                return "launcher-linux-" + System.getProperty("os.arch").toLowerCase();
            }
            case MAC: {
                return "launcher-mac";
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return "launcher-win32-i86pc.exe";
            }
        }
        throw new WebDriverException("Could not find a platform that supports bundled launchers, please set it manually");
    }

    private static String md5sum(byte[] bytes) {
        String result = "";
        for (byte b : bytes) {
            result = result + Integer.toString((b & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    private static byte[] md5(InputStream fis) throws NoSuchAlgorithmException, IOException {
        return ByteStreams.hash((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])ByteStreams.toByteArray((InputStream)fis)), (HashFunction)Hashing.md5()).asBytes();
    }

    private static byte[] md5(File file) throws NoSuchAlgorithmException, IOException {
        return Files.hash((File)file, (HashFunction)Hashing.md5()).asBytes();
    }

    protected static Level toLauncherLoggingLevel(Level level) {
        switch (level.intValue()) {
            case 1000: {
                return Level.SEVERE;
            }
            case 900: {
                return Level.WARNING;
            }
            case 400: 
            case 500: 
            case 700: 
            case 800: {
                return Level.FINE;
            }
            case -2147483648: 
            case 300: {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }
}

