/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CookieManagerCommand implements ICommand
{
    GET_COOKIE(1),
    REMOVE_COOKIE(2),
    REMOVE_ALL_COOKIES(3),
    GET_COOKIE_SETTINGS(4),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, CookieManagerCommand> lookup;

    private CookieManagerCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "cookie-manager";
    }

    public static CookieManagerCommand get(int code) {
        CookieManagerCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, CookieManagerCommand>();
        for (CookieManagerCommand command : EnumSet.allOf(CookieManagerCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

