/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.model.ICommand;
import java.util.Map;

public enum WindowManagerCommand implements ICommand
{
    GET_ACTIVE_WINDOW(1),
    LIST_WINDOWS(2),
    MODIFY_FILTER(3),
    WINDOW_UPDATED(4),
    WINDOW_CLOSED(5),
    WINDOW_ACTIVATED(6),
    WINDOW_LOADED(7),
    CREATE_WINDOW(8),
    CLOSE_WINDOW(9),
    OPEN_URL(10),
    MODIFY_TYPE_FILTER(11),
    DEFAULT(-1);

    private static final Map<Integer, WindowManagerCommand> lookup;
    private final int code;

    private WindowManagerCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "window-manager";
    }

    public static WindowManagerCommand get(int code) {
        WindowManagerCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])WindowManagerCommand.values()), (Function)new Function<WindowManagerCommand, Integer>(){

            public Integer apply(WindowManagerCommand command) {
                return command.getCommandID();
            }
        });
    }
}

