/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.common.collect.CaseInsensitiveStringSet;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ColorResult;
import com.opera.core.systems.model.OperaColor;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ExecCommand;
import com.opera.core.systems.scope.exceptions.WindowNotFoundException;
import com.opera.core.systems.scope.internal.OperaColors;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.internal.OperaKeys;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.protos.ExecProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.util.VersionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;

public class OperaExec
extends AbstractService
implements IOperaExec {
    private static Logger logger = Logger.getLogger(OperaExec.class.getName());
    private List<String> keys;
    private Set<String> actions;
    private ScopeServices services;
    private List<String> excludedActions = ImmutableList.of((Object)"Select all", (Object)"Delete");

    public OperaExec(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "exec";
        if (!this.isVersionInRange(version, "3.0", serviceName)) {
            throw new UnsupportedOperationException(serviceName + " version " + version + " is not supported");
        }
        if (VersionUtil.compare(version, "2.0.1") == -1) {
            this.excludedActions.add("Close page");
        }
        services.setExec(this);
        this.services = services;
        this.keys = new CopyOnWriteArrayList<String>();
    }

    @Override
    public void init() {
        this.actions = this.initActionList();
    }

    private Set<String> initActionList() {
        UmsProtos.Response response = this.executeCommand(ExecCommand.GET_ACTION_LIST, null);
        ExecProtos.ActionInfoList.Builder builder = ExecProtos.ActionInfoList.newBuilder();
        OperaExec.buildPayload(response, builder);
        ExecProtos.ActionInfoList infoList = builder.build();
        CaseInsensitiveStringSet actions = new CaseInsensitiveStringSet();
        for (ExecProtos.ActionInfoList.ActionInfo info : infoList.getActionInfoListList()) {
            actions.add(info.getName());
        }
        return actions;
    }

    @Override
    public void type(String using) {
        if (using == null) {
            throw new NullPointerException("You must provide something to type");
        }
        if (using.length() == 0) {
            throw new IllegalArgumentException("Can't type empty string");
        }
        if (this.keyIsPressed(OperaKeys.SHIFT.getValue())) {
            using = using.toUpperCase();
        }
        for (int i = 0; i < using.length(); ++i) {
            char ch = using.charAt(i);
            if (Character.isUpperCase(ch)) {
                boolean releaseShift = false;
                if (!this.keyIsPressed(OperaKeys.SHIFT.getValue())) {
                    this.key(OperaKeys.SHIFT.getValue(), false);
                    releaseShift = true;
                }
                this.key(String.valueOf(ch));
                if (!releaseShift) continue;
                this.key(OperaKeys.SHIFT.getValue(), true);
                continue;
            }
            this.key(String.valueOf(ch));
        }
    }

    @Override
    public void mouseAction(int x, int y, OperaMouseKeys ... keys) {
        this.mouseAction(x, y, 1, keys);
    }

    @Override
    public void mouseAction(int x, int y, int count, OperaMouseKeys ... keys) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException(String.format("Element is located outside viewport (%s,%s)", x, y));
        }
        int keyValue = 0;
        for (OperaMouseKeys operaMouseKeys : keys) {
            keyValue |= operaMouseKeys.getValue().intValue();
        }
        ExecProtos.MouseAction.Builder actionBuilder = ExecProtos.MouseAction.newBuilder();
        actionBuilder.setWindowID(this.services.getWindowManager().getActiveWindowId());
        actionBuilder.setX(x);
        actionBuilder.setY(y);
        actionBuilder.setButtonAction(keyValue);
        if (VersionUtil.compare(this.getVersion(), "2.2") >= 0) {
            actionBuilder.setRepeatCount(count);
            this.executeCommand(ExecCommand.SEND_MOUSE_ACTION, (AbstractMessage.Builder<?>)actionBuilder);
        } else {
            for (int i = 0; i < count; ++i) {
                this.executeCommand(ExecCommand.SEND_MOUSE_ACTION, (AbstractMessage.Builder<?>)actionBuilder.clone());
            }
            if (count > 1) {
                try {
                    Thread.sleep(OperaIntervals.MULTIPLE_CLICK_SLEEP.getMs());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Set<String> getActionList() {
        return this.actions;
    }

    @Override
    public void action(String using, int windowID, String ... params) {
        if (!this.actions.contains(using = using.toLowerCase())) {
            throw new WebDriverException("The requested action is not supported: " + using);
        }
        ExecProtos.ActionList.Builder builder = ExecProtos.ActionList.newBuilder();
        ExecProtos.ActionList.Action.Builder actionBuilder = ExecProtos.ActionList.Action.newBuilder();
        actionBuilder.setName(using);
        if (params != null && params.length > 0) {
            actionBuilder.setValue(params[0]);
        }
        if (!this.excludedActions.contains(using)) {
            try {
                actionBuilder.setWindowID(windowID);
            }
            catch (WindowNotFoundException e) {
                logger.warning("Exception from setWindowID: " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
        builder.addActionList(actionBuilder);
        if (this.executeCommand(ExecCommand.EXEC, (AbstractMessage.Builder<?>)builder) == null) {
            throw new WebDriverException("Unexpected error while calling action: " + using);
        }
    }

    @Override
    public void action(String using, int data, String dataString, String dataStringParam) {
        if (!this.actions.contains(using)) {
            throw new UnsupportedCommandException("The requested action is not supported: " + using);
        }
        ExecProtos.ActionList.Builder builder = ExecProtos.ActionList.newBuilder();
        ExecProtos.ActionList.Action.Builder actionBuilder = ExecProtos.ActionList.Action.newBuilder();
        actionBuilder.setName(using);
        actionBuilder.setValue(dataString);
        actionBuilder.setData(data);
        actionBuilder.setStringParam(dataStringParam);
        builder.addActionList(actionBuilder);
        if (this.executeCommand(ExecCommand.EXEC, (AbstractMessage.Builder<?>)builder) == null) {
            throw new WebDriverException("Unexpected error while calling action: " + using);
        }
    }

    @Override
    public void action(String using, String ... params) {
        this.action(using, this.services.getWindowManager().getActiveWindowId(), params);
    }

    @Override
    public void key(String key) {
        this.key(key, false);
        this.key(key, true);
    }

    @Override
    public void key(String key, boolean up) {
        if (up) {
            this.action("_keyup", key);
            this.keys.remove(key.toLowerCase());
        } else {
            this.action("_keydown", key);
            this.keys.add(key.toLowerCase());
        }
    }

    @Override
    public boolean keyIsPressed(String key) {
        return this.keys.contains(key.toLowerCase());
    }

    @Override
    public void releaseKeys() {
        for (String key : this.keys) {
            this.key(key, true);
        }
    }

    @Override
    public ScreenShotReply containsColor(Canvas canvas, long timeout, OperaColors ... colors) {
        ExecProtos.ScreenWatcher.Builder builder = ExecProtos.ScreenWatcher.newBuilder();
        ExecProtos.Area.Builder areaBuilder = ExecProtos.Area.newBuilder();
        areaBuilder.setX(canvas.getX());
        areaBuilder.setY(canvas.getY());
        areaBuilder.setH(canvas.getHeight());
        areaBuilder.setW(canvas.getWidth());
        builder.setArea(areaBuilder);
        int i = 0;
        for (OperaColors color : colors) {
            ExecProtos.ScreenWatcher.ColorSpec.Builder colorSpec = this.convertColor(color.getColour());
            colorSpec.setId(++i);
            builder.addColorSpecList(colorSpec);
        }
        ExecProtos.ScreenWatcherResult result = this.executeScreenWatcher(builder, (int)timeout);
        ImmutableList.Builder matches = ImmutableList.builder();
        for (ExecProtos.ScreenWatcherResult.ColorMatch match : result.getColorMatchListList()) {
            matches.add((Object)new ColorResult(match.getId(), match.getCount()));
        }
        return new ScreenShotReply(result.getMd5(), (List<ColorResult>)matches.build());
    }

    private ExecProtos.ScreenWatcherResult executeScreenWatcher(ExecProtos.ScreenWatcher.Builder builder, int timeout) {
        if (timeout <= 0) {
            timeout = 1;
        }
        builder.setTimeOut(timeout);
        builder.setWindowID(this.services.getWindowManager().getActiveWindowId());
        UmsProtos.Response response = this.executeCommand(ExecCommand.SETUP_SCREEN_WATCHER, (AbstractMessage.Builder<?>)builder, OperaIntervals.RESPONSE_TIMEOUT.getMs() + (long)timeout);
        ExecProtos.ScreenWatcherResult.Builder watcherBuilder = ExecProtos.ScreenWatcherResult.newBuilder();
        OperaExec.buildPayload(response, watcherBuilder);
        return watcherBuilder.build();
    }

    private ExecProtos.ScreenWatcher.ColorSpec.Builder convertColor(OperaColor color) {
        ExecProtos.ScreenWatcher.ColorSpec.Builder builder = ExecProtos.ScreenWatcher.ColorSpec.newBuilder();
        builder.setBlueHigh(color.getHighBlue());
        builder.setGreenHigh(color.getHighGreen());
        builder.setRedHigh(color.getHighRed());
        builder.setBlueLow(color.getLowBlue());
        builder.setGreenLow(color.getLowGreen());
        builder.setRedLow(color.getLowRed());
        return builder;
    }

    @Override
    public ScreenShotReply screenWatcher(Canvas canvas, long timeout, boolean includeImage, String ... hashes) {
        ExecProtos.ScreenWatcher.Builder builder = ExecProtos.ScreenWatcher.newBuilder();
        ExecProtos.Area.Builder areaBuilder = ExecProtos.Area.newBuilder();
        areaBuilder.setX(canvas.getX());
        areaBuilder.setY(canvas.getY());
        areaBuilder.setH(canvas.getHeight());
        areaBuilder.setW(canvas.getWidth());
        builder.setArea(areaBuilder);
        if (hashes.length > 0) {
            builder.addAllMd5List(Arrays.asList(hashes));
        }
        if (!includeImage) {
            builder.setIncludeImage(false);
        }
        ExecProtos.ScreenWatcherResult result = this.executeScreenWatcher(builder, (int)timeout);
        return new ScreenShotReply(result.getMd5(), result.getPng().toByteArray());
    }
}

