/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum ExecMessage implements Message
{
    EXEC(1),
    GET_ACTION_LIST(2),
    SETUP_SCREEN_WATCHER(3),
    SEND_MOUSE_ACTION(5),
    DEFAULT(-1);

    private static final Map<Integer, ExecMessage> lookup;
    private final int code;

    private ExecMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "exec";
    }

    public static ExecMessage get(int code) {
        ExecMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])ExecMessage.values()), (Function)new Function<ExecMessage, Integer>(){

            public Integer apply(ExecMessage message) {
                return message.getID();
            }
        });
    }
}

