/*
Copyright 2008-2011 Opera Software ASA

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.opera.core.systems.runner;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class OperaLaunchers {

    public static final Map<String,String> LAUNCHER_CHECKSUMS =
      new ImmutableMap.Builder<String, String>()
          .put("launcher-linux-ia32", "c8e2a35855323bc2b5f05851af1588b5")
          .put("launcher-win32-i86pc.exe", "471167643016e8b2f444e8f5ca380af1")
          .put("launcher-mac", "6f7e97c699b50f0191a087e35e74c701")
          .put("launcher-linux-amd64", "f1307207365341d687e1c48aac2d2dcd")
          .put("launcher-linux-arm", "94b6bba06abbdc3e489ef29329844375")
      .build();
}
