/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AsciiListItem;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class AbstractAsciiListItem
implements AsciiListItem {
    protected final Object content;

    public AbstractAsciiListItem(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        Validate.notBlank((CharSequence)content.toString());
        this.content = content;
    }

    @Override
    public String render(int preLabelIndent, String preLabelStr, String label, String postLabelStr, int postLabelIndent) {
        StrBuilder ret = new StrBuilder(50);
        ret.appendPadding(preLabelIndent, ' ').append(preLabelStr);
        ret.append(label);
        ret.append(postLabelStr).appendPadding(postLabelIndent, ' ');
        ret.append(this.content);
        return ret.toString();
    }

    @Override
    public Object getContent() {
        return this.content;
    }
}

