/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import edu.psu.swe.scim.common.ScimUtils;
import edu.psu.swe.scim.server.exception.InvalidProviderException;
import edu.psu.swe.scim.server.exception.UnableToRetrieveExtensionsException;
import edu.psu.swe.scim.server.provider.Provider;
import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.annotation.ScimAttribute;
import edu.psu.swe.scim.spec.annotation.ScimExtensionType;
import edu.psu.swe.scim.spec.annotation.ScimResourceIdReference;
import edu.psu.swe.scim.spec.annotation.ScimResourceType;
import edu.psu.swe.scim.spec.annotation.ScimType;
import edu.psu.swe.scim.spec.extension.ScimExtensionRegistry;
import edu.psu.swe.scim.spec.resources.BaseResource;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.ResourceType;
import edu.psu.swe.scim.spec.schema.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlEnumValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class ProviderRegistry {
    private static final Logger log = LoggerFactory.getLogger(ProviderRegistry.class);
    private static final String STRING_TYPE_IDENTIFIER = "class java.lang.String";
    private static final String CHARACTER_ARRAY_TYPE_IDENTIFIER = "class [C";
    private static final String BIG_C_CHARACTER_ARRAY_TYPE_IDENTIFIER = "class [Ljava.lang.Character;";
    private static final String INT_TYPE_IDENTIFIER = "int";
    private static final String INTEGER_TYPE_IDENTIFIER = "class java.lang.Integer";
    private static final String FLOAT_TYPE_IDENTIFIER = "float";
    private static final String BIG_F_FLOAT_TYPE_IDENTIFIER = "class java.lang.Float";
    private static final String DOUBLE_TYPE_IDENTIFIER = "double";
    private static final String BIG_D_DOUBLE_TYPE_IDENTIFIER = "class java.lang.Double";
    private static final String BOOLEAN_TYPE_IDENTIFIER = "boolean";
    private static final String BIG_B_BOOLEAN_TYPE_IDENTIFIER = "class java.lang.Boolean";
    private static final String LOCAL_TIME_TYPE_IDENTIFER = "class java.time.LocalTime";
    private static final String LOCAL_DATE_TYPE_IDENTIFER = "class java.time.LocalDate";
    private static final String LOCAL_DATE_TIME_TYPE_IDENTIFIER = "class java.time.LocalDateTime";
    private static final String DATE_TYPE_IDENTIFIER = "class java.util.Date";
    private static final String BYTE_ARRAY_TYPE_IDENTIFIER = "class [B";
    private static final String RESOURCE_REFERENCE_TYPE_IDENTIFIER = "class edu.psu.swe.scim.spec.schema.ResourceReference$ReferenceType";
    @Inject
    Registry registry;
    @Inject
    ScimExtensionRegistry scimExtensionRegistry;
    private Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> providerMap = new HashMap<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>>();

    public ProviderRegistry() {
    }

    public ProviderRegistry(Registry registry, ScimExtensionRegistry scimExtensionRegistry) {
        this.registry = registry;
        this.scimExtensionRegistry = scimExtensionRegistry;
    }

    public <T extends ScimResource> void registerProvider(Class<T> clazz, Instance<? extends Provider<T>> providerInstance) throws InvalidProviderException, JsonProcessingException, UnableToRetrieveExtensionsException {
        Provider provider = (Provider)providerInstance.get();
        ResourceType resourceType = this.generateResourceType(clazz, provider);
        log.info("Calling addSchema on the base class: {}", clazz);
        this.registry.addSchema(ProviderRegistry.generateBaseSchema(clazz));
        ScimResourceType scimResourceType = clazz.getAnnotation(ScimResourceType.class);
        String schemaUrn = scimResourceType.schema();
        String endpoint = scimResourceType.endpoint();
        this.registry.addScimResourceSchemaUrn(schemaUrn, clazz);
        this.registry.addScimResourceEndPoint(endpoint, clazz);
        List<Class<ScimExtension>> extensionList = provider.getExtensionList();
        if (extensionList != null) {
            for (Class<ScimExtension> scimExtension : extensionList) {
                log.info("Registering a extension of type: " + scimExtension);
                this.scimExtensionRegistry.registerExtension(clazz, scimExtension);
                log.info("Calling addSchema on an extension: " + scimExtension);
                this.registry.addSchema(ProviderRegistry.generateExtensionSchema(scimExtension));
            }
        }
        this.registry.addResourceType(resourceType);
        this.providerMap.put(clazz, providerInstance);
    }

    public <T extends ScimResource> Provider<T> getProvider(Class<T> clazz) {
        Instance<? extends Provider<? extends ScimResource>> providerInstance = this.providerMap.get(clazz);
        if (providerInstance == null) {
            return null;
        }
        return (Provider)providerInstance.get();
    }

    private ResourceType generateResourceType(Class<? extends ScimResource> base, Provider<? extends ScimResource> provider) throws InvalidProviderException, UnableToRetrieveExtensionsException {
        ScimResourceType scimResourceType = base.getAnnotation(ScimResourceType.class);
        if (scimResourceType == null) {
            throw new InvalidProviderException("Missing annotation: ScimResourceType must be at the top of scim resource classes");
        }
        ResourceType resourceType = new ResourceType();
        resourceType.setDescription(scimResourceType.description());
        resourceType.setId(scimResourceType.id());
        resourceType.setName(scimResourceType.name());
        resourceType.setEndpoint(scimResourceType.endpoint());
        resourceType.setSchemaUrn(scimResourceType.schema());
        List<Class<ScimExtension>> extensionList = provider.getExtensionList();
        if (extensionList != null) {
            ArrayList<ResourceType.SchemaExtentionConfiguration> extensionSchemaList = new ArrayList<ResourceType.SchemaExtentionConfiguration>();
            for (Class<ScimExtension> se : extensionList) {
                ScimExtensionType extensionType = se.getAnnotation(ScimExtensionType.class);
                if (extensionType == null) {
                    throw new InvalidProviderException("Missing annotation: ScimExtensionType must be at the top of scim extension classes");
                }
                ResourceType.SchemaExtentionConfiguration ext = new ResourceType.SchemaExtentionConfiguration();
                ext.setRequired(extensionType.required());
                ext.setSchemaUrn(extensionType.id());
                extensionSchemaList.add(ext);
            }
            resourceType.setSchemaExtensions(extensionSchemaList);
        }
        return resourceType;
    }

    public static Schema generateBaseSchema(Class<?> clazz) throws InvalidProviderException {
        List fieldList = ScimUtils.getFieldsUpTo(clazz, BaseResource.class);
        return ProviderRegistry.generateSchema(clazz, fieldList);
    }

    public static Schema generateExtensionSchema(Class<?> clazz) throws InvalidProviderException {
        log.debug("----> In generateExtensionSchema");
        return ProviderRegistry.generateSchema(clazz, ScimUtils.getFieldsUpTo(clazz, Object.class));
    }

    public static Schema generateSchema(Class<?> clazz, List<Field> fieldList) throws InvalidProviderException {
        Schema schema = new Schema();
        ScimResourceType srt = clazz.getAnnotation(ScimResourceType.class);
        ScimExtensionType set = clazz.getAnnotation(ScimExtensionType.class);
        if (srt == null && set == null) {
            log.error("Neither a ScimResourceType or ScimExtensionType annotation found");
        }
        log.debug("calling set attributes with " + fieldList.size() + " fields");
        HashSet<String> invalidAttributes = new HashSet<String>();
        List<Schema.Attribute> createAttributes = ProviderRegistry.createAttributes(fieldList, invalidAttributes, clazz.getSimpleName());
        schema.setAttributes(createAttributes);
        if (!invalidAttributes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Scim attributes cannot be primitive types unless they are required.  The following values were found that are primitive and not required\n\n");
            for (String s : invalidAttributes) {
                sb.append(s);
                sb.append("\n");
            }
            throw new InvalidProviderException(sb.toString());
        }
        if (srt != null) {
            schema.setId(srt.schema());
            schema.setDescription(srt.description());
            schema.setName(srt.name());
        } else {
            schema.setId(set.id());
            schema.setDescription(set.description());
            schema.setName(set.name());
        }
        return schema;
    }

    private static List<Schema.Attribute> createAttributes(List<Field> fieldList, Set<String> invalidAttributes, String nameBase) throws InvalidProviderException {
        ArrayList<Schema.Attribute> attributeList = new ArrayList<Schema.Attribute>();
        for (Field f : fieldList) {
            ScimAttribute sa = f.getAnnotation(ScimAttribute.class);
            log.debug("++++++++++++++++++++ Processing field " + f.getName());
            if (sa == null) {
                log.debug("Attribute " + f.getName() + " did not have a ScimAttribute annotation");
                continue;
            }
            f.setAccessible(true);
            String attributeName = sa.name() == null || sa.name().isEmpty() ? f.getName() : sa.name();
            if (f.getType().isPrimitive() && !sa.required()) {
                invalidAttributes.add(nameBase + "." + attributeName);
                continue;
            }
            Schema.Attribute attribute = new Schema.Attribute();
            attribute.setField(f);
            attribute.setName(attributeName);
            List<String> canonicalTypes = null;
            Field[] enumFields = sa.canonicalValueEnum().getFields();
            log.debug("Gathered fields of off the enum, there are " + enumFields.length + " " + sa.canonicalValueEnum().getName());
            if (enumFields.length != 0) {
                if (sa.canonicalValueList().length != 1 && !sa.canonicalValueList()[0].isEmpty()) {
                    throw new InvalidProviderException("You cannont set both the canonicalEnumValue and canonicalValueList attributes on the same ScimAttribute");
                }
                canonicalTypes = new ArrayList<String>();
                for (Field field : enumFields) {
                    XmlEnumValue[] annotation = (XmlEnumValue[])field.getAnnotationsByType(XmlEnumValue.class);
                    if (annotation.length != 0) {
                        canonicalTypes.add(annotation[0].value());
                        continue;
                    }
                    canonicalTypes.add(field.getName());
                }
            } else {
                canonicalTypes = Arrays.asList(sa.canonicalValueList());
            }
            if (canonicalTypes.isEmpty() || canonicalTypes.size() == 1 && canonicalTypes.get(0).isEmpty()) {
                attribute.setCanonicalValues(null);
            } else {
                attribute.setCanonicalValues(new HashSet<String>(canonicalTypes));
            }
            attribute.setCaseExact(sa.caseExact());
            attribute.setDescription(sa.description());
            String typeName = null;
            if (Collection.class.isAssignableFrom(f.getType())) {
                log.debug("We have a collection");
                ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
                Class attributeContainedClass = (Class)stringListType.getActualTypeArguments()[0];
                typeName = attributeContainedClass.getTypeName();
                attribute.setMultiValued(true);
            } else if (f.getType().isArray()) {
                log.debug("We have an array");
                Class<?> componentType = f.getType().getComponentType();
                typeName = componentType.getTypeName();
                attribute.setMultiValued(true);
            } else {
                typeName = f.getType().toString();
                attribute.setMultiValued(false);
            }
            boolean attributeIsAString = false;
            log.debug("Attempting to set the attribute type, raw value = " + typeName);
            switch (typeName) {
                case "class java.lang.String": 
                case "class [C": 
                case "class [Ljava.lang.Character;": {
                    log.debug("Setting type to String");
                    attribute.setType(Schema.Attribute.Type.STRING);
                    attributeIsAString = true;
                    break;
                }
                case "int": 
                case "class java.lang.Integer": {
                    log.debug("Setting type to integer");
                    attribute.setType(Schema.Attribute.Type.INTEGER);
                    break;
                }
                case "float": 
                case "class java.lang.Float": 
                case "double": 
                case "class java.lang.Double": {
                    log.debug("Setting type to decimal");
                    attribute.setType(Schema.Attribute.Type.DECIMAL);
                    break;
                }
                case "boolean": 
                case "class java.lang.Boolean": {
                    log.debug("Setting type to boolean");
                    attribute.setType(Schema.Attribute.Type.BOOLEAN);
                    break;
                }
                case "class [B": {
                    log.debug("Setting type to binary");
                    attribute.setType(Schema.Attribute.Type.BINARY);
                    break;
                }
                case "class java.util.Date": 
                case "class java.time.LocalDateTime": 
                case "class java.time.LocalTime": 
                case "class java.time.LocalDate": {
                    log.debug("Setting type to date time");
                    attribute.setType(Schema.Attribute.Type.DATE_TIME);
                    break;
                }
                case "class edu.psu.swe.scim.spec.schema.ResourceReference$ReferenceType": {
                    log.debug("Setting type to reference");
                    attribute.setType(Schema.Attribute.Type.REFERENCE);
                    break;
                }
                default: {
                    log.debug("Setting type to complex");
                    attribute.setType(Schema.Attribute.Type.COMPLEX);
                }
            }
            if (f.getAnnotation(ScimResourceIdReference.class) != null) {
                if (attributeIsAString) {
                    attribute.setScimResourceIdReference(true);
                } else {
                    log.warn("Field annotated with @edu.psu.swe.scim.spec.annotation.ScimResourceIdReference must be a string: {}", (Object)f);
                }
            }
            attribute.setMutability(sa.mutability());
            List<String> refType = Arrays.asList(sa.referenceTypes());
            if (refType.isEmpty() || refType.size() == 1 && refType.get(0).isEmpty()) {
                attribute.setReferenceTypes(null);
            } else {
                attribute.setReferenceTypes(Arrays.asList(sa.referenceTypes()));
            }
            attribute.setRequired(sa.required());
            attribute.setReturned(sa.returned());
            attribute.setUniqueness(sa.uniqueness());
            ScimType st = f.getType().getAnnotation(ScimType.class);
            if (attribute.getType() == Schema.Attribute.Type.COMPLEX || st != null) {
                Class componentType;
                if (!attribute.isMultiValued()) {
                    componentType = f.getType();
                    attribute.setSubAttributes(ProviderRegistry.createAttributes(Arrays.asList(f.getType().getDeclaredFields()), invalidAttributes, nameBase + "." + f.getName()), Schema.Attribute.AddAction.APPEND);
                } else if (f.getType().isArray()) {
                    componentType = f.getType().getComponentType();
                } else {
                    ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
                    componentType = (Class)stringListType.getActualTypeArguments()[0];
                }
                List fl = ScimUtils.getFieldsUpTo(componentType, Object.class);
                List<Schema.Attribute> la = ProviderRegistry.createAttributes(fl, invalidAttributes, nameBase + "." + f.getName());
                attribute.setSubAttributes(la, Schema.Attribute.AddAction.APPEND);
            }
            attributeList.add(attribute);
        }
        log.debug("Returning " + attributeList.size() + " attributes");
        return attributeList;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ScimExtensionRegistry getScimExtensionRegistry() {
        return this.scimExtensionRegistry;
    }

    public Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> getProviderMap() {
        return this.providerMap;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setScimExtensionRegistry(ScimExtensionRegistry scimExtensionRegistry) {
        this.scimExtensionRegistry = scimExtensionRegistry;
    }

    public void setProviderMap(Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> providerMap) {
        this.providerMap = providerMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderRegistry)) {
            return false;
        }
        ProviderRegistry other = (ProviderRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Registry this$registry = this.getRegistry();
        Registry other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        ScimExtensionRegistry this$scimExtensionRegistry = this.getScimExtensionRegistry();
        ScimExtensionRegistry other$scimExtensionRegistry = other.getScimExtensionRegistry();
        if (this$scimExtensionRegistry == null ? other$scimExtensionRegistry != null : !this$scimExtensionRegistry.equals(other$scimExtensionRegistry)) {
            return false;
        }
        Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> this$providerMap = this.getProviderMap();
        Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> other$providerMap = other.getProviderMap();
        return !(this$providerMap == null ? other$providerMap != null : !((Object)this$providerMap).equals(other$providerMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProviderRegistry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Registry $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        ScimExtensionRegistry $scimExtensionRegistry = this.getScimExtensionRegistry();
        result = result * 59 + ($scimExtensionRegistry == null ? 43 : $scimExtensionRegistry.hashCode());
        Map<Class<? extends ScimResource>, Instance<? extends Provider<? extends ScimResource>>> $providerMap = this.getProviderMap();
        result = result * 59 + ($providerMap == null ? 43 : ((Object)$providerMap).hashCode());
        return result;
    }

    public String toString() {
        return "ProviderRegistry(registry=" + this.getRegistry() + ", scimExtensionRegistry=" + this.getScimExtensionRegistry() + ", providerMap=" + this.getProviderMap() + ")";
    }
}

