/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.utility;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import edu.psu.swe.scim.server.exception.AttributeDoesNotExistException;
import edu.psu.swe.scim.server.rest.ScimResourceDeserializer;
import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.AttributeContainer;
import edu.psu.swe.scim.spec.schema.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class AttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(AttributeUtil.class);
    @Inject
    Registry registry;
    ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
        this.objectMapper.registerModule((Module)jaxbAnnotationModule);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(this.objectMapper.getTypeFactory());
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
        this.objectMapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ScimResource.class, (JsonDeserializer)new ScimResourceDeserializer(this.registry, this.objectMapper));
        this.objectMapper.registerModule((Module)module);
    }

    public <T extends ScimResource> T keepAlwaysAttributesForDisplay(T resource) throws IllegalArgumentException, IllegalAccessException, AttributeDoesNotExistException, IOException {
        return this.setAttributesForDisplayInternal(resource, Schema.Attribute.Returned.DEFAULT, Schema.Attribute.Returned.REQUEST, Schema.Attribute.Returned.NEVER);
    }

    public <T extends ScimResource> T setAttributesForDisplay(T resource) throws IllegalArgumentException, IllegalAccessException, AttributeDoesNotExistException, IOException {
        return this.setAttributesForDisplayInternal(resource, Schema.Attribute.Returned.REQUEST, Schema.Attribute.Returned.NEVER);
    }

    private <T extends ScimResource> T setAttributesForDisplayInternal(T resource, Schema.Attribute.Returned ... removeAttributesOfTypes) throws IllegalArgumentException, IllegalAccessException, AttributeDoesNotExistException, IOException {
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.registry.getBaseSchemaOfResourceType(resourceType);
        for (Schema.Attribute.Returned removeAttributesOfType : removeAttributesOfTypes) {
            this.removeAttributesOfType(copy, (AttributeContainer)schema, removeAttributesOfType);
        }
        for (Map.Entry entry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)entry.getKey();
            ScimExtension scimExtension = (ScimExtension)entry.getValue();
            Schema extensionSchema = this.registry.getSchema(extensionUrn);
            for (Schema.Attribute.Returned removeAttributesOfType : removeAttributesOfTypes) {
                this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, removeAttributesOfType);
            }
        }
        return copy;
    }

    public <T extends ScimResource> T setAttributesForDisplay(T resource, Set<AttributeReference> attributes) throws IllegalArgumentException, IllegalAccessException, AttributeDoesNotExistException, IOException {
        if (attributes.isEmpty()) {
            return this.setAttributesForDisplay(resource);
        }
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.registry.getBaseSchemaOfResourceType(resourceType);
        Set<Schema.Attribute> attributesToKeep = this.resolveAttributeReferences(attributes, true);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.DEFAULT, attributesToKeep);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.REQUEST, attributesToKeep);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.NEVER);
        for (Map.Entry extensionEntry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)extensionEntry.getKey();
            ScimExtension scimExtension = (ScimExtension)extensionEntry.getValue();
            Schema extensionSchema = this.registry.getSchema(extensionUrn);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.DEFAULT, attributesToKeep);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.REQUEST, attributesToKeep);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.NEVER);
        }
        return copy;
    }

    public <T extends ScimResource> T setExcludedAttributesForDisplay(T resource, Set<AttributeReference> excludedAttributes) throws IllegalArgumentException, IllegalAccessException, AttributeDoesNotExistException, IOException {
        if (excludedAttributes.isEmpty()) {
            return this.setAttributesForDisplay(resource);
        }
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.registry.getBaseSchemaOfResourceType(resourceType);
        Set<Schema.Attribute> attributesToRemove = this.resolveAttributeReferences(excludedAttributes, false);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.REQUEST);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.NEVER);
        this.removeAttributes(copy, (AttributeContainer)schema, attributesToRemove);
        for (Map.Entry extensionEntry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)extensionEntry.getKey();
            ScimExtension scimExtension = (ScimExtension)extensionEntry.getValue();
            Schema extensionSchema = this.registry.getSchema(extensionUrn);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.REQUEST);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.NEVER);
            this.removeAttributes(scimExtension, (AttributeContainer)extensionSchema, attributesToRemove);
        }
        return copy;
    }

    private <T extends ScimResource> T cloneScimResource(T original) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(boas);
        oos.writeObject(original);
        ByteArrayInputStream bais = new ByteArrayInputStream(boas.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        ScimResource copy = null;
        try {
            copy = (ScimResource)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            log.error("", (Throwable)e);
        }
        return (T)copy;
    }

    private void removeAttributesOfType(Object object, AttributeContainer attributeContainer, Schema.Attribute.Returned returned) throws IllegalArgumentException, IllegalAccessException {
        Function<Schema.Attribute, Boolean> function = attribute -> returned == attribute.getReturned();
        this.processAttributes(object, attributeContainer, function);
    }

    private void removeAttributesOfType(Object object, AttributeContainer attributeContainer, Schema.Attribute.Returned returned, Set<Schema.Attribute> attributesToKeep) throws IllegalArgumentException, IllegalAccessException {
        Function<Schema.Attribute, Boolean> function = attribute -> !attributesToKeep.contains(attribute) && returned == attribute.getReturned();
        this.processAttributes(object, attributeContainer, function);
    }

    private void removeAttributes(Object object, AttributeContainer attributeContainer, Set<Schema.Attribute> attributesToRemove) throws IllegalArgumentException, IllegalAccessException {
        Function<Schema.Attribute, Boolean> function = attribute -> attributesToRemove.contains(attribute);
        this.processAttributes(object, attributeContainer, function);
    }

    private void processAttributes(Object object, AttributeContainer attributeContainer, Function<Schema.Attribute, Boolean> function) throws IllegalArgumentException, IllegalAccessException {
        if (attributeContainer != null && object != null) {
            for (Schema.Attribute attribute : attributeContainer.getAttributes()) {
                Object[] array;
                Object subObject;
                String name;
                Field field = attribute.getField();
                if (function.apply(attribute).booleanValue()) {
                    Object obj;
                    field.setAccessible(true);
                    if (field.getType().isPrimitive() || (obj = field.get(object)) == null) continue;
                    log.info("field to be set to null = " + field.getType().getName());
                    field.set(object, null);
                    continue;
                }
                if (!attribute.isMultiValued() && attribute.getType() == Schema.Attribute.Type.COMPLEX) {
                    name = field.getName();
                    log.debug("### Processing single value complex field " + name);
                    field.setAccessible(true);
                    subObject = field.get(object);
                    if (subObject == null) continue;
                    Schema.Attribute subAttribute = attributeContainer.getAttribute(name);
                    log.debug("### container type = " + attributeContainer.getClass().getName());
                    if (subAttribute == null) {
                        log.debug("#### subattribute == null");
                    }
                    this.processAttributes(subObject, (AttributeContainer)subAttribute, function);
                    continue;
                }
                if (!attribute.isMultiValued() || attribute.getType() != Schema.Attribute.Type.COMPLEX) continue;
                name = field.getName();
                log.debug("### Processing multi-valued complex field " + name);
                field.setAccessible(true);
                subObject = field.get(object);
                if (subObject == null) continue;
                if (Collection.class.isAssignableFrom(subObject.getClass())) {
                    Collection collection = (Collection)subObject;
                    for (Object o : collection) {
                        Schema.Attribute subAttribute = attributeContainer.getAttribute(name);
                        this.processAttributes(o, (AttributeContainer)subAttribute, function);
                    }
                    continue;
                }
                if (!field.getType().isArray()) continue;
                for (Object o : array = (Object[])subObject) {
                    Schema.Attribute subAttribute = attributeContainer.getAttribute(name);
                    this.processAttributes(o, (AttributeContainer)subAttribute, function);
                }
            }
        }
    }

    public Set<AttributeReference> getAttributeReferences(String s) {
        String[] split;
        HashSet<AttributeReference> attributeReferences = new HashSet<AttributeReference>();
        for (String af : split = StringUtils.split((String)s, (String)",")) {
            AttributeReference attributeReference = new AttributeReference(af);
            attributeReferences.add(attributeReference);
        }
        return attributeReferences;
    }

    private Set<Schema.Attribute> resolveAttributeReferences(Set<AttributeReference> attributeReferences, boolean includeAttributeChain) throws AttributeDoesNotExistException {
        HashSet<Schema.Attribute> attributes = new HashSet<Schema.Attribute>();
        for (AttributeReference attributeReference : attributeReferences) {
            Set<Schema.Attribute> findAttributes = this.findAttribute(attributeReference, includeAttributeChain);
            if (findAttributes.isEmpty()) continue;
            attributes.addAll(findAttributes);
        }
        return attributes;
    }

    private Set<Schema.Attribute> findAttribute(AttributeReference attributeReference, boolean includeAttributeChain) throws AttributeDoesNotExistException {
        String schemaUrn = attributeReference.getUrn();
        Schema schema = null;
        if (!StringUtils.isEmpty((CharSequence)schemaUrn)) {
            schema = this.registry.getSchema(schemaUrn);
            Set<Schema.Attribute> attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
            if (attributes.isEmpty()) {
                log.error("Attribute " + attributeReference.getFullyQualifiedAttributeName() + "not found in schema " + schemaUrn);
                throw new AttributeDoesNotExistException(attributeReference.getFullyQualifiedAttributeName());
            }
            return attributes;
        }
        schema = this.registry.getSchema("urn:ietf:params:scim:schemas:core:2.0:User");
        Set<Schema.Attribute> attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
        if (!attributes.isEmpty()) {
            return attributes;
        }
        schema = this.registry.getSchema("urn:ietf:params:scim:schemas:core:2.0:Group");
        attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
        if (!attributes.isEmpty()) {
            return attributes;
        }
        log.error("Attribute " + attributeReference.getFullyQualifiedAttributeName() + "not found in any schema.");
        throw new AttributeDoesNotExistException(attributeReference.getFullyQualifiedAttributeName());
    }

    private Set<Schema.Attribute> findAttributeInSchema(Schema schema, AttributeReference attributeReference, boolean includeAttributeChain) {
        Schema attributeContainer = schema;
        if (attributeContainer == null) {
            return Collections.emptySet();
        }
        String[] attributeNames = attributeReference.getAttributeName();
        HashSet<Schema.Attribute> attributes = new HashSet<Schema.Attribute>();
        for (String attributeName : attributeNames) {
            if ((attributeContainer = attributeContainer.getAttribute(attributeName)) == null) {
                return Collections.emptySet();
            }
            if (!includeAttributeChain) continue;
            Schema.Attribute attribute = (Schema.Attribute)attributeContainer;
            attributes.add(attribute);
        }
        Schema.Attribute attribute = (Schema.Attribute)attributeContainer;
        attributes.add(attribute);
        if (attribute.getType() == Schema.Attribute.Type.COMPLEX && includeAttributeChain) {
            List remaininAttributes = attribute.getAttributes();
            attributes.addAll(remaininAttributes);
        }
        return attributes;
    }
}

