/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.data;

import edu.psu.swe.scim.server.filter.FilterLexer;
import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.data.PatchPathListener;
import edu.psu.swe.scim.spec.protocol.filter.FilterParseException;
import edu.psu.swe.scim.spec.protocol.filter.ValueFilterExpression;
import java.util.Arrays;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchOperationPath {
    private static final Logger log = LoggerFactory.getLogger(PatchOperationPath.class);
    private AttributeReference attributeReference;
    private ValueFilterExpression valueFilterExpression;
    private String[] subAttributes;

    public PatchOperationPath() {
    }

    public PatchOperationPath(String patchPath) throws FilterParseException {
        this.parsePatchPath(patchPath);
    }

    protected void parsePatchPath(String patchPath) throws FilterParseException {
        FilterLexer l = new FilterLexer((CharStream)new ANTLRInputStream(patchPath));
        FilterParser p = new FilterParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.setBuildParseTree(true);
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, (Throwable)e);
            }
        });
        try {
            FilterParser.PatchPathContext tree = p.patchPath();
            PatchPathListener patchPathListener = new PatchPathListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)patchPathListener, (ParseTree)tree);
            this.attributeReference = patchPathListener.getAttributeReference();
            this.valueFilterExpression = patchPathListener.getValueFilter();
            this.subAttributes = patchPathListener.getSubAttributes();
        }
        catch (IllegalStateException e) {
            throw new FilterParseException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeReference.getFullyQualifiedAttributeName());
        if (this.valueFilterExpression != null) {
            sb.append("[").append(this.valueFilterExpression.toFilter()).append("]");
        }
        if (this.subAttributes != null) {
            for (String subAttribute : this.subAttributes) {
                sb.append(".").append(subAttribute);
            }
        }
        return sb.toString();
    }

    public AttributeReference getAttributeReference() {
        return this.attributeReference;
    }

    public ValueFilterExpression getValueFilterExpression() {
        return this.valueFilterExpression;
    }

    public String[] getSubAttributes() {
        return this.subAttributes;
    }

    public void setAttributeReference(AttributeReference attributeReference) {
        this.attributeReference = attributeReference;
    }

    public void setValueFilterExpression(ValueFilterExpression valueFilterExpression) {
        this.valueFilterExpression = valueFilterExpression;
    }

    public void setSubAttributes(String[] subAttributes) {
        this.subAttributes = subAttributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatchOperationPath)) {
            return false;
        }
        PatchOperationPath other = (PatchOperationPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AttributeReference this$attributeReference = this.getAttributeReference();
        AttributeReference other$attributeReference = other.getAttributeReference();
        if (this$attributeReference == null ? other$attributeReference != null : !((Object)this$attributeReference).equals(other$attributeReference)) {
            return false;
        }
        ValueFilterExpression this$valueFilterExpression = this.getValueFilterExpression();
        ValueFilterExpression other$valueFilterExpression = other.getValueFilterExpression();
        if (this$valueFilterExpression == null ? other$valueFilterExpression != null : !this$valueFilterExpression.equals(other$valueFilterExpression)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubAttributes(), other.getSubAttributes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PatchOperationPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributeReference = this.getAttributeReference();
        result = result * 59 + ($attributeReference == null ? 43 : ((Object)$attributeReference).hashCode());
        ValueFilterExpression $valueFilterExpression = this.getValueFilterExpression();
        result = result * 59 + ($valueFilterExpression == null ? 43 : $valueFilterExpression.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubAttributes());
        return result;
    }
}

