/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.server.filter.FilterBaseListener;
import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.AttributeComparisonExpression;
import edu.psu.swe.scim.spec.protocol.filter.AttributePresentExpression;
import edu.psu.swe.scim.spec.protocol.filter.CompareOperator;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.GroupExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalOperator;
import edu.psu.swe.scim.spec.protocol.filter.ValueFilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.ValuePathExpression;
import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionBuildingListener
extends FilterBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionBuildingListener.class);
    protected Deque<FilterExpression> expressionStack = new ArrayDeque<FilterExpression>();
    private int indent = -1;

    @Override
    public void enterFilterLogicExp(FilterParser.FilterLogicExpContext ctx) {
        LOG.debug(this.indent("--- Enter FilterLogicExp -->"));
    }

    @Override
    public void exitFilterLogicExp(FilterParser.FilterLogicExpContext ctx) {
        LOG.debug(this.indent("<-- Exit FilterLogicExp ---"));
        LogicalOperator logicalOperator = LogicalOperator.valueOf(ctx.op.getText().toUpperCase());
        FilterExpression right = this.expressionStack.pop();
        FilterExpression left = this.expressionStack.pop();
        LogicalExpression expression = new LogicalExpression(left, logicalOperator, right);
        this.expressionStack.push(expression);
    }

    @Override
    public void enterPatchPath(FilterParser.PatchPathContext ctx) {
        LOG.debug(this.indent("--- Enter PatchPath -->"));
    }

    @Override
    public void exitPatchPath(FilterParser.PatchPathContext ctx) {
        LOG.debug(this.indent("<-- Exit PatchPath ---"));
    }

    @Override
    public void enterFilterValuePath(FilterParser.FilterValuePathContext ctx) {
        LOG.debug(this.indent("--- Enter FilterValuePath -->"));
    }

    @Override
    public void exitFilterValuePath(FilterParser.FilterValuePathContext ctx) {
        LOG.debug(this.indent("<-- Exit FilterValuePath ---"));
    }

    @Override
    public void enterFilterAttrExp(FilterParser.FilterAttrExpContext ctx) {
        LOG.debug(this.indent("--- Enter FilterAttrExp -->"));
    }

    @Override
    public void exitFilterAttrExp(FilterParser.FilterAttrExpContext ctx) {
        LOG.debug(this.indent("<-- Exit FilterAttrExp ---"));
    }

    @Override
    public void enterFilterGroupExp(FilterParser.FilterGroupExpContext ctx) {
        LOG.debug(this.indent("--- Enter FilterGroupExp -->"));
    }

    @Override
    public void exitFilterGroupExp(FilterParser.FilterGroupExpContext ctx) {
        LOG.debug(this.indent("<-- Exit FilterGroupExp ---"));
        if (ctx.not != null) {
            FilterExpression pop = this.expressionStack.pop();
            GroupExpression expression = new GroupExpression(true, pop);
            this.expressionStack.push(expression);
        }
    }

    @Override
    public void enterValuePath(FilterParser.ValuePathContext ctx) {
        LOG.debug(this.indent("--- Enter ValuePath -->"));
    }

    @Override
    public void exitValuePath(FilterParser.ValuePathContext ctx) {
        LOG.debug(this.indent("<-- Exit ValuePath ---"));
        String attrPath = ctx.attrPath.getText();
        AttributeReference attrRef = new AttributeReference(attrPath);
        ValueFilterExpression valueFilter = (ValueFilterExpression)((Object)this.expressionStack.pop());
        ValuePathExpression expression = new ValuePathExpression(attrRef, valueFilter);
        this.expressionStack.push(expression);
    }

    @Override
    public void enterValFilterAttrExp(FilterParser.ValFilterAttrExpContext ctx) {
        LOG.debug(this.indent("--- Enter ValFilterAttrExp -->"));
    }

    @Override
    public void exitValFilterAttrExp(FilterParser.ValFilterAttrExpContext ctx) {
        LOG.debug(this.indent("<-- Exit ValFilterAttrExp ---"));
    }

    @Override
    public void enterValFilterLogicExp(FilterParser.ValFilterLogicExpContext ctx) {
        LOG.debug(this.indent("--- Enter ValFilterLogicExp -->"));
    }

    @Override
    public void exitValFilterLogicExp(FilterParser.ValFilterLogicExpContext ctx) {
        LOG.debug(this.indent("<-- Exit ValFilterLogicExp ---"));
        LogicalOperator logicalOperator = LogicalOperator.valueOf(ctx.op.getText().toUpperCase());
        FilterExpression right = this.expressionStack.pop();
        FilterExpression left = this.expressionStack.pop();
        LogicalExpression expression = new LogicalExpression(left, logicalOperator, right);
        this.expressionStack.push(expression);
    }

    @Override
    public void enterValFilterGroupExp(FilterParser.ValFilterGroupExpContext ctx) {
        LOG.debug(this.indent("--- Enter ValFilterGroupExp -->"));
    }

    @Override
    public void exitValFilterGroupExp(FilterParser.ValFilterGroupExpContext ctx) {
        LOG.debug(this.indent("<-- Exit ValFilterGroupExp ---"));
        if (ctx.not != null) {
            FilterExpression pop = this.expressionStack.pop();
            GroupExpression expression = new GroupExpression(true, pop);
            this.expressionStack.push(expression);
        }
    }

    @Override
    public void enterAttrExpPresent(FilterParser.AttrExpPresentContext ctx) {
        LOG.debug(this.indent("--- Enter AttrExpPresent -->"));
    }

    @Override
    public void exitAttrExpPresent(FilterParser.AttrExpPresentContext ctx) {
        LOG.debug(this.indent("<-- Exit AttrExpPresent ---"));
        String attrPath = ctx.attrPath.getText();
        AttributeReference attrRef = new AttributeReference(attrPath);
        AttributePresentExpression expression = new AttributePresentExpression(attrRef);
        this.expressionStack.push(expression);
    }

    @Override
    public void enterAttrExpCompareOp(FilterParser.AttrExpCompareOpContext ctx) {
        LOG.debug(this.indent("--- Enter AttrExpCompareOp -->"));
    }

    @Override
    public void exitAttrExpCompareOp(FilterParser.AttrExpCompareOpContext ctx) {
        LOG.debug(this.indent("<-- Exit AttrExpCompareOp ---"));
        String attrPath = ctx.attrPath.getText();
        AttributeReference attrRef = new AttributeReference(attrPath);
        CompareOperator compareOperator = CompareOperator.valueOf(ctx.op.getText().toUpperCase());
        Object value = this.parseJsonType(ctx.compValue.getText());
        AttributeComparisonExpression expression = new AttributeComparisonExpression(attrRef, compareOperator, value);
        this.expressionStack.push(expression);
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        ++this.indent;
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        --this.indent;
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        String text = node.getText();
        if (StringUtils.isNotEmpty((CharSequence)text.trim())) {
            LOG.debug(this.indent(text));
        }
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        LOG.error(this.indent(node.getText()));
    }

    protected String indent(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("    ");
        }
        sb.append(s);
        return sb.toString();
    }

    public FilterExpression getFilterExpression() {
        return this.expressionStack.peek();
    }

    private Object parseJsonType(String jsonValue) {
        if (jsonValue.startsWith("\"") && jsonValue.endsWith("\"")) {
            return jsonValue.substring(1, jsonValue.length() - 1);
        }
        if ("null".equals(jsonValue)) {
            return null;
        }
        if ("true".equals(jsonValue)) {
            return true;
        }
        if ("false".equals(jsonValue)) {
            return false;
        }
        try {
            return Double.parseDouble(jsonValue);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse a json number: " + jsonValue);
            throw new IllegalStateException("Unable to parse JSON Value");
        }
    }
}

