/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.server.filter.FilterBaseListener;
import edu.psu.swe.scim.server.filter.FilterParser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePrintingListener
extends FilterBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(TreePrintingListener.class);
    private int indent = -1;

    @Override
    public void enterFilterLogicExp(FilterParser.FilterLogicExpContext ctx) {
        LOG.info(this.indent("--- Enter FilterLogicExp -->"));
    }

    @Override
    public void exitFilterLogicExp(FilterParser.FilterLogicExpContext ctx) {
        LOG.info(this.indent("<-- Exit FilterLogicExp ---"));
    }

    @Override
    public void enterFilterValuePath(FilterParser.FilterValuePathContext ctx) {
        LOG.info(this.indent("--- Enter FilterValuePath -->"));
    }

    @Override
    public void exitFilterValuePath(FilterParser.FilterValuePathContext ctx) {
        LOG.info(this.indent("<-- Exit FilterValuePath ---"));
    }

    @Override
    public void enterFilterAttrExp(FilterParser.FilterAttrExpContext ctx) {
        LOG.info(this.indent("--- Enter FilterAttrExp -->"));
    }

    @Override
    public void exitFilterAttrExp(FilterParser.FilterAttrExpContext ctx) {
        LOG.info(this.indent("<-- Exit FilterAttrExp ---"));
    }

    @Override
    public void enterFilterGroupExp(FilterParser.FilterGroupExpContext ctx) {
        LOG.info(this.indent("--- Enter FilterGroupExp -->"));
    }

    @Override
    public void exitFilterGroupExp(FilterParser.FilterGroupExpContext ctx) {
        LOG.info(this.indent("<-- Exit FilterGroupExp ---"));
    }

    @Override
    public void enterValuePath(FilterParser.ValuePathContext ctx) {
        LOG.info(this.indent("--- Enter ValuePath -->"));
    }

    @Override
    public void exitValuePath(FilterParser.ValuePathContext ctx) {
        LOG.info(this.indent("<-- Exit ValuePath ---"));
    }

    @Override
    public void enterValFilterAttrExp(FilterParser.ValFilterAttrExpContext ctx) {
        LOG.info(this.indent("--- Enter ValFilterAttrExp -->"));
    }

    @Override
    public void exitValFilterAttrExp(FilterParser.ValFilterAttrExpContext ctx) {
        LOG.info(this.indent("<-- Exit ValFilterAttrExp ---"));
    }

    @Override
    public void enterValFilterLogicExp(FilterParser.ValFilterLogicExpContext ctx) {
        LOG.info(this.indent("--- Enter ValFilterLogicExp -->"));
    }

    @Override
    public void exitValFilterLogicExp(FilterParser.ValFilterLogicExpContext ctx) {
        LOG.info(this.indent("<-- Exit ValFilterLogicExp ---"));
    }

    @Override
    public void enterValFilterGroupExp(FilterParser.ValFilterGroupExpContext ctx) {
        LOG.info(this.indent("--- Enter ValFilterGroupExp -->"));
    }

    @Override
    public void exitValFilterGroupExp(FilterParser.ValFilterGroupExpContext ctx) {
        LOG.info(this.indent("<-- Exit ValFilterGroupExp ---"));
    }

    @Override
    public void enterAttrExpPresent(FilterParser.AttrExpPresentContext ctx) {
        LOG.info(this.indent("--- Enter AttrExpPresent -->"));
    }

    @Override
    public void exitAttrExpPresent(FilterParser.AttrExpPresentContext ctx) {
        LOG.info(this.indent("<-- Exit AttrExpPresent ---"));
    }

    @Override
    public void enterAttrExpCompareOp(FilterParser.AttrExpCompareOpContext ctx) {
        LOG.info(this.indent("--- Enter AttrExpCompareOp -->"));
    }

    @Override
    public void exitAttrExpCompareOp(FilterParser.AttrExpCompareOpContext ctx) {
        LOG.info(this.indent("<-- Exit AttrExpCompareOp ---"));
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        ++this.indent;
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        --this.indent;
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        String text = node.getText();
        if (StringUtils.isNotEmpty((CharSequence)text.trim())) {
            LOG.info(this.indent(text));
        }
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        LOG.error(this.indent(node.getText()));
    }

    private String indent(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("    ");
        }
        sb.append(s);
        return sb.toString();
    }
}

