/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.AttributeComparisonExpression;
import edu.psu.swe.scim.spec.protocol.filter.AttributePresentExpression;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.FilterParseException;
import edu.psu.swe.scim.spec.protocol.filter.GroupExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalExpression;
import edu.psu.swe.scim.spec.protocol.filter.ValueFilterExpression;
import java.beans.ConstructorProperties;

public class ValuePathExpression
implements FilterExpression {
    AttributeReference attributePath;
    ValueFilterExpression valueFilter;

    public static ValuePathExpression fromFilterExpression(String attrRef, FilterExpression filterExpression) throws FilterParseException {
        AttributeReference ref = new AttributeReference(attrRef);
        return ValuePathExpression.fromFilterExpression(ref, filterExpression);
    }

    public static ValuePathExpression fromFilterExpression(AttributeReference attrRef, FilterExpression filterExpression) throws FilterParseException {
        ValuePathExpression vpe = new ValuePathExpression();
        vpe.setAttributePath(attrRef);
        if (filterExpression instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)filterExpression;
            vpe.setValueFilter(le);
            return vpe;
        }
        if (filterExpression instanceof GroupExpression) {
            GroupExpression ge = (GroupExpression)filterExpression;
            vpe.setValueFilter(ge);
            return vpe;
        }
        if (filterExpression instanceof AttributePresentExpression) {
            AttributePresentExpression ape = (AttributePresentExpression)filterExpression;
            vpe.setValueFilter(ape);
            return vpe;
        }
        if (filterExpression instanceof AttributeComparisonExpression) {
            AttributeComparisonExpression ace = (AttributeComparisonExpression)filterExpression;
            vpe.setValueFilter(ace);
            return vpe;
        }
        if (filterExpression instanceof ValuePathExpression) {
            throw new FilterParseException("Value path expressions can not own other value path expressions");
        }
        return null;
    }

    @Override
    public String toFilter() {
        return this.attributePath.getFullyQualifiedAttributeName() + "[" + this.valueFilter.toFilter() + "]";
    }

    public AttributeReference getAttributePath() {
        return this.attributePath;
    }

    public ValueFilterExpression getValueFilter() {
        return this.valueFilter;
    }

    public void setAttributePath(AttributeReference attributePath) {
        this.attributePath = attributePath;
    }

    public void setValueFilter(ValueFilterExpression valueFilter) {
        this.valueFilter = valueFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValuePathExpression)) {
            return false;
        }
        ValuePathExpression other = (ValuePathExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AttributeReference this$attributePath = this.getAttributePath();
        AttributeReference other$attributePath = other.getAttributePath();
        if (this$attributePath == null ? other$attributePath != null : !((Object)this$attributePath).equals(other$attributePath)) {
            return false;
        }
        ValueFilterExpression this$valueFilter = this.getValueFilter();
        ValueFilterExpression other$valueFilter = other.getValueFilter();
        return !(this$valueFilter == null ? other$valueFilter != null : !this$valueFilter.equals(other$valueFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValuePathExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributePath = this.getAttributePath();
        result = result * 59 + ($attributePath == null ? 43 : ((Object)$attributePath).hashCode());
        ValueFilterExpression $valueFilter = this.getValueFilter();
        result = result * 59 + ($valueFilter == null ? 43 : $valueFilter.hashCode());
        return result;
    }

    public String toString() {
        return "ValuePathExpression(attributePath=" + this.getAttributePath() + ", valueFilter=" + this.getValueFilter() + ")";
    }

    @ConstructorProperties(value={"attributePath", "valueFilter"})
    public ValuePathExpression(AttributeReference attributePath, ValueFilterExpression valueFilter) {
        this.attributePath = attributePath;
        this.valueFilter = valueFilter;
    }

    public ValuePathExpression() {
    }
}

